/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.CancelCriterion;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.SynchronizationCommitConflictException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.internal.cache.TXState;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class BeforeCompletion {
    private static final Logger logger = LogService.getLogger();
    private boolean started;
    private boolean finished;
    private RuntimeException exception;

    public synchronized void doOp(TXState txState) {
        try {
            txState.doBeforeCompletion();
        }
        catch (SynchronizationCommitConflictException exception) {
            this.exception = exception;
        }
        catch (CacheClosedException exception) {
            this.exception = new TransactionDataNodeHasDepartedException(exception);
        }
        catch (RuntimeException exception) {
            this.exception = new TransactionException(exception);
        }
        finally {
            logger.debug("beforeCompletion notification completed");
            this.finished = true;
            this.notifyAll();
        }
    }

    public synchronized void execute(CancelCriterion cancelCriterion) {
        this.started = true;
        this.waitUntilFinished(cancelCriterion);
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void waitUntilFinished(CancelCriterion cancelCriterion) {
        while (!this.finished) {
            cancelCriterion.checkCancelInProgress(null);
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }
}

