/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheException;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.shiro.subject.Subject;

public class CacheClientProxyFactory {
    @Immutable
    private static final InternalCacheClientProxyFactory DEFAULT = CacheClientProxy::new;
    @Immutable
    @VisibleForTesting
    public static final String INTERNAL_FACTORY_PROPERTY = "gemfire.CacheClientProxyFactory.INTERNAL_FACTORY";
    private final InternalCacheClientProxyFactory internalFactory;

    private static InternalCacheClientProxyFactory factory() {
        String proxyClassName = System.getProperty(INTERNAL_FACTORY_PROPERTY);
        if (proxyClassName == null || proxyClassName.isEmpty()) {
            return DEFAULT;
        }
        try {
            Class proxyClass = (Class)UncheckedUtils.uncheckedCast(ClassPathLoader.getLatest().forName(proxyClassName));
            return (InternalCacheClientProxyFactory)proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return DEFAULT;
        }
    }

    CacheClientProxyFactory() {
        this(CacheClientProxyFactory.factory());
    }

    private CacheClientProxyFactory(InternalCacheClientProxyFactory internalFactory) {
        this.internalFactory = internalFactory;
    }

    public CacheClientProxy create(CacheClientNotifier notifier, Socket socket, ClientProxyMembershipID proxyId, boolean isPrimary, byte clientConflation, KnownVersion clientVersion, long acceptorId, boolean notifyBySubscription, SecurityService securityService, Subject subject, StatisticsClock statisticsClock) throws CacheException {
        return this.internalFactory.create(notifier, socket, proxyId, isPrimary, clientConflation, clientVersion, acceptorId, notifyBySubscription, securityService, subject, statisticsClock);
    }

    @FunctionalInterface
    @VisibleForTesting
    public static interface InternalCacheClientProxyFactory {
        public CacheClientProxy create(CacheClientNotifier var1, Socket var2, ClientProxyMembershipID var3, boolean var4, byte var5, KnownVersion var6, long var7, boolean var9, SecurityService var10, Subject var11, StatisticsClock var12) throws CacheException;
    }
}

