/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.cache.tx.RemoteOperationMessageWithDirectReply;
import org.apache.geode.internal.cache.versions.DiskVersionTag;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RemoteDestroyMessage
extends RemoteOperationMessageWithDirectReply
implements EntryEventImpl.OldValueImporter {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Object cbArg;
    private Operation op;
    ClientProxyMembershipID bridgeContext;
    EventID eventId;
    InternalDistributedMember originalSender;
    private boolean hasOldValue = false;
    private boolean oldValueIsSerialized = false;
    private Object expectedOldValue;
    private byte[] oldValBytes;
    private transient Object oldValObj;
    boolean useOriginRemote;
    protected boolean possibleDuplicate;
    VersionTag<?> versionTag;
    protected static final short USE_ORIGIN_REMOTE = 64;
    protected static final short HAS_OLD_VALUE = 128;
    protected static final short CACHE_WRITE = 256;
    protected static final short HAS_BRIDGE_CONTEXT = 512;
    protected static final short HAS_ORIGINAL_SENDER = 1024;
    protected static final int HAS_VERSION_TAG = 2048;

    public RemoteDestroyMessage() {
    }

    protected RemoteDestroyMessage(DistributedMember recipient, String regionPath, DirectReplyProcessor processor, EntryEventImpl event, Object expectedOldValue, boolean useOriginRemote, boolean possibleDuplicate) {
        super((InternalDistributedMember)recipient, regionPath, processor);
        this.expectedOldValue = expectedOldValue;
        this.key = event.getKey();
        this.cbArg = event.getRawCallbackArgument();
        this.op = event.getOperation();
        this.bridgeContext = event.getContext();
        this.eventId = event.getEventId();
        this.useOriginRemote = useOriginRemote;
        this.possibleDuplicate = possibleDuplicate;
        this.versionTag = event.getVersionTag();
        Assert.assertTrue(this.eventId != null);
        if (event.hasOldValue()) {
            this.hasOldValue = true;
            event.exportOldValue(this);
        }
    }

    private void setOldValBytes(byte[] valBytes) {
        this.oldValBytes = valBytes;
    }

    private void setOldValObj(Object o) {
        this.oldValObj = o;
    }

    public byte[] getOldValueBytes() {
        return this.oldValBytes;
    }

    private Object getOldValObj() {
        return this.oldValObj;
    }

    protected boolean getHasOldValue() {
        return this.hasOldValue;
    }

    protected boolean getOldValueIsSerialized() {
        return this.oldValueIsSerialized;
    }

    public void setOldValue(EntryEventImpl event) {
        if (event.hasOldValue()) {
            this.hasOldValue = true;
            CachedDeserializable cd = (CachedDeserializable)((Object)event.getSerializedOldValue());
            if (cd != null) {
                if (!cd.isSerialized()) {
                    this.oldValueIsSerialized = false;
                    this.setOldValBytes((byte[])cd.getDeserializedForReading());
                } else {
                    this.oldValueIsSerialized = true;
                    Object o = cd.getValue();
                    if (o instanceof byte[]) {
                        this.setOldValBytes((byte[])o);
                    } else {
                        this.setOldValObj(o);
                    }
                }
            } else {
                Object old = event.getRawOldValue();
                if (old instanceof byte[]) {
                    this.oldValueIsSerialized = false;
                    this.setOldValBytes((byte[])old);
                } else {
                    this.oldValueIsSerialized = true;
                    this.setOldValObj(AbstractRegion.handleNotAvailable(old));
                }
            }
        }
    }

    public static boolean distribute(EntryEventImpl event, Object expectedOldValue, boolean onlyPersistent) {
        Collection<InternalDistributedMember> replicates;
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Set<InternalDistributedMember> set = replicates = onlyPersistent ? r.getCacheDistributionAdvisor().adviseInitializedPersistentMembers().keySet() : r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                RemoteDestroyReplyProcessor processor = RemoteDestroyMessage.send(replicate, event.getRegion(), event, expectedOldValue, false, posDup);
                processor.waitForRemoteResponse();
                VersionTag<?> versionTag = processor.getVersionTag();
                if (versionTag != null) {
                    event.setVersionTag(versionTag);
                    if (event.getRegion().getVersionVector() != null) {
                        event.getRegion().getVersionVector().recordVersion(versionTag.getMemberID(), versionTag);
                    }
                }
                event.setInhibitDistribution(true);
                return true;
            }
            catch (EntryNotFoundException e) {
                throw new EntryNotFoundException("" + event.getKey());
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoteDestroyMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RegionDestroyedException | RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM_VERBOSE)) continue;
                logger.trace(LogMarker.DM_VERBOSE, "RemoteDestroyMessage caught an exception during distribution; retrying to another member", (Throwable)e);
            }
        }
        return successful;
    }

    public static RemoteDestroyReplyProcessor send(DistributedMember recipient, InternalRegion r, EntryEventImpl event, Object expectedOldValue, boolean useOriginRemote, boolean possibleDuplicate) throws RemoteOperationException {
        RemoteDestroyReplyProcessor p = new RemoteDestroyReplyProcessor(r.getSystem(), recipient, (Object)false);
        p.requireResponse();
        RemoteDestroyMessage m = new RemoteDestroyMessage(recipient, r.getFullPath(), p, event, expectedOldValue, useOriginRemote, possibleDuplicate);
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(String.format("Failed sending < %s >", m));
        }
        return p;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean operateOnRegion(ClusterDistributionManager dm, LocalRegion r, long startTime) throws EntryExistsException, RemoteOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getDSFID() {
        return -32;
    }

    private void sendReply(DistributionManager dm, VersionTag<?> versionTag) {
        DestroyReplyMessage.send(this.getSender(), this.getReplySender(dm), this.processorId, versionTag);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.setKey(DataSerializer.readObject(in));
        this.cbArg = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        if ((this.flags & 0x200) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        if ((this.flags & 0x400) != 0) {
            this.originalSender = (InternalDistributedMember)DataSerializer.readObject(in);
        }
        this.eventId = (EventID)DataSerializer.readObject(in);
        if (this.hasOldValue) {
            in.readByte();
            this.setOldValBytes(DataSerializer.readByteArray(in));
        }
        this.expectedOldValue = DataSerializer.readObject(in);
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeObject(this.cbArg, out);
        out.writeByte(this.op.ordinal);
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        if (this.originalSender != null) {
            DataSerializer.writeObject(this.originalSender, out);
        }
        DataSerializer.writeObject(this.eventId, out);
        if (this.hasOldValue) {
            out.writeByte(this.oldValueIsSerialized ? 1 : 0);
            byte policy = DistributedCacheOperation.valueIsToDeserializationPolicy(this.oldValueIsSerialized);
            DistributedCacheOperation.writeValue(policy, this.getOldValObj(), this.getOldValueBytes(), out);
        }
        DataSerializer.writeObject(this.expectedOldValue, out);
        DataSerializer.writeObject(this.versionTag, out);
    }

    @Override
    protected void setFlags(short flags, DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.setFlags(flags, in, context);
        this.hasOldValue = (flags & 0x80) != 0;
        this.useOriginRemote = (flags & 0x40) != 0;
        this.possibleDuplicate = (flags & 8) != 0;
    }

    @Override
    protected short computeCompressedShort() {
        short s = super.computeCompressedShort();
        if (this.hasOldValue) {
            s = (short)(s | 0x80);
        }
        if (this.useOriginRemote) {
            s = (short)(s | 0x40);
        }
        if (this.possibleDuplicate) {
            s = (short)(s | 8);
        }
        if (this.bridgeContext != null) {
            s = (short)(s | 0x200);
        }
        if (this.originalSender != null) {
            s = (short)(s | 0x400);
        }
        if (this.versionTag != null) {
            s = (short)(s | 0x800);
        }
        return s;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.getKey());
        if (this.originalSender != null) {
            buff.append("; originalSender=").append(this.originalSender);
        }
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        if (this.eventId != null) {
            buff.append("; eventId=").append(this.eventId);
        }
        buff.append("; hasOldValue= ").append(this.hasOldValue);
    }

    protected Object getKey() {
        return this.key;
    }

    private void setKey(Object key) {
        this.key = key;
    }

    public Operation getOperation() {
        return this.op;
    }

    protected Object getCallbackArg() {
        return this.cbArg;
    }

    @Override
    public boolean prefersOldSerialized() {
        return true;
    }

    @Override
    public boolean isUnretainedOldReferenceOk() {
        return true;
    }

    @Override
    public boolean isCachedDeserializableValueOk() {
        return false;
    }

    private void setOldValueIsSerialized(boolean isSerialized) {
        this.oldValueIsSerialized = isSerialized;
    }

    @Override
    public void importOldObject(Object ov, boolean isSerialized) {
        this.setOldValueIsSerialized(isSerialized);
        this.setOldValObj(ov);
    }

    @Override
    public void importOldBytes(byte[] ov, boolean isSerialized) {
        this.setOldValueIsSerialized(isSerialized);
        this.setOldValBytes(ov);
    }

    static class RemoteDestroyReplyProcessor
    extends RemoteOperationMessage.RemoteOperationResponse {
        VersionTag<?> versionTag;

        RemoteDestroyReplyProcessor(InternalDistributedSystem ds, DistributedMember recipient, Object key) {
            super(ds, (InternalDistributedMember)recipient, false);
        }

        void setResponse(VersionTag<?> versionTag) {
            this.versionTag = versionTag;
        }

        VersionTag<?> getVersionTag() {
            return this.versionTag;
        }
    }

    public static class DestroyReplyMessage
    extends ReplyMessage {
        private static final byte HAS_VERSION = 1;
        private static final byte PERSISTENT = 2;
        private VersionTag<?> versionTag;

        public DestroyReplyMessage() {
        }

        static void send(InternalDistributedMember recipient, ReplySender dm, int procId, VersionTag<?> versionTag) {
            Assert.assertTrue(recipient != null, "DestroyReplyMessage NULL recipient");
            DestroyReplyMessage m = new DestroyReplyMessage(recipient, procId, versionTag);
            dm.putOutgoing(m);
        }

        DestroyReplyMessage(InternalDistributedMember recipient, int procId, VersionTag<?> versionTag) {
            this.setProcessorId(procId);
            this.setRecipient(recipient);
            this.versionTag = versionTag;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        @Override
        public int getDSFID() {
            return 151;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "DestroyReplyMessage process invoking reply processor with processorId:{}", (Object)this.processorId);
            }
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "DestroyReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            if (rp instanceof RemoteDestroyReplyProcessor) {
                RemoteDestroyReplyProcessor processor = (RemoteDestroyReplyProcessor)rp;
                processor.setResponse(this.versionTag);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)rp, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            byte b = 0;
            if (this.versionTag != null) {
                b = (byte)(b | 1);
            }
            if (this.versionTag instanceof DiskVersionTag) {
                b = (byte)(b | 2);
            }
            out.writeByte(b);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            boolean persistentTag;
            super.fromData(in, context);
            byte b = in.readByte();
            boolean hasTag = (b & 1) != 0;
            boolean bl = persistentTag = (b & 2) != 0;
            if (hasTag) {
                this.versionTag = VersionTag.create(persistentTag, in);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = super.getStringBuilder();
            sb.append(this.getShortClassName());
            sb.append(" processorId=");
            sb.append(this.processorId);
            if (this.versionTag != null) {
                sb.append(" version=").append(this.versionTag);
            }
            sb.append(" from ");
            sb.append(this.getSender());
            ReplyException ex = this.getException();
            if (ex != null) {
                sb.append(" with exception ");
                sb.append(ex);
            }
            return sb.toString();
        }
    }
}

