/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.RefCountChangeInfo;

class ReferenceCountHelperImpl {
    private static final Object SKIP_REF_COUNT_TRACKING = new Object();
    @Immutable
    private static final List<RefCountChangeInfo> LOCKED = Collections.emptyList();
    private final ThreadLocal<Object> refCountOwner;
    private final ThreadLocal<AtomicInteger> refCountReenterCount;
    private final boolean trackRefCounts;
    private final boolean trackFreedRefCounts;
    private final ConcurrentMap<Long, List<RefCountChangeInfo>> stacktraces;
    private final ConcurrentMap<Long, List<RefCountChangeInfo>> freedStacktraces;
    private final BiConsumer<String, Boolean> debugLogger;

    ReferenceCountHelperImpl(boolean trackRefCounts, boolean trackFreedRefCounts) {
        this(trackRefCounts, trackFreedRefCounts, MemoryAllocatorImpl::debugLog);
    }

    ReferenceCountHelperImpl(boolean trackRefCounts, boolean trackFreedRefCounts, BiConsumer<String, Boolean> debugLogger) {
        this.trackRefCounts = trackRefCounts;
        this.trackFreedRefCounts = trackFreedRefCounts;
        if (trackRefCounts) {
            this.stacktraces = new ConcurrentHashMap<Long, List<RefCountChangeInfo>>();
            this.freedStacktraces = trackFreedRefCounts ? new ConcurrentHashMap<Long, List<RefCountChangeInfo>>() : null;
            this.refCountOwner = new ThreadLocal();
            this.refCountReenterCount = new ThreadLocal();
        } else {
            this.stacktraces = null;
            this.freedStacktraces = null;
            this.refCountOwner = null;
            this.refCountReenterCount = null;
        }
        this.debugLogger = debugLogger;
    }

    boolean trackReferenceCounts() {
        return this.trackRefCounts;
    }

    boolean trackFreedReferenceCounts() {
        return this.trackFreedRefCounts;
    }

    void setReferenceCountOwner(Object owner) {
        if (this.trackReferenceCounts()) {
            if (this.refCountOwner.get() != null) {
                AtomicInteger reenterCount = this.refCountReenterCount.get();
                if (owner != null) {
                    reenterCount.incrementAndGet();
                } else if (reenterCount.decrementAndGet() <= 0) {
                    this.refCountOwner.set(null);
                    reenterCount.set(0);
                }
            } else {
                AtomicInteger reenterCount = this.refCountReenterCount.get();
                if (reenterCount == null) {
                    reenterCount = new AtomicInteger(0);
                    this.refCountReenterCount.set(reenterCount);
                }
                if (owner != null) {
                    reenterCount.set(1);
                } else {
                    reenterCount.set(0);
                }
                this.refCountOwner.set(owner);
            }
        }
    }

    Object createReferenceCountOwner() {
        Object result = null;
        if (this.trackReferenceCounts()) {
            result = new Object();
            this.setReferenceCountOwner(result);
        }
        return result;
    }

    public void skipRefCountTracking() {
        this.setReferenceCountOwner(SKIP_REF_COUNT_TRACKING);
    }

    boolean isRefCountTracking() {
        if (!this.trackReferenceCounts()) {
            return false;
        }
        return this.getReferenceCountOwner() != SKIP_REF_COUNT_TRACKING;
    }

    void unskipRefCountTracking() {
        this.setReferenceCountOwner(null);
    }

    List<RefCountChangeInfo> getRefCountInfo(Long address) {
        if (!this.trackReferenceCounts()) {
            return null;
        }
        List result = (List)this.stacktraces.get(address);
        this.getReferenceCountInfoTestHook(this.stacktraces, address);
        while (result != null && !this.stacktraces.replace(address, result, LOCKED)) {
            result = (List)this.stacktraces.get(address);
        }
        return result;
    }

    List<RefCountChangeInfo> peekRefCountInfo(long address) {
        if (!this.trackReferenceCounts()) {
            return null;
        }
        return (List)this.stacktraces.get(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refCountChanged(Long address, boolean decRefCount, int rc) {
        ArrayList newList;
        if (!this.trackReferenceCounts()) {
            return;
        }
        Object owner = this.refCountOwner.get();
        if (owner == SKIP_REF_COUNT_TRACKING) {
            return;
        }
        List list = (ArrayList)this.stacktraces.get(address);
        if (list == null) {
            this.refCountChangedTestHook(address, decRefCount, rc);
            newList = new ArrayList();
            List old = this.stacktraces.putIfAbsent(address, newList);
            list = old == null ? newList : old;
        }
        if (decRefCount && owner != null) {
            newList = list;
            synchronized (newList) {
                for (int i = 0; i < list.size(); ++i) {
                    RefCountChangeInfo info = (RefCountChangeInfo)list.get(i);
                    if (owner instanceof RegionEntry) {
                        if (owner != info.getOwner()) continue;
                        if (info.getUseCount() > 0) {
                            info.decUseCount();
                        } else {
                            list.remove(i);
                        }
                        return;
                    }
                    if (!owner.equals(info.getOwner())) continue;
                    if (info.getUseCount() > 0) {
                        info.decUseCount();
                    } else {
                        list.remove(i);
                    }
                    return;
                }
            }
        }
        if (list == LOCKED) {
            String message = "refCount " + (decRefCount ? "deced" : "inced") + " after orphan detected for @" + Long.toHexString(address);
            this.debugLogger.accept(message, true);
            return;
        }
        RefCountChangeInfo refCountChangeInfo = new RefCountChangeInfo(decRefCount, rc, owner);
        ArrayList arrayList = list;
        synchronized (arrayList) {
            for (RefCountChangeInfo otherRefCountChangeInfo : list) {
                if (!otherRefCountChangeInfo.isSameCaller(refCountChangeInfo)) continue;
                otherRefCountChangeInfo.incUseCount();
                return;
            }
            list.add(refCountChangeInfo);
        }
    }

    void freeRefCountInfo(Long address) {
        if (!this.trackReferenceCounts()) {
            return;
        }
        List freedInfo = (List)this.stacktraces.remove(address);
        if (freedInfo == LOCKED) {
            this.debugLogger.accept("freed after orphan detected for @" + Long.toHexString(address), true);
        } else if (this.trackFreedReferenceCounts()) {
            if (freedInfo != null) {
                this.freedStacktraces.put(address, freedInfo);
            } else {
                this.freedStacktraces.remove(address);
            }
        }
    }

    Object getReferenceCountOwner() {
        if (!this.trackReferenceCounts()) {
            return null;
        }
        return this.refCountOwner.get();
    }

    AtomicInteger getReenterCount() {
        if (!this.trackReferenceCounts()) {
            return null;
        }
        return this.refCountReenterCount.get();
    }

    List<RefCountChangeInfo> getFreeRefCountInfo(long address) {
        if (!this.trackReferenceCounts() || !this.trackFreedReferenceCounts()) {
            return null;
        }
        return (List)this.freedStacktraces.get(address);
    }

    void getReferenceCountInfoTestHook(ConcurrentMap<Long, List<RefCountChangeInfo>> stacktraces, long address) {
    }

    void refCountChangedTestHook(Long address, boolean decRefCount, int rc) {
    }
}

