/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.converters;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.GatewayReceiverConfig;
import org.apache.geode.management.configuration.ClassName;
import org.apache.geode.management.configuration.GatewayReceiver;
import org.apache.geode.management.internal.configuration.converters.ClassNameConverter;
import org.apache.geode.management.internal.configuration.converters.ConfigurationConverter;

public class GatewayReceiverConverter
extends ConfigurationConverter<GatewayReceiver, GatewayReceiverConfig> {
    private final ClassNameConverter classNameConverter = new ClassNameConverter();

    @Override
    protected GatewayReceiver fromNonNullXmlObject(GatewayReceiverConfig xmlObject) {
        GatewayReceiver receiver = new GatewayReceiver();
        receiver.setEndPort(this.stringToInt(xmlObject.getEndPort()));
        receiver.setManualStart(xmlObject.isManualStart());
        receiver.setMaximumTimeBetweenPings(this.stringToInt(xmlObject.getMaximumTimeBetweenPings()));
        receiver.setSocketBufferSize(this.stringToInt(xmlObject.getSocketBufferSize()));
        receiver.setStartPort(this.stringToInt(xmlObject.getStartPort()));
        if (!xmlObject.getGatewayTransportFilters().isEmpty()) {
            ArrayList configFilters = new ArrayList();
            for (DeclarableType xmlFilter : xmlObject.getGatewayTransportFilters()) {
                configFilters.add(this.classNameConverter.fromXmlObject(xmlFilter));
            }
            receiver.setGatewayTransportFilters(configFilters);
        }
        return receiver;
    }

    @Override
    protected GatewayReceiverConfig fromNonNullConfigObject(GatewayReceiver configObject) {
        GatewayReceiverConfig receiver = new GatewayReceiverConfig();
        receiver.setEndPort(this.intToString(configObject.getEndPort()));
        receiver.setStartPort(this.intToString(configObject.getStartPort()));
        receiver.setManualStart(configObject.isManualStart());
        receiver.setMaximumTimeBetweenPings(this.intToString(configObject.getMaximumTimeBetweenPings()));
        receiver.setSocketBufferSize(this.intToString(configObject.getSocketBufferSize()));
        if (configObject.getGatewayTransportFilters() != null) {
            List<DeclarableType> xmlFilters = receiver.getGatewayTransportFilters();
            for (ClassName configFilter : configObject.getGatewayTransportFilters()) {
                xmlFilters.add((DeclarableType)this.classNameConverter.fromConfigObject(configFilter));
            }
        }
        return receiver;
    }

    private Integer stringToInt(String xmlValue) {
        return StringUtils.isBlank((CharSequence)xmlValue) ? null : Integer.valueOf(Integer.parseInt(xmlValue));
    }

    private String intToString(Integer value) {
        return value == null ? null : value.toString();
    }
}

