/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class EnumId
implements DataSerializableFixedID {
    private int id;

    public EnumId(int id) {
        this.id = id;
    }

    public EnumId() {
    }

    public int getDSFID() {
        return 8;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.id);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
    }

    public int intValue() {
        return this.id;
    }

    public int getDSId() {
        return this.id >> 24 & 0xFF;
    }

    public int getEnumNum() {
        return this.id & 0xFFFFFF;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumId other = (EnumId)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "EnumId[dsid=" + this.getDSId() + ", enumnum=" + this.getEnumNum() + "]";
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

