/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.services.result.impl;

import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.services.result.ServiceResult;

public class Success<SuccessType>
implements ServiceResult<SuccessType> {
    @Immutable
    public static final Success<Boolean> SUCCESS_TRUE = Success.of(true);
    private final SuccessType result;

    private Success(SuccessType result) {
        this.result = result;
    }

    public static <T> Success<T> of(T result) {
        return new Success<T>(result);
    }

    @Override
    public <T> T map(Function<SuccessType, T> successFunction, Function<String, T> errorFunction) {
        return successFunction.apply(this.result);
    }

    @Override
    public SuccessType getMessage() {
        return this.result;
    }

    @Override
    public String getErrorMessage() {
        throw new RuntimeException("This Result is not of type Failure.");
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public ServiceResult<SuccessType> ifSuccessful(Consumer<? super SuccessType> consumer) {
        if (this.isSuccessful()) {
            consumer.accept(this.result);
        }
        return this;
    }
}

