/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.log4j.internal.impl;

import java.util.HashSet;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.logging.internal.log4j.LogWriterLevelConverter;
import org.apache.geode.logging.internal.log4j.api.FastLogger;
import org.apache.geode.logging.internal.spi.LogConfig;
import org.apache.geode.logging.internal.spi.LogLevelUpdateOccurs;
import org.apache.geode.logging.internal.spi.LogLevelUpdateScope;
import org.apache.geode.logging.internal.spi.LogWriterLevel;
import org.apache.geode.logging.internal.spi.LoggingProvider;
import org.apache.geode.logging.log4j.internal.impl.PausableAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.filter.Filterable;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;

public class Log4jLoggingProvider
implements LoggingProvider {
    static final String GEODE_CONSOLE_APPENDER_NAME = "STDOUT";
    static final String LOGWRITER_APPENDER_NAME = "LOGWRITER";
    static final String SECURITY_LOGWRITER_APPENDER_NAME = "SECURITYLOGWRITER";
    private static final String GEODE_VERBOSE_FILTER = "{GEODE_VERBOSE}";
    private static final String GEMFIRE_VERBOSE_FILTER = "{GEMFIRE_VERBOSE}";
    private static final String GEODE_DEFAULT_PROPERTY = "geode-default";
    private boolean configuredSecurityAppenders;

    public static void updateLogLevel(Level level, LoggerConfig ... loggerConfigs) {
        for (LoggerConfig loggerConfig : loggerConfigs) {
            loggerConfig.setLevel(level);
        }
        Log4jLoggingProvider.getRootLoggerContext().updateLoggers();
    }

    public static LoggerConfig getLoggerConfig(Logger logger) {
        return ((org.apache.logging.log4j.core.Logger)logger).get();
    }

    @VisibleForTesting
    static String getConfigurationInfoString() {
        return Log4jLoggingProvider.getConfiguration().getConfigurationSource().toString();
    }

    static boolean isUsingGemFireDefaultConfig() {
        Configuration configuration = Log4jLoggingProvider.getConfiguration();
        StrSubstitutor strSubstitutor = configuration.getStrSubstitutor();
        StrLookup variableResolver = strSubstitutor.getVariableResolver();
        String value = variableResolver.lookup(GEODE_DEFAULT_PROPERTY);
        return "true".equals(value);
    }

    private static LoggerContext getRootLoggerContext() {
        return ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).getContext();
    }

    private static Configuration getConfiguration() {
        return Log4jLoggingProvider.getRootLoggerContext().getConfiguration();
    }

    public void configure(LogConfig logConfig, LogLevelUpdateOccurs logLevelUpdateOccurs, LogLevelUpdateScope logLevelUpdateScope) {
        if (this.shouldUpdateLogLevels(logLevelUpdateOccurs)) {
            Level loggerLevel = LogWriterLevelConverter.toLevel((LogWriterLevel)LogWriterLevel.find((int)logConfig.getLogLevel()));
            Log4jLoggingProvider.updateLogLevel(loggerLevel, this.getLoggerConfig("org.apache.geode"));
            Level securityLoggerLevel = LogWriterLevelConverter.toLevel((LogWriterLevel)LogWriterLevel.find((int)logConfig.getSecurityLogLevel()));
            Log4jLoggingProvider.updateLogLevel(securityLoggerLevel, this.getLoggerConfig("org.apache.geode.security"));
            if (!LogConfig.hasSecurityLogFile((LogConfig)logConfig)) {
                this.configuredSecurityAppenders = this.configureSecurityAppenders("org.apache.geode.security", securityLoggerLevel);
            }
        }
        if (this.shouldUpdateLogLevels(logLevelUpdateOccurs)) {
            this.updateLogLevel(logConfig, logLevelUpdateScope);
        }
        this.configureFastLoggerDelegating();
    }

    private boolean shouldUpdateLogLevels(LogLevelUpdateOccurs logLevelUpdateOccurs) {
        return logLevelUpdateOccurs.always() || logLevelUpdateOccurs.onlyWhenUsingDefaultConfig() && Log4jLoggingProvider.isUsingGemFireDefaultConfig();
    }

    public void cleanup() {
        if (this.configuredSecurityAppenders) {
            Configuration log4jConfiguration = Log4jLoggingProvider.getRootLoggerContext().getConfiguration();
            LoggerConfig loggerConfig = log4jConfiguration.getLoggerConfig("org.apache.geode.security");
            loggerConfig.removeAppender(GEODE_CONSOLE_APPENDER_NAME);
            loggerConfig.removeAppender(LOGWRITER_APPENDER_NAME);
            loggerConfig.setAdditive(false);
            Log4jLoggingProvider.getRootLoggerContext().updateLoggers();
        }
    }

    public String getConfigurationInfo() {
        return Log4jLoggingProvider.getConfiguration().getConfigurationSource().toString();
    }

    public void enableLoggingToStandardOutput() {
        Configuration log4jConfiguration = Log4jLoggingProvider.getRootLoggerContext().getConfiguration();
        Object appender = log4jConfiguration.getAppender(GEODE_CONSOLE_APPENDER_NAME);
        if (appender instanceof PausableAppender) {
            PausableAppender geodeConsoleAppender = (PausableAppender)appender;
            geodeConsoleAppender.resume();
        }
    }

    public void disableLoggingToStandardOutput() {
        Configuration log4jConfiguration = Log4jLoggingProvider.getRootLoggerContext().getConfiguration();
        Object appender = log4jConfiguration.getAppender(GEODE_CONSOLE_APPENDER_NAME);
        if (appender instanceof PausableAppender) {
            PausableAppender geodeConsoleAppender = (PausableAppender)appender;
            geodeConsoleAppender.pause();
        }
    }

    public int getPriority() {
        return 0;
    }

    public String toString() {
        return super.toString() + ": {configuredSecurityAppenders=" + this.configuredSecurityAppenders + "}";
    }

    private void updateLogLevel(LogConfig logConfig, LogLevelUpdateScope logLevelUpdateScope) {
        Level level = LogWriterLevelConverter.toLevel((LogWriterLevel)LogWriterLevel.find((int)logConfig.getLogLevel()));
        Configuration configuration = Log4jLoggingProvider.getRootLoggerContext().getConfiguration();
        HashSet<LoggerConfig> loggerConfigs = new HashSet<LoggerConfig>();
        for (LoggerConfig loggerConfig : configuration.getLoggers().values()) {
            switch (logLevelUpdateScope) {
                case ALL_LOGGERS: {
                    loggerConfigs.add(loggerConfig);
                    break;
                }
                case GEODE_AND_SECURITY_LOGGERS: {
                    if (!loggerConfig.getName().startsWith("org.apache.geode")) break;
                    loggerConfigs.add(loggerConfig);
                    break;
                }
                case GEODE_AND_APPLICATION_LOGGERS: {
                    if (loggerConfig.getName().equals("org.apache.geode.security")) break;
                    loggerConfigs.add(loggerConfig);
                    break;
                }
                case GEODE_LOGGERS: {
                    if (!loggerConfig.getName().startsWith("org.apache.geode") || loggerConfig.getName().equals("org.apache.geode.security")) break;
                    loggerConfigs.add(loggerConfig);
                }
            }
        }
        Log4jLoggingProvider.updateLogLevel(level, loggerConfigs.toArray(new LoggerConfig[0]));
    }

    private boolean configureSecurityAppenders(String name, Level level) {
        Configuration log4jConfiguration = Log4jLoggingProvider.getRootLoggerContext().getConfiguration();
        LoggerConfig loggerConfig = log4jConfiguration.getLoggerConfig(name);
        if (!loggerConfig.getName().equals("org.apache.geode.security")) {
            return false;
        }
        Object stdoutAppender = log4jConfiguration.getAppender(GEODE_CONSOLE_APPENDER_NAME);
        Object mainLogWriterAppender = log4jConfiguration.getAppender(LOGWRITER_APPENDER_NAME);
        if (stdoutAppender != null) {
            loggerConfig.addAppender((Appender)stdoutAppender, level, null);
        }
        if (mainLogWriterAppender != null) {
            loggerConfig.addAppender((Appender)mainLogWriterAppender, level, null);
        }
        loggerConfig.setAdditive(true);
        Log4jLoggingProvider.getRootLoggerContext().updateLoggers();
        return true;
    }

    private LoggerConfig getLoggerConfig(String name) {
        Configuration log4jConfiguration = Log4jLoggingProvider.getRootLoggerContext().getConfiguration();
        return log4jConfiguration.getLoggerConfig(name);
    }

    private void configureFastLoggerDelegating() {
        Configuration configuration = Log4jLoggingProvider.getConfiguration();
        FastLogger.setDelegating((this.hasContextWideFilter(configuration) || this.hasAppenderFilter(configuration) || this.hasDebugOrLower(configuration) || this.hasLoggerFilter(configuration) || this.hasAppenderRefFilter(configuration) ? 1 : 0) != 0);
    }

    private boolean hasContextWideFilter(Configuration config) {
        return config.hasFilter();
    }

    private boolean hasAppenderFilter(Configuration config) {
        for (Appender appender : config.getAppenders().values()) {
            if (!(appender instanceof AbstractFilterable) || !((Filterable)((Object)appender)).hasFilter()) continue;
            return true;
        }
        return false;
    }

    private boolean hasDebugOrLower(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isDebugOrLower = loggerConfig.getLevel().isLessSpecificThan(Level.DEBUG);
            if (!isDebugOrLower) continue;
            return true;
        }
        return false;
    }

    private boolean hasLoggerFilter(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isGemFireVerboseFilter;
            boolean isRoot = loggerConfig.getName().isEmpty();
            boolean isGemFire = loggerConfig.getName().startsWith("org.apache.geode");
            boolean hasFilter = loggerConfig.hasFilter();
            boolean bl = isGemFireVerboseFilter = hasFilter && (GEODE_VERBOSE_FILTER.equals(loggerConfig.getFilter().toString()) || GEMFIRE_VERBOSE_FILTER.equals(loggerConfig.getFilter().toString()));
            if (!isRoot && !isGemFire || !hasFilter || isGemFireVerboseFilter) continue;
            return true;
        }
        return false;
    }

    private boolean hasAppenderRefFilter(Configuration config) {
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            boolean isRoot = loggerConfig.getName().isEmpty();
            boolean isGemFire = loggerConfig.getName().startsWith("org.apache.geode");
            if (!isRoot && !isGemFire) continue;
            for (AppenderRef appenderRef : loggerConfig.getAppenderRefs()) {
                if (appenderRef.getFilter() == null) continue;
                return true;
            }
        }
        return false;
    }
}

