/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.guacamole.auth.cas.conf;

import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.GuacamoleServerException;

/**
 * A GuacamoleProperty whose value is an LDAP DN.
 */
public abstract class LdapNameGuacamoleProperty implements GuacamoleProperty<LdapName>  {

    @Override
    public LdapName parseValue(String value) throws GuacamoleServerException {

        // Consider null/empty values to be empty
        if (value == null || value.isEmpty())
            return null;

        // Parse provided value as an LDAP DN
        try {
            return new LdapName(value);
        }
        catch (InvalidNameException e) {
            throw new GuacamoleServerException("Invalid LDAP distinguished name.", e);
        }

    }

}
