/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.user;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.HashMap;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.DelegatingUser;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.vault.ksm.conf.KsmAttributeService;
import org.apache.guacamole.vault.ksm.conf.KsmConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsmUser
extends DelegatingUser {
    private static final Logger logger = LoggerFactory.getLogger(KsmUser.class);
    @Inject
    private KsmConfigurationService configurationService;

    @AssistedInject
    KsmUser(@Assisted User user) {
        super(user);
    }

    User getUnderlyingUser() {
        return this.getDelegateUser();
    }

    public Map<String, String> getAttributes() {
        HashMap attributes = Maps.newHashMap((Map)super.getAttributes());
        boolean userKsmConfigEnabled = false;
        try {
            userKsmConfigEnabled = this.configurationService.getAllowUserConfig();
        }
        catch (GuacamoleException e) {
            logger.warn("Disabling user KSM config due to exception: {}", (Object)e.getMessage());
            logger.debug("Error looking up if user KSM config is enabled.", (Throwable)e);
        }
        if (!userKsmConfigEnabled) {
            attributes.remove("ksm-config");
        } else {
            attributes.put("ksm-config", KsmAttributeService.sanitizeKsmAttributeValue((String)attributes.get("ksm-config")));
        }
        return attributes;
    }
}

