/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.client.impl.LeaseRenewer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestLeaseRenewer {
    private final String FAKE_AUTHORITY = "hdfs://nn1/";
    private final UserGroupInformation FAKE_UGI_A = UserGroupInformation.createUserForTesting((String)"myuser", (String[])new String[]{"group1"});
    private final UserGroupInformation FAKE_UGI_B = UserGroupInformation.createUserForTesting((String)"myuser", (String[])new String[]{"group1"});
    private DFSClient MOCK_DFSCLIENT;
    private LeaseRenewer renewer;
    private static final long FAST_GRACE_PERIOD = 100L;

    @Before
    public void setupMocksAndRenewer() throws IOException {
        this.MOCK_DFSCLIENT = this.createMockClient();
        this.renewer = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        this.renewer.setGraceSleepPeriod(100L);
    }

    private DFSClient createMockClient() {
        DfsClientConf mockConf = (DfsClientConf)Mockito.mock(DfsClientConf.class);
        ((DfsClientConf)Mockito.doReturn((Object)100).when((Object)mockConf)).getHdfsTimeout();
        DFSClient mock = (DFSClient)Mockito.mock(DFSClient.class);
        ((DFSClient)Mockito.doReturn((Object)true).when((Object)mock)).isClientRunning();
        ((DFSClient)Mockito.doReturn((Object)mockConf).when((Object)mock)).getConf();
        ((DFSClient)Mockito.doReturn((Object)"myclient").when((Object)mock)).getClientName();
        return mock;
    }

    @Test
    public void testInstanceSharing() throws IOException {
        LeaseRenewer lr = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        LeaseRenewer lr2 = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)this.MOCK_DFSCLIENT);
        Assert.assertSame((Object)lr, (Object)lr2);
        LeaseRenewer lr3 = LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_B, (DFSClient)this.MOCK_DFSCLIENT);
        Assert.assertNotSame((Object)lr, (Object)lr3);
        LeaseRenewer lr4 = LeaseRenewer.getInstance((String)"someOtherAuthority", (UserGroupInformation)this.FAKE_UGI_B, (DFSClient)this.MOCK_DFSCLIENT);
        Assert.assertNotSame((Object)lr, (Object)lr4);
        Assert.assertNotSame((Object)lr3, (Object)lr4);
    }

    @Test
    public void testRenewal() throws Exception {
        final AtomicInteger leaseRenewalCount = new AtomicInteger();
        ((DFSClient)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                leaseRenewalCount.incrementAndGet();
                return true;
            }
        }).when((Object)this.MOCK_DFSCLIENT)).renewLease();
        DFSOutputStream mockStream = (DFSOutputStream)Mockito.mock(DFSOutputStream.class);
        long fileId = 123L;
        this.renewer.put(this.MOCK_DFSCLIENT);
        long failTime = Time.monotonicNow() + 5000L;
        while (Time.monotonicNow() < failTime && leaseRenewalCount.get() == 0) {
            Thread.sleep(50L);
        }
        if (leaseRenewalCount.get() == 0) {
            Assert.fail((String)"Did not renew lease at all!");
        }
        this.renewer.closeClient(this.MOCK_DFSCLIENT);
    }

    @Test
    public void testManyDfsClientsWhereSomeNotOpen() throws Exception {
        final DFSClient mockClient1 = this.createMockClient();
        ((DFSClient)Mockito.doReturn((Object)false).when((Object)mockClient1)).renewLease();
        Assert.assertSame((Object)this.renewer, (Object)LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)mockClient1));
        long fileId = 456L;
        this.renewer.put(mockClient1);
        final DFSClient mockClient2 = this.createMockClient();
        ((DFSClient)Mockito.doReturn((Object)true).when((Object)mockClient2)).renewLease();
        Assert.assertSame((Object)this.renewer, (Object)LeaseRenewer.getInstance((String)"hdfs://nn1/", (UserGroupInformation)this.FAKE_UGI_A, (DFSClient)mockClient2));
        this.renewer.put(mockClient2);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    ((DFSClient)Mockito.verify((Object)mockClient1, (VerificationMode)Mockito.atLeastOnce())).renewLease();
                    ((DFSClient)Mockito.verify((Object)mockClient2, (VerificationMode)Mockito.atLeastOnce())).renewLease();
                    return true;
                }
                catch (AssertionError err) {
                    LeaseRenewer.LOG.warn("Not yet satisfied", (Throwable)((Object)err));
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, (int)100, (int)10000);
        this.renewer.closeClient(mockClient1);
        this.renewer.closeClient(mockClient2);
    }

    @Test
    public void testThreadName() throws Exception {
        Assert.assertFalse((String)"Renewer not initially running", (boolean)this.renewer.isRunning());
        this.renewer.put(this.MOCK_DFSCLIENT);
        Assert.assertTrue((String)"Renewer should have started running", (boolean)this.renewer.isRunning());
        String threadName = this.renewer.getDaemonName();
        Assert.assertEquals((Object)"LeaseRenewer:myuser@hdfs://nn1/", (Object)threadName);
        this.renewer.closeClient(this.MOCK_DFSCLIENT);
        this.renewer.setEmptyTime(Time.monotonicNow());
        long failTime = Time.monotonicNow() + 5000L;
        while (this.renewer.isRunning() && Time.monotonicNow() < failTime) {
            Thread.sleep(50L);
        }
        Assert.assertFalse((boolean)this.renewer.isRunning());
    }
}

