/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PlacementSet;

public class SimplePlacementSet<N extends SchedulerNode>
implements PlacementSet<N> {
    private Map<NodeId, N> map;
    private String partition;

    public SimplePlacementSet(N node) {
        if (null != node) {
            this.map = ImmutableMap.of((Object)((SchedulerNode)node).getNodeID(), node);
            this.partition = ((SchedulerNode)node).getPartition();
        } else {
            this.map = Collections.emptyMap();
            this.partition = "<DEFAULT_PARTITION>";
        }
    }

    public SimplePlacementSet(Map<NodeId, N> map, String partition) {
        this.map = map;
        this.partition = partition;
    }

    @Override
    public Map<NodeId, N> getAllNodes() {
        return this.map;
    }

    @Override
    public long getVersion() {
        return 0L;
    }

    @Override
    public String getPartition() {
        return this.partition;
    }
}

