/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.JobMonitor;
import org.apache.hadoop.mapred.gridmix.Statistics;

class JobSubmitter
implements Gridmix.Component<GridmixJob> {
    public static final Log LOG = LogFactory.getLog(JobSubmitter.class);
    private final Semaphore sem;
    private final Statistics statistics;
    private final FilePool inputDir;
    private final JobMonitor monitor;
    private final ExecutorService sched;
    private volatile boolean shutdown = false;
    private final int queueDepth;

    public JobSubmitter(JobMonitor monitor, int threads, int queueDepth, FilePool inputDir, Statistics statistics) {
        this.queueDepth = queueDepth;
        this.sem = new Semaphore(queueDepth);
        this.sched = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.inputDir = inputDir;
        this.monitor = monitor;
        this.statistics = statistics;
    }

    @Override
    public void add(GridmixJob job) throws InterruptedException {
        boolean addToQueue;
        boolean bl = addToQueue = !this.shutdown;
        if (addToQueue) {
            SubmitTask task = new SubmitTask(job);
            LOG.info((Object)("Total number of queued jobs: " + (this.queueDepth - this.sem.availablePermits())));
            this.sem.acquire();
            try {
                this.sched.execute(task);
            }
            catch (RejectedExecutionException e) {
                this.sem.release();
            }
        }
    }

    public void refreshFilePool() throws IOException {
        this.inputDir.refresh();
    }

    @Override
    public void start() {
    }

    @Override
    public void join(long millis) throws InterruptedException {
        if (!this.shutdown) {
            throw new IllegalStateException("Cannot wait for active submit thread");
        }
        this.sched.awaitTermination(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        this.sched.shutdown();
    }

    @Override
    public void abort() {
        this.shutdown = true;
        this.sched.shutdownNow();
    }

    private class SubmitTask
    implements Runnable {
        final GridmixJob job;

        public SubmitTask(GridmixJob job) {
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block18: {
                Statistics.JobStats stats = Statistics.generateJobStats(this.job.getJob(), this.job.getJobDesc());
                try {
                    try {
                        long start = System.currentTimeMillis();
                        this.job.buildSplits(JobSubmitter.this.inputDir);
                        long end = System.currentTimeMillis();
                        LOG.info((Object)("[JobSubmitter] Time taken to build splits for job " + this.job.getJob().getJobID() + ": " + (end - start) + " ms."));
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed to submit " + this.job.getJob().getJobName() + " as " + this.job.getUgi()), (Throwable)e);
                        JobSubmitter.this.monitor.submissionFailed(stats);
                        JobSubmitter.this.sem.release();
                        return;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to submit " + this.job.getJob().getJobName() + " as " + this.job.getUgi()), (Throwable)e);
                        JobSubmitter.this.monitor.submissionFailed(stats);
                        JobSubmitter.this.sem.release();
                        return;
                    }
                    long nsDelay = this.job.getDelay(TimeUnit.NANOSECONDS);
                    while (nsDelay > 0L) {
                        TimeUnit.NANOSECONDS.sleep(nsDelay);
                        nsDelay = this.job.getDelay(TimeUnit.NANOSECONDS);
                    }
                    try {
                        long start = System.currentTimeMillis();
                        this.job.call();
                        long end = System.currentTimeMillis();
                        LOG.info((Object)("[JobSubmitter] Time taken to submit the job " + this.job.getJob().getJobID() + ": " + (end - start) + " ms."));
                        this.job.setSubmitted();
                        JobSubmitter.this.monitor.add(stats);
                        JobSubmitter.this.statistics.addJobStats(stats);
                        if (LOG.isDebugEnabled()) {
                            String jobID = this.job.getJob().getConfiguration().get("gridmix.job.original-job-id");
                            LOG.debug((Object)("Original job '" + jobID + "' is being simulated as '" + this.job.getJob().getJobID() + "'"));
                            LOG.debug((Object)("SUBMIT " + this.job + "@" + System.currentTimeMillis() + " (" + this.job.getJob().getJobID() + ")"));
                        }
                        break block18;
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed to submit " + this.job.getJob().getJobName() + " as " + this.job.getUgi()), (Throwable)e);
                        if (e.getCause() instanceof ClosedByInterruptException) {
                            throw new InterruptedException("Failed to submit " + this.job.getJob().getJobName());
                        }
                        JobSubmitter.this.monitor.submissionFailed(stats);
                    }
                    catch (ClassNotFoundException e) {
                        LOG.warn((Object)("Failed to submit " + this.job.getJob().getJobName()), (Throwable)e);
                        JobSubmitter.this.monitor.submissionFailed(stats);
                    }
                    break block18;
                    {
                        catch (InterruptedException e) {
                            GridmixJob.pullDescription(this.job.id());
                            Thread.currentThread().interrupt();
                            JobSubmitter.this.monitor.submissionFailed(stats);
                            break block18;
                        }
                        catch (Exception e) {
                            LOG.info((Object)(" Job " + this.job.getJob().getJobID() + " submission failed "), (Throwable)e);
                            JobSubmitter.this.monitor.submissionFailed(stats);
                            break block18;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    JobSubmitter.this.sem.release();
                }
            }
        }
    }
}

