/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.gridmix.AvgRecordFactory;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.FileQueue;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.apache.hadoop.mapred.gridmix.InputStriper;
import org.apache.hadoop.mapred.gridmix.IntermediateRecordFactory;
import org.apache.hadoop.mapred.gridmix.LoadSplit;
import org.apache.hadoop.mapred.gridmix.Progressive;
import org.apache.hadoop.mapred.gridmix.ReadRecordFactory;
import org.apache.hadoop.mapred.gridmix.RecordFactory;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.ResourceUsageMatcher;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;
import org.apache.hadoop.tools.rumen.TaskInfo;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;

class LoadJob
extends GridmixJob {
    public static final Log LOG = LogFactory.getLog(LoadJob.class);

    public LoadJob(Configuration conf, long submissionMillis, JobStory jobdesc, Path outRoot, UserGroupInformation ugi, int seq) throws IOException {
        super(conf, submissionMillis, jobdesc, outRoot, ugi, seq);
    }

    @Override
    public Job call() throws IOException, InterruptedException, ClassNotFoundException {
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Job>(){

            @Override
            public Job run() throws IOException, ClassNotFoundException, InterruptedException {
                LoadJob.this.job.setMapperClass(LoadMapper.class);
                LoadJob.this.job.setReducerClass(LoadReducer.class);
                LoadJob.this.job.setNumReduceTasks(LoadJob.this.jobdesc.getNumberReduces());
                LoadJob.this.job.setMapOutputKeyClass(GridmixKey.class);
                LoadJob.this.job.setMapOutputValueClass(GridmixRecord.class);
                LoadJob.this.job.setSortComparatorClass(LoadSortComparator.class);
                LoadJob.this.job.setGroupingComparatorClass(GridmixJob.SpecGroupingComparator.class);
                LoadJob.this.job.setInputFormatClass(LoadInputFormat.class);
                LoadJob.this.job.setOutputFormatClass(GridmixJob.RawBytesOutputFormat.class);
                LoadJob.this.job.setPartitionerClass(GridmixJob.DraftPartitioner.class);
                LoadJob.this.job.setJarByClass(LoadJob.class);
                LoadJob.this.job.getConfiguration().setBoolean("mapreduce.client.genericoptionsparser.used", true);
                FileOutputFormat.setOutputPath((Job)LoadJob.this.job, (Path)LoadJob.this.outdir);
                LoadJob.this.job.submit();
                return LoadJob.this.job;
            }
        });
        return this.job;
    }

    @Override
    protected boolean canEmulateCompression() {
        return true;
    }

    @Override
    void buildSplits(FilePool inputDir) throws IOException {
        long mapInputBytesTotal = 0L;
        long mapOutputBytesTotal = 0L;
        long mapOutputRecordsTotal = 0L;
        JobStory jobdesc = this.getJobDesc();
        if (null == jobdesc) {
            return;
        }
        int maps = jobdesc.getNumberMaps();
        int reds = jobdesc.getNumberReduces();
        for (int i = 0; i < maps; ++i) {
            TaskInfo info = jobdesc.getTaskInfo(TaskType.MAP, i);
            mapInputBytesTotal += info.getInputBytes();
            mapOutputBytesTotal += info.getOutputBytes();
            mapOutputRecordsTotal += (long)info.getOutputRecords();
        }
        double[] reduceRecordRatio = new double[reds];
        double[] reduceByteRatio = new double[reds];
        for (int i = 0; i < reds; ++i) {
            TaskInfo info = jobdesc.getTaskInfo(TaskType.REDUCE, i);
            reduceByteRatio[i] = (double)info.getInputBytes() / (1.0 * (double)mapOutputBytesTotal);
            reduceRecordRatio[i] = (double)info.getInputRecords() / (1.0 * (double)mapOutputRecordsTotal);
        }
        InputStriper striper = new InputStriper(inputDir, mapInputBytesTotal);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (int i = 0; i < maps; ++i) {
            int nSpec = reds / maps + (reds % maps > i ? 1 : 0);
            long[] specBytes = new long[nSpec];
            long[] specRecords = new long[nSpec];
            ResourceUsageMetrics[] metrics = new ResourceUsageMetrics[nSpec];
            for (int j = 0; j < nSpec; ++j) {
                TaskInfo info = jobdesc.getTaskInfo(TaskType.REDUCE, i + j * maps);
                specBytes[j] = info.getOutputBytes();
                specRecords[j] = info.getOutputRecords();
                metrics[j] = info.getResourceUsageMetrics();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("SPEC(%d) %d -> %d %d %d %d %d %d %d", this.id(), i, i + j * maps, info.getOutputRecords(), info.getOutputBytes(), info.getResourceUsageMetrics().getCumulativeCpuUsage(), info.getResourceUsageMetrics().getPhysicalMemoryUsage(), info.getResourceUsageMetrics().getVirtualMemoryUsage(), info.getResourceUsageMetrics().getHeapUsage()));
            }
            TaskInfo info = jobdesc.getTaskInfo(TaskType.MAP, i);
            long possiblyCompressedInputBytes = info.getInputBytes();
            Configuration conf = this.job.getConfiguration();
            long uncompressedInputBytes = CompressionEmulationUtil.getUncompressedInputBytes(possiblyCompressedInputBytes, conf);
            splits.add((InputSplit)new LoadSplit(striper.splitFor(inputDir, uncompressedInputBytes, 3), maps, i, uncompressedInputBytes, info.getInputRecords(), info.getOutputBytes(), info.getOutputRecords(), reduceByteRatio, reduceRecordRatio, specBytes, specRecords, info.getResourceUsageMetrics(), metrics));
        }
        LoadJob.pushDescription(this.id(), splits);
    }

    static class LoadInputFormat
    extends InputFormat<NullWritable, GridmixRecord> {
        LoadInputFormat() {
        }

        public List<InputSplit> getSplits(JobContext jobCtxt) throws IOException {
            return GridmixJob.pullDescription(jobCtxt);
        }

        public RecordReader<NullWritable, GridmixRecord> createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException {
            return new LoadRecordReader();
        }
    }

    static class LoadRecordReader
    extends RecordReader<NullWritable, GridmixRecord> {
        private RecordFactory factory;
        private final Random r = new Random();
        private final GridmixRecord val = new GridmixRecord();

        public void initialize(InputSplit genericSplit, TaskAttemptContext ctxt) throws IOException, InterruptedException {
            LoadSplit split = (LoadSplit)genericSplit;
            Configuration conf = ctxt.getConfiguration();
            this.factory = new ReadRecordFactory(split.getLength(), split.getInputRecords(), new FileQueue(split, conf), conf);
        }

        public boolean nextKeyValue() throws IOException {
            this.val.setSeed(this.r.nextLong());
            return this.factory.next(null, this.val);
        }

        public float getProgress() throws IOException {
            return this.factory.getProgress();
        }

        public NullWritable getCurrentKey() {
            return NullWritable.get();
        }

        public GridmixRecord getCurrentValue() {
            return this.val;
        }

        public void close() throws IOException {
            this.factory.close();
        }
    }

    public static class LoadReducer
    extends Reducer<GridmixKey, GridmixRecord, NullWritable, GridmixRecord> {
        private final Random r = new Random();
        private final GridmixRecord val = new GridmixRecord();
        private double acc;
        private double ratio;
        private RecordFactory factory;
        private ResourceUsageMatcherRunner matcher = null;
        private StatusReporter reporter = null;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration conf;
            if (!context.nextKey() || ((GridmixKey)context.getCurrentKey()).getType() != 0) {
                throw new IOException("Missing reduce spec");
            }
            long outBytes = 0L;
            long outRecords = 0L;
            long inRecords = 0L;
            ResourceUsageMetrics metrics = new ResourceUsageMetrics();
            for (GridmixRecord ignored : context.getValues()) {
                GridmixKey spec = (GridmixKey)context.getCurrentKey();
                inRecords += spec.getReduceInputRecords();
                outBytes += spec.getReduceOutputBytes();
                outRecords += spec.getReduceOutputRecords();
                if (spec.getReduceResourceUsageMetrics() == null) continue;
                metrics = spec.getReduceResourceUsageMetrics();
            }
            if (0L == outRecords && inRecords > 0L) {
                LOG.info((Object)"Spec output bytes w/o records. Using input record count");
                outRecords = inRecords;
            }
            if (CompressionEmulationUtil.isCompressionEmulationEnabled(conf = context.getConfiguration()) && FileOutputFormat.getCompressOutput((JobContext)context)) {
                float compressionRatio = CompressionEmulationUtil.getJobOutputCompressionEmulationRatio(conf);
                LOG.info((Object)("GridMix is configured to use a compression ratio of " + compressionRatio + " for the reduce output data."));
                this.val.setCompressibility(true, compressionRatio);
                outBytes = (long)((float)outBytes / compressionRatio);
            }
            this.factory = new AvgRecordFactory(outBytes, outRecords, context.getConfiguration(), 5120);
            this.ratio = (double)outRecords / (1.0 * (double)inRecords);
            this.acc = 0.0;
            this.matcher = new ResourceUsageMatcherRunner((TaskInputOutputContext)context, metrics);
            this.reporter = new StatusReporter((TaskAttemptContext)context, this.matcher);
            this.reporter.start();
        }

        protected void reduce(GridmixKey key, Iterable<GridmixRecord> values, Reducer.Context context) throws IOException, InterruptedException {
            for (GridmixRecord ignored : values) {
                this.acc += this.ratio;
                while (this.acc >= 1.0 && this.factory.next(null, this.val)) {
                    context.write((Object)NullWritable.get(), (Object)this.val);
                    this.acc -= 1.0;
                    try {
                        this.matcher.match();
                    }
                    catch (Exception e) {
                        LOG.debug((Object)"Error in resource usage emulation! Message: ", (Throwable)e);
                    }
                }
            }
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.val.setSeed(this.r.nextLong());
            while (this.factory.next(null, this.val)) {
                context.write((Object)NullWritable.get(), (Object)this.val);
                this.val.setSeed(this.r.nextLong());
                try {
                    this.matcher.match();
                }
                catch (Exception e) {
                    LOG.debug((Object)"Error in resource usage emulation! Message: ", (Throwable)e);
                }
            }
        }
    }

    public static class LoadMapper
    extends Mapper<NullWritable, GridmixRecord, GridmixKey, GridmixRecord> {
        private double acc;
        private double ratio;
        private final ArrayList<RecordFactory> reduces = new ArrayList();
        private final Random r = new Random();
        private final GridmixKey key = new GridmixKey();
        private final GridmixRecord val = new GridmixRecord();
        private ResourceUsageMatcherRunner matcher = null;
        private StatusReporter reporter = null;

        protected void setup(Mapper.Context ctxt) throws IOException, InterruptedException {
            Configuration conf = ctxt.getConfiguration();
            LoadSplit split = (LoadSplit)ctxt.getInputSplit();
            int maps = split.getMapCount();
            long[] reduceBytes = split.getOutputBytes();
            long[] reduceRecords = split.getOutputRecords();
            long totalRecords = 0L;
            int nReduces = ctxt.getNumReduceTasks();
            if (nReduces > 0) {
                boolean emulateMapOutputCompression = CompressionEmulationUtil.isCompressionEmulationEnabled(conf) && conf.getBoolean("mapreduce.map.output.compress", false);
                float compressionRatio = 1.0f;
                if (emulateMapOutputCompression) {
                    compressionRatio = CompressionEmulationUtil.getMapOutputCompressionEmulationRatio(conf);
                    LOG.info((Object)("GridMix is configured to use a compression ratio of " + compressionRatio + " for the map output data."));
                    this.key.setCompressibility(true, compressionRatio);
                    this.val.setCompressibility(true, compressionRatio);
                }
                int idx = 0;
                int id = split.getId();
                for (int i = 0; i < nReduces; ++i) {
                    GridmixKey.Spec spec = new GridmixKey.Spec();
                    if (i == id) {
                        spec.bytes_out = split.getReduceBytes(idx);
                        spec.rec_out = split.getReduceRecords(idx);
                        spec.setResourceUsageSpecification(split.getReduceResourceUsageMetrics(idx));
                        ++idx;
                        id += maps;
                    }
                    long mapOutputBytes = reduceBytes[i];
                    if (emulateMapOutputCompression) {
                        mapOutputBytes = (long)((float)mapOutputBytes / compressionRatio);
                    }
                    this.reduces.add(new IntermediateRecordFactory(new AvgRecordFactory(mapOutputBytes, reduceRecords[i], conf, 5120), i, reduceRecords[i], spec, conf));
                    totalRecords += reduceRecords[i];
                }
            } else {
                boolean emulateJobOutputCompression;
                long mapOutputBytes = reduceBytes[0];
                boolean bl = emulateJobOutputCompression = CompressionEmulationUtil.isCompressionEmulationEnabled(conf) && conf.getBoolean("mapreduce.output.fileoutputformat.compress", false);
                if (emulateJobOutputCompression) {
                    float compressionRatio = CompressionEmulationUtil.getJobOutputCompressionEmulationRatio(conf);
                    LOG.info((Object)("GridMix is configured to use a compression ratio of " + compressionRatio + " for the job output data."));
                    this.key.setCompressibility(true, compressionRatio);
                    this.val.setCompressibility(true, compressionRatio);
                    mapOutputBytes = (long)((float)mapOutputBytes / compressionRatio);
                }
                this.reduces.add(new AvgRecordFactory(mapOutputBytes, reduceRecords[0], conf, 5120));
                totalRecords = reduceRecords[0];
            }
            long splitRecords = split.getInputRecords();
            int missingRecSize = conf.getInt("gridmix.missing.rec.size", 65536);
            long inputRecords = splitRecords <= 0L && split.getLength() >= 0L ? Math.max(1L, split.getLength() / (long)missingRecSize) : splitRecords;
            this.ratio = (double)totalRecords / (1.0 * (double)inputRecords);
            this.acc = 0.0;
            this.matcher = new ResourceUsageMatcherRunner((TaskInputOutputContext)ctxt, split.getMapResourceUsageMetrics());
            this.matcher.setDaemon(true);
            this.reporter = new StatusReporter((TaskAttemptContext)ctxt, this.matcher);
            this.reporter.setDaemon(true);
            this.reporter.start();
        }

        public void map(NullWritable ignored, GridmixRecord rec, Mapper.Context context) throws IOException, InterruptedException {
            this.acc += this.ratio;
            while (this.acc >= 1.0 && !this.reduces.isEmpty()) {
                this.key.setSeed(this.r.nextLong());
                this.val.setSeed(this.r.nextLong());
                int idx = this.r.nextInt(this.reduces.size());
                RecordFactory f = this.reduces.get(idx);
                if (!f.next(this.key, this.val)) {
                    this.reduces.remove(idx);
                    continue;
                }
                context.write((Object)this.key, (Object)this.val);
                this.acc -= 1.0;
                try {
                    this.matcher.match();
                }
                catch (Exception e) {
                    LOG.debug((Object)"Error in resource usage emulation! Message: ", (Throwable)e);
                }
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            LOG.info((Object)"Starting the cleanup phase.");
            for (RecordFactory factory : this.reduces) {
                this.key.setSeed(this.r.nextLong());
                while (factory.next(this.key, this.val)) {
                    context.progress();
                    context.write((Object)this.key, (Object)this.val);
                    this.key.setSeed(this.r.nextLong());
                    try {
                        this.matcher.match();
                    }
                    catch (Exception e) {
                        LOG.debug((Object)"Error in resource usage emulation! Message: ", (Throwable)e);
                    }
                }
            }
            if (context.getNumReduceTasks() > 0 && context.getCounter((Enum)TaskCounter.SPILLED_RECORDS).getValue() == 0L) {
                LOG.info((Object)"Boosting the map phase progress.");
                this.matcher.boost(0.33f);
                this.matcher.match();
            }
            this.matcher.start();
        }
    }

    private static class StatusReporter
    extends Thread {
        private final TaskAttemptContext context;
        private final Progressive progress;

        StatusReporter(TaskAttemptContext context, Progressive progress) {
            this.context = context;
            this.progress = progress;
        }

        @Override
        public void run() {
            LOG.info((Object)"Status reporter thread started.");
            try {
                while (!this.isInterrupted() && this.progress.getProgress() < 1.0f) {
                    this.context.progress();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                LOG.info((Object)"Status reporter thread exiting");
            }
            catch (Exception e) {
                LOG.info((Object)"Exception while running the status reporter thread!", (Throwable)e);
            }
        }
    }

    static class ResourceUsageMatcherRunner
    extends Thread
    implements Progressive {
        private final ResourceUsageMatcher matcher;
        private final BoostingProgress progress;
        private final long sleepTime;
        private static final String SLEEP_CONFIG = "gridmix.emulators.resource-usage.sleep-duration";
        private static final long DEFAULT_SLEEP_TIME = 100L;

        ResourceUsageMatcherRunner(TaskInputOutputContext context, ResourceUsageMetrics metrics) {
            Configuration conf = context.getConfiguration();
            Class clazz = conf.getClass("mapreduce.tasktracker.resourcecalculatorplugin", null, ResourceCalculatorPlugin.class);
            ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin((Class)clazz, (Configuration)conf);
            this.sleepTime = conf.getLong(SLEEP_CONFIG, 100L);
            this.progress = new BoostingProgress(context);
            this.matcher = new ResourceUsageMatcher();
            this.matcher.configure(conf, plugin, metrics, this.progress);
        }

        protected void match() throws IOException, InterruptedException {
            this.matcher.matchResourceUsage();
        }

        @Override
        public void run() {
            LOG.info((Object)"Resource usage matcher thread started.");
            try {
                while (this.progress.getProgress() < 1.0f) {
                    this.match();
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (Exception exception) {}
                }
                this.match();
                LOG.info((Object)"Resource usage emulation complete! Matcher exiting");
            }
            catch (Exception e) {
                LOG.info((Object)"Exception while running the resource-usage-emulation matcher thread! Exiting.", (Throwable)e);
            }
        }

        @Override
        public float getProgress() {
            return this.matcher.getProgress();
        }

        void boost(float value) {
            this.progress.setBoostValue(value);
        }

        private static class BoostingProgress
        implements Progressive {
            private float boostValue = 0.0f;
            TaskInputOutputContext context;

            BoostingProgress(TaskInputOutputContext context) {
                this.context = context;
            }

            void setBoostValue(float boostValue) {
                this.boostValue = boostValue;
            }

            @Override
            public float getProgress() {
                return Math.min(1.0f, this.context.getProgress() + this.boostValue);
            }
        }
    }

    public static class LoadSortComparator
    extends GridmixKey.Comparator {
        private ResourceUsageMatcherRunner matcher = null;
        private boolean isConfigured = false;

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            this.configure();
            int ret = super.compare(b1, s1, l1, b2, s2, l2);
            if (this.matcher != null) {
                try {
                    this.matcher.match();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ret;
        }

        private void configure() {
            if (!this.isConfigured) {
                ThreadGroup group = Thread.currentThread().getThreadGroup();
                Thread[] threads = new Thread[group.activeCount() * 2];
                group.enumerate(threads, true);
                for (Thread t : threads) {
                    if (t == null || !(t instanceof ResourceUsageMatcherRunner)) continue;
                    this.matcher = (ResourceUsageMatcherRunner)t;
                    this.isConfigured = true;
                    break;
                }
            }
        }
    }
}

