/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.anonymization;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.tools.rumen.state.State;

public class WordList
implements State {
    private Map<String, Integer> list = new HashMap<String, Integer>(0);
    private boolean isUpdated = false;
    private String name;

    public WordList() {
        this("word");
    }

    public WordList(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void add(String word) {
        if (!this.contains(word)) {
            int index = this.getSize();
            this.list.put(word, index);
            this.isUpdated = true;
        }
    }

    public boolean contains(String word) {
        return this.list.containsKey(word);
    }

    public int indexOf(String word) {
        return this.list.get(word);
    }

    public int getSize() {
        return this.list.size();
    }

    @Override
    public boolean isUpdated() {
        return this.isUpdated;
    }

    public void setSize(int size) {
        this.list = new HashMap<String, Integer>(size);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Integer> getWords() {
        return this.list;
    }

    public void setWords(Map<String, Integer> list) {
        this.list = list;
    }
}

