/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import javax.xml.bind.annotation.XmlElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.timelineservice.HierarchicalTimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FlowRunEntity
extends HierarchicalTimelineEntity {
    public static final String USER_INFO_KEY = "SYSTEM_INFO_USER";
    public static final String FLOW_NAME_INFO_KEY = "SYSTEM_INFO_FLOW_NAME";
    public static final String FLOW_VERSION_INFO_KEY = "SYSTEM_INFO_FLOW_VERSION";
    public static final String FLOW_RUN_ID_INFO_KEY = "SYSTEM_INFO_FLOW_RUN_ID";
    public static final String FLOW_RUN_END_TIME = "SYSTEM_INFO_FLOW_RUN_END_TIME";

    public FlowRunEntity() {
        super(TimelineEntityType.YARN_FLOW_RUN.toString());
        this.setConfigs(null);
    }

    public FlowRunEntity(TimelineEntity entity) {
        super(entity);
        if (!entity.getType().equals(TimelineEntityType.YARN_FLOW_RUN.toString())) {
            throw new IllegalArgumentException("Incompatible entity type: " + this.getId());
        }
        this.setConfigs(null);
    }

    @Override
    @XmlElement(name="id")
    public String getId() {
        String id = super.getId();
        if (id == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getInfo().get(USER_INFO_KEY).toString());
            sb.append('@');
            sb.append(this.getInfo().get(FLOW_NAME_INFO_KEY).toString());
            sb.append('/');
            sb.append(this.getInfo().get(FLOW_RUN_ID_INFO_KEY).toString());
            id = sb.toString();
            this.setId(id);
        }
        return id;
    }

    public String getUser() {
        return (String)this.getInfo().get(USER_INFO_KEY);
    }

    public void setUser(String user) {
        this.addInfo(USER_INFO_KEY, user);
    }

    public String getName() {
        return (String)this.getInfo().get(FLOW_NAME_INFO_KEY);
    }

    public void setName(String name) {
        this.addInfo(FLOW_NAME_INFO_KEY, name);
    }

    public String getVersion() {
        return (String)this.getInfo().get(FLOW_VERSION_INFO_KEY);
    }

    public void setVersion(String version) {
        this.addInfo(FLOW_VERSION_INFO_KEY, version);
    }

    public long getRunId() {
        Object runId = this.getInfo().get(FLOW_RUN_ID_INFO_KEY);
        return runId == null ? 0L : ((Number)runId).longValue();
    }

    public void setRunId(long runId) {
        this.addInfo(FLOW_RUN_ID_INFO_KEY, runId);
    }

    public long getStartTime() {
        return this.getCreatedTime();
    }

    public void setStartTime(long startTime) {
        this.setCreatedTime(startTime);
    }

    public long getMaxEndTime() {
        Object time = this.getInfo().get(FLOW_RUN_END_TIME);
        return time == null ? 0L : ((Number)time).longValue();
    }

    public void setMaxEndTime(long endTime) {
        this.addInfo(FLOW_RUN_END_TIME, endTime);
    }
}

