/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class BasicAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.BasicAWSCredentialsProvider";
    private final String accessKey;
    private final String secretKey;

    public BasicAWSCredentialsProvider(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public AWSCredentials getCredentials() {
        if (!StringUtils.isEmpty((String)this.accessKey) && !StringUtils.isEmpty((String)this.secretKey)) {
            return new BasicAWSCredentials(this.accessKey, this.secretKey);
        }
        throw new CredentialInitializationException("Access key or secret key is null");
    }

    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

