/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timeline.KeyValueBasedTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreMapAdapter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryTimelineStore
extends KeyValueBasedTimelineStore {
    public MemoryTimelineStore() {
        this(MemoryTimelineStore.class.getName());
    }

    public MemoryTimelineStore(String name) {
        super(name);
        this.entities = new HashMapStoreAdapter();
        this.entityInsertTimes = new HashMapStoreAdapter();
        this.domainById = new HashMapStoreAdapter();
        this.domainsByOwner = new HashMapStoreAdapter();
    }

    static class HashMapStoreAdapter<K, V>
    implements TimelineStoreMapAdapter<K, V> {
        Map<K, V> internalMap = new HashMap();

        HashMapStoreAdapter() {
        }

        @Override
        public V get(K key) {
            return this.internalMap.get(key);
        }

        @Override
        public void put(K key, V value) {
            this.internalMap.put(key, value);
        }

        @Override
        public void remove(K key) {
            this.internalMap.remove(key);
        }

        @Override
        public Iterator<V> valueSetIterator() {
            return new TreeSet<V>(this.internalMap.values()).iterator();
        }

        @Override
        public Iterator<V> valueSetIterator(V minV) {
            if (minV instanceof Comparable) {
                TreeSet<V> tempTreeSet = new TreeSet<V>();
                for (V value : this.internalMap.values()) {
                    if (((Comparable)value).compareTo(minV) < 0) continue;
                    tempTreeSet.add(value);
                }
                return tempTreeSet.iterator();
            }
            return this.valueSetIterator();
        }
    }
}

