/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class NodesBlock
extends HtmlBlock {
    private static final long BYTES_IN_MB = 0x100000L;
    private final Router router;

    @Inject
    NodesBlock(Router router, View.ViewContext ctx) {
        super(ctx);
        this.router = router;
    }

    protected void render(HtmlBlock.Block html) {
        Configuration conf = this.router.getConfig();
        String webAppAddress = WebAppUtils.getRouterWebAppURLWithScheme((Configuration)conf);
        NodesInfo nodes = RouterWebServiceUtil.genericForward(webAppAddress, null, NodesInfo.class, HTTPMethods.GET, "/ws/v1/cluster/nodes", null, null);
        this.setTitle("Nodes");
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#nodes").thead().tr().th(".nodelabels", "Node Labels").th(".rack", "Rack").th(".state", "Node State").th(".nodeaddress", "Node Address").th(".nodehttpaddress", "Node HTTP Address").th(".lastHealthUpdate", "Last health-update").th(".healthReport", "Health-report").th(".containers", "Containers").th(".mem", "Mem Used").th(".mem", "Mem Avail").th(".vcores", "VCores Used").th(".vcores", "VCores Avail").th(".nodeManagerVersion", "Version")._())._()).tbody();
        for (NodeInfo info : nodes.getNodes()) {
            int usedMemory = (int)info.getUsedMemory();
            int availableMemory = (int)info.getAvailableMemory();
            Hamlet.TR row = tbody.tr();
            row.td()._(new Object[]{StringUtils.join((CharSequence)",", (Iterable)info.getNodeLabels())})._();
            row.td()._(new Object[]{info.getRack()})._();
            row.td()._(new Object[]{info.getState()})._();
            row.td()._(new Object[]{info.getNodeId()})._();
            boolean isInactive = false;
            if (isInactive) {
                row.td()._(new Object[]{"N/A"})._();
            } else {
                String httpAddress = info.getNodeHTTPAddress();
                row.td().a("//" + httpAddress, httpAddress)._();
            }
            ((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)((Hamlet.TR)((Hamlet.TD)row.td().br().$title(String.valueOf(info.getLastHealthUpdate()))._())._(new Object[]{Times.format((long)info.getLastHealthUpdate())})._()).td(info.getHealthReport()).td(String.valueOf(info.getNumContainers())).td().br().$title(String.valueOf(usedMemory))._())._(new Object[]{StringUtils.byteDesc((long)((long)usedMemory * 0x100000L))})._()).td().br().$title(String.valueOf(availableMemory))._())._(new Object[]{StringUtils.byteDesc((long)((long)availableMemory * 0x100000L))})._()).td(String.valueOf(info.getUsedVirtualCores())).td(String.valueOf(info.getAvailableVirtualCores())).td(info.getVersion())._();
        }
        ((Hamlet.TABLE)tbody._())._();
    }
}

