/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.proto.RouterProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.RouterAdminProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.router.NameserviceManager;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterPermissionChecker;
import org.apache.hadoop.hdfs.server.federation.router.RouterSafemodeService;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.router.RouterStateManager;
import org.apache.hadoop.hdfs.server.federation.store.DisabledNameserviceStore;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.DisableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnableNameserviceResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.EnterSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetDisabledNameservicesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.LeaveSafeModeRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.LeaveSafeModeResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterAdminServer
extends AbstractService
implements MountTableManager,
RouterStateManager,
NameserviceManager {
    private static final Logger LOG = LoggerFactory.getLogger(RouterAdminServer.class);
    private Configuration conf;
    private final Router router;
    private MountTableStore mountTableStore;
    private DisabledNameserviceStore disabledStore;
    private final RPC.Server adminServer;
    private final InetSocketAddress adminAddress;
    private static String routerOwner;
    private static String superGroup;
    private static boolean isPermissionEnabled;

    public RouterAdminServer(Configuration conf, Router router) throws IOException {
        super(RouterAdminServer.class.getName());
        this.conf = conf;
        this.router = router;
        int handlerCount = this.conf.getInt("dfs.federation.router.admin.handler.count", 1);
        RPC.setProtocolEngine((Configuration)this.conf, RouterAdminProtocolPB.class, ProtobufRpcEngine.class);
        RouterAdminProtocolServerSideTranslatorPB routerAdminProtocolTranslator = new RouterAdminProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = RouterProtocolProtos.RouterAdminProtocolService.newReflectiveBlockingService(routerAdminProtocolTranslator);
        InetSocketAddress confRpcAddress = conf.getSocketAddr("dfs.federation.router.admin-bind-host", "dfs.federation.router.admin-address", "0.0.0.0:8111", 8111);
        String bindHost = conf.get("dfs.federation.router.admin-bind-host", confRpcAddress.getHostName());
        LOG.info("Admin server binding to {}:{}", (Object)bindHost, (Object)confRpcAddress.getPort());
        RouterAdminServer.initializePermissionSettings(this.conf);
        this.adminServer = new RPC.Builder(this.conf).setProtocol(RouterAdminProtocolPB.class).setInstance((Object)clientNNPbService).setBindAddress(bindHost).setPort(confRpcAddress.getPort()).setNumHandlers(handlerCount).setVerbose(false).build();
        InetSocketAddress listenAddress = this.adminServer.getListenerAddress();
        this.adminAddress = new InetSocketAddress(confRpcAddress.getHostName(), listenAddress.getPort());
        router.setAdminServerAddress(this.adminAddress);
    }

    private static void initializePermissionSettings(Configuration routerConf) throws IOException {
        routerOwner = UserGroupInformation.getCurrentUser().getShortUserName();
        superGroup = routerConf.get("dfs.permissions.superusergroup", "supergroup");
        isPermissionEnabled = routerConf.getBoolean("dfs.permissions.enabled", true);
    }

    @VisibleForTesting
    RPC.Server getAdminServer() {
        return this.adminServer;
    }

    private MountTableStore getMountTableStore() throws IOException {
        if (this.mountTableStore == null) {
            this.mountTableStore = this.router.getStateStore().getRegisteredRecordStore(MountTableStore.class);
            if (this.mountTableStore == null) {
                throw new IOException("Mount table state store is not available.");
            }
        }
        return this.mountTableStore;
    }

    private DisabledNameserviceStore getDisabledNameserviceStore() throws IOException {
        if (this.disabledStore == null) {
            this.disabledStore = this.router.getStateStore().getRegisteredRecordStore(DisabledNameserviceStore.class);
            if (this.disabledStore == null) {
                throw new IOException("Disabled Nameservice state store is not available.");
            }
        }
        return this.disabledStore;
    }

    public InetSocketAddress getRpcAddress() {
        return this.adminAddress;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = configuration;
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        this.adminServer.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.adminServer != null) {
            this.adminServer.stop();
        }
        super.serviceStop();
    }

    @Override
    public AddMountTableEntryResponse addMountTableEntry(AddMountTableEntryRequest request) throws IOException {
        return this.getMountTableStore().addMountTableEntry(request);
    }

    @Override
    public UpdateMountTableEntryResponse updateMountTableEntry(UpdateMountTableEntryRequest request) throws IOException {
        UpdateMountTableEntryResponse response = this.getMountTableStore().updateMountTableEntry(request);
        MountTable mountTable = request.getEntry();
        if (mountTable != null) {
            this.synchronizeQuota(mountTable);
        }
        return response;
    }

    private void synchronizeQuota(MountTable mountTable) throws IOException {
        HdfsFileStatus ret;
        String path = mountTable.getSourcePath();
        long nsQuota = mountTable.getQuota().getQuota();
        long ssQuota = mountTable.getQuota().getSpaceQuota();
        if ((nsQuota != Long.MAX_VALUE || ssQuota != Long.MAX_VALUE) && (ret = this.router.getRpcServer().getFileInfo(path)) != null) {
            this.router.getRpcServer().getQuotaModule().setQuota(path, nsQuota, ssQuota, null);
        }
    }

    @Override
    public RemoveMountTableEntryResponse removeMountTableEntry(RemoveMountTableEntryRequest request) throws IOException {
        return this.getMountTableStore().removeMountTableEntry(request);
    }

    @Override
    public GetMountTableEntriesResponse getMountTableEntries(GetMountTableEntriesRequest request) throws IOException {
        return this.getMountTableStore().getMountTableEntries(request);
    }

    @Override
    public EnterSafeModeResponse enterSafeMode(EnterSafeModeRequest request) throws IOException {
        boolean success = false;
        RouterSafemodeService safeModeService = this.router.getSafemodeService();
        if (safeModeService != null) {
            this.router.updateRouterState(RouterServiceState.SAFEMODE);
            safeModeService.setManualSafeMode(true);
            success = this.verifySafeMode(true);
        }
        return EnterSafeModeResponse.newInstance(success);
    }

    @Override
    public LeaveSafeModeResponse leaveSafeMode(LeaveSafeModeRequest request) throws IOException {
        boolean success = false;
        RouterSafemodeService safeModeService = this.router.getSafemodeService();
        if (safeModeService != null) {
            this.router.updateRouterState(RouterServiceState.RUNNING);
            safeModeService.setManualSafeMode(false);
            success = this.verifySafeMode(false);
        }
        return LeaveSafeModeResponse.newInstance(success);
    }

    @Override
    public GetSafeModeResponse getSafeMode(GetSafeModeRequest request) throws IOException {
        boolean isInSafeMode = false;
        RouterSafemodeService safeModeService = this.router.getSafemodeService();
        if (safeModeService != null) {
            isInSafeMode = safeModeService.isInSafeMode();
        }
        return GetSafeModeResponse.newInstance(isInSafeMode);
    }

    private boolean verifySafeMode(boolean isInSafeMode) {
        Preconditions.checkNotNull((Object)((Object)this.router.getSafemodeService()));
        boolean serverInSafeMode = this.router.getSafemodeService().isInSafeMode();
        RouterServiceState currentState = this.router.getRouterState();
        return isInSafeMode && currentState == RouterServiceState.SAFEMODE && serverInSafeMode || !isInSafeMode && currentState != RouterServiceState.SAFEMODE && !serverInSafeMode;
    }

    @Override
    public DisableNameserviceResponse disableNameservice(DisableNameserviceRequest request) throws IOException {
        RouterPermissionChecker pc = RouterAdminServer.getPermissionChecker();
        if (pc != null) {
            pc.checkSuperuserPrivilege();
        }
        String nsId = request.getNameServiceId();
        boolean success = false;
        if (this.namespaceExists(nsId)) {
            success = this.getDisabledNameserviceStore().disableNameservice(nsId);
        } else {
            LOG.error("Cannot disable {}, it does not exists", (Object)nsId);
        }
        return DisableNameserviceResponse.newInstance(success);
    }

    private boolean namespaceExists(String nsId) throws IOException {
        boolean found = false;
        ActiveNamenodeResolver resolver = this.router.getNamenodeResolver();
        Set<FederationNamespaceInfo> nss = resolver.getNamespaces();
        for (FederationNamespaceInfo ns : nss) {
            if (!nsId.equals(ns.getNameserviceId())) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public EnableNameserviceResponse enableNameservice(EnableNameserviceRequest request) throws IOException {
        RouterPermissionChecker pc = RouterAdminServer.getPermissionChecker();
        if (pc != null) {
            pc.checkSuperuserPrivilege();
        }
        String nsId = request.getNameServiceId();
        DisabledNameserviceStore store = this.getDisabledNameserviceStore();
        Set<String> disabled = store.getDisabledNameservices();
        boolean success = false;
        if (disabled.contains(nsId)) {
            success = store.enableNameservice(nsId);
        } else {
            LOG.error("Cannot enable {}, it was not disabled", (Object)nsId);
        }
        return EnableNameserviceResponse.newInstance(success);
    }

    @Override
    public GetDisabledNameservicesResponse getDisabledNameservices(GetDisabledNameservicesRequest request) throws IOException {
        Set<String> nsIds = this.getDisabledNameserviceStore().getDisabledNameservices();
        return GetDisabledNameservicesResponse.newInstance(nsIds);
    }

    public static RouterPermissionChecker getPermissionChecker() throws AccessControlException {
        if (!isPermissionEnabled) {
            return null;
        }
        try {
            return new RouterPermissionChecker(routerOwner, superGroup, NameNode.getRemoteUser());
        }
        catch (IOException e) {
            throw new AccessControlException((Throwable)e);
        }
    }

    public static String getSuperUser() {
        return routerOwner;
    }

    public static String getSuperGroup() {
        return superGroup;
    }
}

