/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.impl;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.store.DisabledNameserviceStore;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.DisabledNameservice;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DisabledNameserviceStoreImpl
extends DisabledNameserviceStore {
    public DisabledNameserviceStoreImpl(StateStoreDriver driver) {
        super(driver);
    }

    @Override
    public boolean disableNameservice(String nsId) throws IOException {
        DisabledNameservice record = DisabledNameservice.newInstance(nsId);
        return this.getDriver().put(record, false, false);
    }

    @Override
    public boolean enableNameservice(String nsId) throws IOException {
        DisabledNameservice record = DisabledNameservice.newInstance(nsId);
        return this.getDriver().remove(record);
    }

    @Override
    public Set<String> getDisabledNameservices() throws IOException {
        TreeSet<String> disabledNameservices = new TreeSet<String>();
        for (DisabledNameservice record : this.getCachedRecords()) {
            String nsId = record.getNameserviceId();
            disabledNameservices.add(nsId);
        }
        return disabledNameservices;
    }
}

