/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.protocol.impl.pb;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.codec.binary.Base64;

public class FederationProtocolPBTranslator<P extends GeneratedMessage, B extends Message.Builder, T extends MessageOrBuilder> {
    private P proto;
    private Class<P> protoClass;
    private B builder;

    public FederationProtocolPBTranslator(Class<P> protoType) {
        this.protoClass = protoType;
    }

    public void setProto(Message p) {
        if (this.protoClass.isInstance(p)) {
            if (this.builder != null) {
                this.builder.mergeFrom((Message)((GeneratedMessage)p));
            } else {
                this.proto = (GeneratedMessage)p;
            }
        } else {
            throw new IllegalArgumentException("Cannot decode proto type " + p.getClass().getName());
        }
    }

    public B getBuilder() {
        if (this.builder == null) {
            try {
                Method method = this.protoClass.getMethod("newBuilder", new Class[0]);
                this.builder = (Message.Builder)method.invoke(null, new Object[0]);
                if (this.proto != null) {
                    this.builder.mergeFrom(this.proto);
                }
            }
            catch (ReflectiveOperationException e) {
                this.builder = null;
            }
        }
        return this.builder;
    }

    public P build() {
        if (this.builder != null) {
            Message m = this.builder.build();
            return (P)((GeneratedMessage)m);
        }
        if (this.proto != null) {
            return this.proto;
        }
        return null;
    }

    public T getProtoOrBuilder() {
        if (this.builder != null) {
            return (T)this.builder;
        }
        if (this.proto != null) {
            return (T)this.proto;
        }
        return (T)this.getBuilder();
    }

    public void readInstance(String base64String) throws IOException {
        byte[] bytes = Base64.decodeBase64((String)base64String);
        Message msg = this.getBuilder().mergeFrom(bytes).build();
        this.proto = (GeneratedMessage)msg;
    }
}

