/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.constants.FileSystemConfigurations;
import org.apache.hadoop.fs.azurebfs.contracts.annotations.ConfigurationValidationAnnotations;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.ConfigurationPropertyNotFoundException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.KeyProviderException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.TokenAccessProviderException;
import org.apache.hadoop.fs.azurebfs.diagnostics.Base64StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.BooleanConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.IntegerConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.LongConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.diagnostics.StringConfigurationBasicValidator;
import org.apache.hadoop.fs.azurebfs.extensions.AbfsAuthorizationException;
import org.apache.hadoop.fs.azurebfs.extensions.AbfsAuthorizer;
import org.apache.hadoop.fs.azurebfs.extensions.CustomTokenProviderAdaptee;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.CustomTokenProviderAdapter;
import org.apache.hadoop.fs.azurebfs.oauth2.MsiTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.RefreshTokenBasedTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.UserPasswordTokenProvider;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.azurebfs.services.KeyProvider;
import org.apache.hadoop.fs.azurebfs.services.SimpleKeyProvider;
import org.apache.hadoop.fs.azurebfs.utils.SSLSocketFactoryEx;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AbfsConfiguration {
    private final Configuration rawConfig;
    private final String accountName;
    private final boolean isSecure;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.write.request.size", MinValue=16384, MaxValue=0x6400000, DefaultValue=0x800000)
    private int writeBufferSize;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.read.request.size", MinValue=16384, MaxValue=0x6400000, DefaultValue=0x400000)
    private int readBufferSize;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.min.backoff.interval", DefaultValue=3000)
    private int minBackoffInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.max.backoff.interval", DefaultValue=30000)
    private int maxBackoffInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.backoff.interval", DefaultValue=3000)
    private int backoffInterval;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.retry.max.retries", MinValue=0, DefaultValue=30)
    private int maxIoRetries;
    @ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.block.size", MinValue=0L, MaxValue=0x10000000L, DefaultValue=0x10000000L)
    private long azureBlockSize;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.block.location.impersonatedhost", DefaultValue="localhost")
    private String azureBlockLocationHost;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.concurrentRequestCount.out", MinValue=1, DefaultValue=8)
    private int maxConcurrentWriteThreads;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.concurrentRequestCount.in", MinValue=1, DefaultValue=12)
    private int maxConcurrentReadThreads;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.io.read.tolerate.concurrent.append", DefaultValue=false)
    private boolean tolerateOobAppends;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.atomic.rename.key", DefaultValue="/hbase")
    private String azureAtomicDirs;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.createRemoteFileSystemDuringInitialization", DefaultValue=false)
    private boolean createRemoteFileSystemDuringInitialization;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.skipUserGroupMetadataDuringInitialization", DefaultValue=false)
    private boolean skipUserGroupMetadataDuringInitialization;
    @ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.readaheadqueue.depth", DefaultValue=-1)
    private int readAheadQueueDepth;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.flush", DefaultValue=true)
    private boolean enableFlush;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.disable.outputstream.flush", DefaultValue=true)
    private boolean disableOutputStreamFlush;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.autothrottling", DefaultValue=true)
    private boolean enableAutoThrottling;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.user.agent.prefix", DefaultValue="")
    private String userAgentId;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.delegation.token", DefaultValue=false)
    private boolean enableDelegationToken;
    @ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation(ConfigurationKey="abfs.external.authorization.class", DefaultValue="")
    private String abfsExternalAuthorizationClass;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.always.use.https", DefaultValue=true)
    private boolean alwaysUseHttps;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.use.upn", DefaultValue=false)
    private boolean useUpn;
    @ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation(ConfigurationKey="fs.azure.enable.check.access", DefaultValue=false)
    private boolean isCheckAccessEnabled;
    private Map<String, String> storageAccountKeys;

    public AbfsConfiguration(Configuration rawConfig, String accountName) throws IllegalAccessException, InvalidConfigurationValueException, IOException {
        Field[] fields;
        this.rawConfig = ProviderUtils.excludeIncompatibleCredentialProviders((Configuration)rawConfig, AzureBlobFileSystem.class);
        this.accountName = accountName;
        this.isSecure = this.getBoolean("fs.azure.secure.mode", false);
        this.validateStorageAccountKeys();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateInt(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateLong(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateString(field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation.class)) {
                field.set(this, this.validateBase64String(field));
                continue;
            }
            if (!field.isAnnotationPresent(ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation.class)) continue;
            field.set(this, this.validateBoolean(field));
        }
    }

    public String accountConf(String key) {
        return key + "." + this.accountName;
    }

    public String get(String key) {
        return this.rawConfig.get(this.accountConf(key), this.rawConfig.get(key));
    }

    public String getString(String key, String defaultValue) {
        return this.rawConfig.get(this.accountConf(key), this.rawConfig.get(key, defaultValue));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.rawConfig.getBoolean(this.accountConf(key), this.rawConfig.getBoolean(key, defaultValue));
    }

    public long getLong(String key, long defaultValue) {
        return this.rawConfig.getLong(this.accountConf(key), this.rawConfig.getLong(key, defaultValue));
    }

    public String getPasswordString(String key) throws IOException {
        char[] passchars = this.rawConfig.getPassword(this.accountConf(key));
        if (passchars == null) {
            passchars = this.rawConfig.getPassword(key);
        }
        if (passchars != null) {
            return new String(passchars);
        }
        return null;
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        return this.rawConfig.getClass(this.accountConf(name), this.rawConfig.getClass(name, defaultValue, xface), xface);
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        return (T)this.rawConfig.getEnum(this.accountConf(name), this.rawConfig.getEnum(name, defaultValue));
    }

    public void unset(String key) {
        this.rawConfig.unset(key);
    }

    public void set(String key, String value) {
        this.rawConfig.set(key, value);
    }

    public void setBoolean(String key, boolean value) {
        this.rawConfig.setBoolean(key, value);
    }

    public boolean isSecureMode() {
        return this.isSecure;
    }

    public String getStorageAccountKey() throws AzureBlobFileSystemException {
        KeyProvider keyProvider;
        String keyProviderClass = this.get("fs.azure.account.keyprovider");
        if (keyProviderClass == null) {
            keyProvider = new SimpleKeyProvider();
        } else {
            Object keyProviderObject;
            try {
                Class clazz = this.rawConfig.getClassByName(keyProviderClass);
                keyProviderObject = clazz.newInstance();
            }
            catch (Exception e) {
                throw new KeyProviderException("Unable to load key provider class.", (Throwable)e);
            }
            if (!(keyProviderObject instanceof KeyProvider)) {
                throw new KeyProviderException(keyProviderClass + " specified in config is not a valid KeyProvider class.");
            }
            keyProvider = (KeyProvider)keyProviderObject;
        }
        String key = keyProvider.getStorageAccountKey(this.accountName, this.rawConfig);
        if (key == null) {
            throw new ConfigurationPropertyNotFoundException(this.accountName);
        }
        return key;
    }

    public Configuration getRawConfiguration() {
        return this.rawConfig;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getMinBackoffIntervalMilliseconds() {
        return this.minBackoffInterval;
    }

    public int getMaxBackoffIntervalMilliseconds() {
        return this.maxBackoffInterval;
    }

    public int getBackoffIntervalMilliseconds() {
        return this.backoffInterval;
    }

    public int getMaxIoRetries() {
        return this.maxIoRetries;
    }

    public long getAzureBlockSize() {
        return this.azureBlockSize;
    }

    public boolean isCheckAccessEnabled() {
        return this.isCheckAccessEnabled;
    }

    public String getAzureBlockLocationHost() {
        return this.azureBlockLocationHost;
    }

    public int getMaxConcurrentWriteThreads() {
        return this.maxConcurrentWriteThreads;
    }

    public int getMaxConcurrentReadThreads() {
        return this.maxConcurrentReadThreads;
    }

    public boolean getTolerateOobAppends() {
        return this.tolerateOobAppends;
    }

    public String getAzureAtomicRenameDirs() {
        return this.azureAtomicDirs;
    }

    public boolean getCreateRemoteFileSystemDuringInitialization() {
        return this.createRemoteFileSystemDuringInitialization;
    }

    public boolean getSkipUserGroupMetadataDuringInitialization() {
        return this.skipUserGroupMetadataDuringInitialization;
    }

    public int getReadAheadQueueDepth() {
        return this.readAheadQueueDepth;
    }

    public boolean isFlushEnabled() {
        return this.enableFlush;
    }

    public boolean isOutputStreamFlushDisabled() {
        return this.disableOutputStreamFlush;
    }

    public boolean isAutoThrottlingEnabled() {
        return this.enableAutoThrottling;
    }

    public String getCustomUserAgentPrefix() {
        return this.userAgentId;
    }

    public SSLSocketFactoryEx.SSLChannelMode getPreferredSSLFactoryOption() {
        return this.getEnum("fs.azure.ssl.channel.mode", FileSystemConfigurations.DEFAULT_FS_AZURE_SSL_CHANNEL_MODE);
    }

    public AuthType getAuthType(String accountName) {
        return this.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
    }

    public boolean isDelegationTokenManagerEnabled() {
        return this.enableDelegationToken;
    }

    public AbfsDelegationTokenManager getDelegationTokenManager() throws IOException {
        return new AbfsDelegationTokenManager(this.getRawConfiguration());
    }

    public boolean isHttpsAlwaysUsed() {
        return this.alwaysUseHttps;
    }

    public boolean isUpnUsed() {
        return this.useUpn;
    }

    public AccessTokenProvider getTokenProvider() throws TokenAccessProviderException {
        AuthType authType = this.getEnum("fs.azure.account.auth.type", AuthType.SharedKey);
        if (authType == AuthType.OAuth) {
            try {
                Class<AccessTokenProvider> tokenProviderClass = this.getClass("fs.azure.account.oauth.provider.type", null, AccessTokenProvider.class);
                AccessTokenProvider tokenProvider = null;
                if (tokenProviderClass == ClientCredsTokenProvider.class) {
                    String authEndpoint = this.getPasswordString("fs.azure.account.oauth2.client.endpoint");
                    String clientId = this.getPasswordString("fs.azure.account.oauth2.client.id");
                    String clientSecret = this.getPasswordString("fs.azure.account.oauth2.client.secret");
                    tokenProvider = new ClientCredsTokenProvider(authEndpoint, clientId, clientSecret);
                } else if (tokenProviderClass == UserPasswordTokenProvider.class) {
                    String authEndpoint = this.getPasswordString("fs.azure.account.oauth2.client.endpoint");
                    String username = this.getPasswordString("fs.azure.account.oauth2.user.name");
                    String password = this.getPasswordString("fs.azure.account.oauth2.user.password");
                    tokenProvider = new UserPasswordTokenProvider(authEndpoint, username, password);
                } else if (tokenProviderClass == MsiTokenProvider.class) {
                    String authEndpoint = this.getTrimmedPasswordString("fs.azure.account.oauth2.msi.endpoint", "http://169.254.169.254/metadata/identity/oauth2/token");
                    String tenantGuid = this.getPasswordString("fs.azure.account.oauth2.msi.tenant");
                    String clientId = this.getPasswordString("fs.azure.account.oauth2.client.id");
                    String authority = this.getTrimmedPasswordString("fs.azure.account.oauth2.msi.authority", "https://login.microsoftonline.com/");
                    authority = this.appendSlashIfNeeded(authority);
                    tokenProvider = new MsiTokenProvider(authEndpoint, tenantGuid, clientId, authority);
                } else if (tokenProviderClass == RefreshTokenBasedTokenProvider.class) {
                    String authEndpoint = this.getTrimmedPasswordString("fs.azure.account.oauth2.refresh.token.endpoint", "https://login.microsoftonline.com/Common/oauth2/token");
                    String refreshToken = this.getPasswordString("fs.azure.account.oauth2.refresh.token");
                    String clientId = this.getPasswordString("fs.azure.account.oauth2.client.id");
                    tokenProvider = new RefreshTokenBasedTokenProvider(authEndpoint, clientId, refreshToken);
                } else {
                    throw new IllegalArgumentException("Failed to initialize " + tokenProviderClass);
                }
                return tokenProvider;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TokenAccessProviderException("Unable to load key provider class.", (Throwable)e);
            }
        }
        if (authType == AuthType.Custom) {
            try {
                String configKey = "fs.azure.account.oauth.provider.type";
                Class<CustomTokenProviderAdaptee> customTokenProviderClass = this.getClass(configKey, null, CustomTokenProviderAdaptee.class);
                if (customTokenProviderClass == null) {
                    throw new IllegalArgumentException(String.format("The configuration value for \"%s\" is invalid.", configKey));
                }
                CustomTokenProviderAdaptee azureTokenProvider = (CustomTokenProviderAdaptee)ReflectionUtils.newInstance(customTokenProviderClass, (Configuration)this.rawConfig);
                if (azureTokenProvider == null) {
                    throw new IllegalArgumentException("Failed to initialize " + customTokenProviderClass);
                }
                azureTokenProvider.initialize(this.rawConfig, this.accountName);
                return new CustomTokenProviderAdapter(azureTokenProvider);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TokenAccessProviderException("Unable to load custom token provider class.", (Throwable)e);
            }
        }
        throw new TokenAccessProviderException(String.format("Invalid auth type: %s is being used, expecting OAuth", new Object[]{authType}));
    }

    public String getAbfsExternalAuthorizationClass() {
        return this.abfsExternalAuthorizationClass;
    }

    public AbfsAuthorizer getAbfsAuthorizer() throws IOException {
        String authClassName = this.getAbfsExternalAuthorizationClass();
        AbfsAuthorizer authorizer = null;
        try {
            if (authClassName != null && !authClassName.isEmpty()) {
                Class authClass = this.rawConfig.getClassByName(authClassName);
                authorizer = (AbfsAuthorizer)authClass.getConstructor(Configuration.class).newInstance(this.rawConfig);
                authorizer.init();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | AbfsAuthorizationException e) {
            throw new IOException(e);
        }
        return authorizer;
    }

    void validateStorageAccountKeys() throws InvalidConfigurationValueException {
        Base64StringConfigurationBasicValidator validator = new Base64StringConfigurationBasicValidator("fs.azure.account.key", "", true);
        this.storageAccountKeys = this.rawConfig.getValByRegex("fs\\.azure\\.account\\.key\\.(.*)");
        for (Map.Entry<String, String> account : this.storageAccountKeys.entrySet()) {
            validator.validate(account.getValue());
        }
    }

    int validateInt(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.IntegerConfigurationValidatorAnnotation.class);
        String value = this.get(validator.ConfigurationKey());
        return new IntegerConfigurationBasicValidator(validator.MinValue(), validator.MaxValue(), validator.DefaultValue(), validator.ConfigurationKey(), validator.ThrowIfInvalid()).validate(value);
    }

    long validateLong(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.LongConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new LongConfigurationBasicValidator(validator.MinValue(), validator.MaxValue(), validator.DefaultValue(), validator.ConfigurationKey(), validator.ThrowIfInvalid()).validate(value);
    }

    String validateString(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.StringConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new StringConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    String validateBase64String(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.Base64StringConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new Base64StringConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    boolean validateBoolean(Field field) throws IllegalAccessException, InvalidConfigurationValueException {
        ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation validator = field.getAnnotation(ConfigurationValidationAnnotations.BooleanConfigurationValidatorAnnotation.class);
        String value = this.rawConfig.get(validator.ConfigurationKey());
        return new BooleanConfigurationBasicValidator(validator.ConfigurationKey(), validator.DefaultValue(), validator.ThrowIfInvalid()).validate(value);
    }

    @VisibleForTesting
    void setReadBufferSize(int bufferSize) {
        this.readBufferSize = bufferSize;
    }

    @VisibleForTesting
    void setWriteBufferSize(int bufferSize) {
        this.writeBufferSize = bufferSize;
    }

    @VisibleForTesting
    void setEnableFlush(boolean enableFlush) {
        this.enableFlush = enableFlush;
    }

    @VisibleForTesting
    void setDisableOutputStreamFlush(boolean disableOutputStreamFlush) {
        this.disableOutputStreamFlush = disableOutputStreamFlush;
    }

    private String getTrimmedPasswordString(String key, String defaultValue) throws IOException {
        String value = this.getPasswordString(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = defaultValue;
        }
        return value.trim();
    }

    private String appendSlashIfNeeded(String authority) {
        if (!authority.endsWith("/")) {
            authority = authority + "/";
        }
        return authority;
    }
}

