/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;

class JobHistoryFileParser {
    private static final Log LOG = LogFactory.getLog(JobHistoryFileParser.class);
    private final FileSystem fs;

    public JobHistoryFileParser(FileSystem fs) {
        LOG.info((Object)("JobHistoryFileParser created with " + fs));
        this.fs = fs;
    }

    public JobHistoryParser.JobInfo parseHistoryFile(Path path) throws IOException {
        LOG.info((Object)("parsing job history file " + path));
        JobHistoryParser parser = new JobHistoryParser(this.fs, path);
        return parser.parse();
    }

    public Configuration parseConfiguration(Path path) throws IOException {
        LOG.info((Object)("parsing job configuration file " + path));
        Configuration conf = new Configuration(false);
        conf.addResource((InputStream)this.fs.open(path));
        return conf;
    }
}

