/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.junit.Assert;
import org.junit.Test;

public class TestInitializeMountTableResolver {
    @Test
    public void testDefaultNameserviceIsMissing() {
        Configuration conf = new Configuration();
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assert.assertEquals((Object)"", (Object)mountTable.getDefaultNamespace());
    }

    @Test
    public void testDefaultNameserviceWithEmptyString() {
        Configuration conf = new Configuration();
        conf.set("dfs.federation.router.default.nameserviceId", "");
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assert.assertEquals((Object)"", (Object)mountTable.getDefaultNamespace());
    }

    @Test
    public void testRouterDefaultNameservice() {
        Configuration conf = new Configuration();
        conf.set("dfs.federation.router.default.nameserviceId", "router_ns");
        conf.set("dfs.nameservice.id", "ns_id");
        conf.set("dfs.nameservices", "nss");
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assert.assertEquals((Object)"router_ns", (Object)mountTable.getDefaultNamespace());
    }

    @Test
    public void testNameserviceID() {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservice.id", "ns_id");
        conf.set("dfs.nameservices", "nss");
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assert.assertEquals((Object)"ns_id", (Object)mountTable.getDefaultNamespace());
    }

    @Test
    public void testSingleNameservices() {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservices", "ns1");
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assert.assertEquals((Object)"ns1", (Object)mountTable.getDefaultNamespace());
    }

    @Test
    public void testMultipleNameservices() {
        Configuration conf = new Configuration();
        conf.set("dfs.nameservices", "ns1,ns2");
        MountTableResolver mountTable = new MountTableResolver(conf);
        Assert.assertEquals((Object)"ns1", (Object)mountTable.getDefaultNamespace());
    }
}

