/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.hadoop.cli.util.CLICommand;
import org.apache.hadoop.cli.util.CLICommandFS;
import org.apache.hadoop.cli.util.CLITestCmd;
import org.apache.hadoop.cli.util.CLITestData;
import org.apache.hadoop.cli.util.CommandExecutor;
import org.apache.hadoop.cli.util.ComparatorBase;
import org.apache.hadoop.cli.util.ComparatorData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CLITestHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)CLITestHelper.class.getName());
    public static final String TESTMODE_TEST = "test";
    public static final String TESTMODE_NOCOMPARE = "nocompare";
    public static final String TEST_CACHE_DATA_DIR = System.getProperty("test.cache.data", "build/test/cache");
    protected String testMode = "test";
    protected ArrayList<CLITestData> testsFromConfigFile = null;
    protected ArrayList<ComparatorData> testComparators = null;
    protected String thisTestCaseName = null;
    protected ComparatorData comparatorData = null;
    protected Configuration conf = null;
    protected String clitestDataDir = null;
    protected String username = null;

    protected void readTestConfigFile() {
        String testConfigFile = this.getTestFile();
        if (this.testsFromConfigFile == null) {
            boolean success = false;
            testConfigFile = TEST_CACHE_DATA_DIR + File.separator + testConfigFile;
            try {
                SAXParser p = SAXParserFactory.newInstance().newSAXParser();
                p.parse(testConfigFile, (DefaultHandler)this.getConfigParser());
                success = true;
            }
            catch (Exception e) {
                LOG.info("File: " + testConfigFile + " not found");
                success = false;
            }
            Assert.assertTrue((String)"Error reading test config file", (boolean)success);
        }
    }

    protected TestConfigFileParser getConfigParser() {
        return new TestConfigFileParser();
    }

    protected String getTestFile() {
        return "";
    }

    public void setUp() throws Exception {
        this.readTestConfigFile();
        this.conf = new Configuration();
        this.conf.setBoolean("hadoop.security.authorization", true);
        this.clitestDataDir = new File(TEST_CACHE_DATA_DIR).toURI().toString().replace(' ', '+');
    }

    public void tearDown() throws Exception {
        this.displayResults();
    }

    protected String expandCommand(String cmd) {
        String expCmd = cmd;
        expCmd = expCmd.replaceAll("CLITEST_DATA", this.clitestDataDir);
        expCmd = expCmd.replaceAll("USERNAME", this.username);
        return expCmd;
    }

    private void displayResults() {
        int i;
        LOG.info("Detailed results:");
        LOG.info("----------------------------------\n");
        for (int i2 = 0; i2 < this.testsFromConfigFile.size(); ++i2) {
            CLITestData td = this.testsFromConfigFile.get(i2);
            boolean testResult = td.getTestResult();
            if (testResult) continue;
            LOG.info("-------------------------------------------");
            LOG.info("                    Test ID: [" + (i2 + 1) + "]");
            LOG.info("           Test Description: [" + td.getTestDesc() + "]");
            LOG.info("");
            ArrayList<CLICommand> testCommands = td.getTestCommands();
            for (CLICommand cmd : testCommands) {
                LOG.info("              Test Commands: [" + this.expandCommand(cmd.getCmd()) + "]");
            }
            LOG.info("");
            ArrayList<CLICommand> cleanupCommands = td.getCleanupCommands();
            for (CLICommand cmd : cleanupCommands) {
                LOG.info("           Cleanup Commands: [" + this.expandCommand(cmd.getCmd()) + "]");
            }
            LOG.info("");
            ArrayList<ComparatorData> compdata = td.getComparatorData();
            for (ComparatorData cd : compdata) {
                boolean resultBoolean = cd.getTestResult();
                LOG.info("                 Comparator: [" + cd.getComparatorType() + "]");
                LOG.info("         Comparision result:   [" + (resultBoolean ? "pass" : "fail") + "]");
                LOG.info("            Expected output:   [" + this.expandCommand(cd.getExpectedOutput()) + "]");
                LOG.info("              Actual output:   [" + cd.getActualOutput() + "]");
            }
            LOG.info("");
        }
        LOG.info("Summary results:");
        LOG.info("----------------------------------\n");
        boolean overallResults = true;
        int totalPass = 0;
        int totalFail = 0;
        int totalComparators = 0;
        for (i = 0; i < this.testsFromConfigFile.size(); ++i) {
            CLITestData td = this.testsFromConfigFile.get(i);
            totalComparators += this.testsFromConfigFile.get(i).getComparatorData().size();
            boolean resultBoolean = td.getTestResult();
            if (resultBoolean) {
                ++totalPass;
            } else {
                ++totalFail;
            }
            overallResults &= resultBoolean;
        }
        LOG.info("               Testing mode: " + this.testMode);
        LOG.info("");
        LOG.info("             Overall result: " + (overallResults ? "+++ PASS +++" : "--- FAIL ---"));
        if (totalPass + totalFail == 0) {
            LOG.info("               # Tests pass: 0");
            LOG.info("               # Tests fail: 0");
        } else {
            LOG.info("               # Tests pass: " + totalPass + " (" + 100 * totalPass / (totalPass + totalFail) + "%)");
            LOG.info("               # Tests fail: " + totalFail + " (" + 100 * totalFail / (totalPass + totalFail) + "%)");
        }
        LOG.info("         # Validations done: " + totalComparators + " (each test may do multiple validations)");
        LOG.info("");
        LOG.info("Failing tests:");
        LOG.info("--------------");
        i = 0;
        boolean foundTests = false;
        for (i = 0; i < this.testsFromConfigFile.size(); ++i) {
            boolean resultBoolean = this.testsFromConfigFile.get(i).getTestResult();
            if (resultBoolean) continue;
            LOG.info(i + 1 + ": " + this.testsFromConfigFile.get(i).getTestDesc());
            foundTests = true;
        }
        if (!foundTests) {
            LOG.info("NONE");
        }
        foundTests = false;
        LOG.info("");
        LOG.info("Passing tests:");
        LOG.info("--------------");
        for (i = 0; i < this.testsFromConfigFile.size(); ++i) {
            boolean resultBoolean = this.testsFromConfigFile.get(i).getTestResult();
            if (!resultBoolean) continue;
            LOG.info(i + 1 + ": " + this.testsFromConfigFile.get(i).getTestDesc());
            foundTests = true;
        }
        if (!foundTests) {
            LOG.info("NONE");
        }
        Assert.assertTrue((String)"One of the tests failed. See the Detailed results to identify the command that failed", (boolean)overallResults);
    }

    private boolean compareTestOutput(ComparatorData compdata, CommandExecutor.Result cmdResult) {
        String comparatorType = compdata.getComparatorType();
        Class<?> comparatorClass = null;
        boolean compareOutput = false;
        if (this.testMode.equals(TESTMODE_TEST)) {
            try {
                comparatorClass = Class.forName("org.apache.hadoop.cli.util." + comparatorType);
                ComparatorBase comp = (ComparatorBase)comparatorClass.newInstance();
                compareOutput = comp.compare(cmdResult.getCommandOutput(), this.expandCommand(compdata.getExpectedOutput()));
            }
            catch (Exception e) {
                LOG.info("Error in instantiating the comparator" + e);
            }
        }
        return compareOutput;
    }

    private boolean compareTextExitCode(ComparatorData compdata, CommandExecutor.Result cmdResult) {
        return compdata.getExitCode() == cmdResult.getExitCode();
    }

    public void testAll() {
        Assert.assertTrue((String)"Number of tests has to be greater then zero", (this.testsFromConfigFile.size() > 0 ? 1 : 0) != 0);
        LOG.info("TestAll");
        for (int index = 0; index < this.testsFromConfigFile.size(); ++index) {
            CLITestData testdata = this.testsFromConfigFile.get(index);
            ArrayList<CLICommand> testCommands = testdata.getTestCommands();
            CommandExecutor.Result cmdResult = null;
            for (CLICommand cmd : testCommands) {
                try {
                    cmdResult = this.execute(cmd);
                }
                catch (Exception e) {
                    Assert.fail((String)StringUtils.stringifyException((Throwable)e));
                }
            }
            boolean overallTCResult = true;
            ArrayList<ComparatorData> compdata = testdata.getComparatorData();
            for (ComparatorData cd : compdata) {
                String comptype = cd.getComparatorType();
                boolean compareOutput = false;
                boolean compareExitCode = false;
                if (!comptype.equalsIgnoreCase("none")) {
                    compareOutput = this.compareTestOutput(cd, cmdResult);
                    compareExitCode = cd.getExitCode() == -1 ? true : this.compareTextExitCode(cd, cmdResult);
                    overallTCResult &= compareOutput & compareExitCode;
                }
                cd.setExitCode(cmdResult.getExitCode());
                cd.setActualOutput(cmdResult.getCommandOutput());
                cd.setTestResult(compareOutput);
            }
            testdata.setTestResult(overallTCResult);
            ArrayList<CLICommand> cleanupCommands = testdata.getCleanupCommands();
            for (CLICommand cmd : cleanupCommands) {
                try {
                    this.execute(cmd);
                }
                catch (Exception e) {
                    Assert.fail((String)StringUtils.stringifyException((Throwable)e));
                }
            }
        }
    }

    protected CommandExecutor.Result execute(CLICommand cmd) throws Exception {
        throw new Exception("Unknown type of test command:" + cmd.getType());
    }

    class TestConfigFileParser
    extends DefaultHandler {
        String charString = null;
        CLITestData td = null;
        ArrayList<CLICommand> testCommands = null;
        ArrayList<CLICommand> cleanupCommands = null;
        boolean runOnWindows = true;

        TestConfigFileParser() {
        }

        @Override
        public void startDocument() throws SAXException {
            CLITestHelper.this.testsFromConfigFile = new ArrayList();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(CLITestHelper.TESTMODE_TEST)) {
                this.td = new CLITestData();
            } else if (qName.equals("test-commands")) {
                this.testCommands = new ArrayList();
            } else if (qName.equals("cleanup-commands")) {
                this.cleanupCommands = new ArrayList();
            } else if (qName.equals("comparators")) {
                CLITestHelper.this.testComparators = new ArrayList();
            } else if (qName.equals("comparator")) {
                CLITestHelper.this.comparatorData = new ComparatorData();
                CLITestHelper.this.comparatorData.setExitCode(-1);
            }
            this.charString = "";
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("description")) {
                this.td.setTestDesc(this.charString);
            } else if (qName.equals("windows")) {
                this.runOnWindows = Boolean.parseBoolean(this.charString);
            } else if (qName.equals("test-commands")) {
                this.td.setTestCommands(this.testCommands);
                this.testCommands = null;
            } else if (qName.equals("cleanup-commands")) {
                this.td.setCleanupCommands(this.cleanupCommands);
                this.cleanupCommands = null;
            } else if (qName.equals("command")) {
                if (this.testCommands != null) {
                    this.testCommands.add(new CLITestCmd(this.charString, new CLICommandFS()));
                } else if (this.cleanupCommands != null) {
                    this.cleanupCommands.add(new CLITestCmd(this.charString, new CLICommandFS()));
                }
            } else if (qName.equals("comparators")) {
                this.td.setComparatorData(CLITestHelper.this.testComparators);
            } else if (qName.equals("comparator")) {
                CLITestHelper.this.testComparators.add(CLITestHelper.this.comparatorData);
            } else if (qName.equals("type")) {
                CLITestHelper.this.comparatorData.setComparatorType(this.charString);
            } else if (qName.equals("expected-output")) {
                CLITestHelper.this.comparatorData.setExpectedOutput(this.charString);
            } else if (qName.equals("expected-exit-code")) {
                CLITestHelper.this.comparatorData.setExitCode(Integer.valueOf(this.charString));
            } else if (qName.equals(CLITestHelper.TESTMODE_TEST)) {
                if (!Shell.WINDOWS || this.runOnWindows) {
                    CLITestHelper.this.testsFromConfigFile.add(this.td);
                }
                this.td = null;
                this.runOnWindows = true;
            } else if (qName.equals("mode")) {
                CLITestHelper.this.testMode = this.charString;
                if (!CLITestHelper.this.testMode.equals(CLITestHelper.TESTMODE_NOCOMPARE) && !CLITestHelper.this.testMode.equals(CLITestHelper.TESTMODE_TEST)) {
                    CLITestHelper.this.testMode = CLITestHelper.TESTMODE_TEST;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String s = new String(ch, start, length);
            this.charString = this.charString + s;
        }
    }
}

