/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.StopWatch;
import org.junit.Assert;
import org.junit.Test;

public class TestStopWatch {
    @Test
    public void testStartAndStop() throws Exception {
        try (StopWatch sw = new StopWatch();){
            Assert.assertFalse((boolean)sw.isRunning());
            sw.start();
            Assert.assertTrue((boolean)sw.isRunning());
            sw.stop();
            Assert.assertFalse((boolean)sw.isRunning());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStopInTryWithResource() throws Exception {
        block5: {
            StopWatch sw = new StopWatch();
            Throwable throwable = null;
            if (sw == null) break block5;
            if (throwable != null) {
                try {
                    sw.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                sw.close();
            }
        }
    }

    @Test
    public void testExceptions() throws Exception {
        StopWatch sw = new StopWatch();
        try {
            sw.stop();
        }
        catch (Exception e) {
            Assert.assertTrue((String)"IllegalStateException is expected", (boolean)(e instanceof IllegalStateException));
        }
        sw.reset();
        sw.start();
        try {
            sw.start();
        }
        catch (Exception e) {
            Assert.assertTrue((String)"IllegalStateException is expected", (boolean)(e instanceof IllegalStateException));
        }
    }
}

