/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.sizeof;

import org.apache.hadoop.shaded.org.ehcache.core.spi.store.Store;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.heap.LimitExceededException;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.heap.SizeOfEngine;
import org.apache.hadoop.shaded.org.ehcache.impl.copy.IdentityCopier;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.sizeof.listeners.EhcacheVisitorListener;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.sizeof.listeners.exceptions.VisitorListenerException;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.heap.holders.CopiedOnHeapKey;
import org.apache.hadoop.shaded.org.ehcache.sizeof.SizeOf;
import org.apache.hadoop.shaded.org.ehcache.sizeof.SizeOfFilterSource;

public class DefaultSizeOfEngine
implements SizeOfEngine {
    private final long maxObjectGraphSize;
    private final long maxObjectSize;
    private final SizeOf sizeOf;
    private final long chmTreeBinOffset;
    private final long onHeapKeyOffset;
    private final SizeOfFilterSource filterSource = new SizeOfFilterSource(true);

    public DefaultSizeOfEngine(long maxObjectGraphSize, long maxObjectSize) {
        this.maxObjectGraphSize = maxObjectGraphSize;
        this.maxObjectSize = maxObjectSize;
        this.sizeOf = SizeOf.newInstance(this.filterSource.getFilters());
        this.onHeapKeyOffset = this.sizeOf.deepSizeOf(new CopiedOnHeapKey<Object>(new Object(), new IdentityCopier()));
        this.chmTreeBinOffset = this.sizeOf.deepSizeOf(ConcurrentHashMap.FAKE_TREE_BIN);
    }

    @Override
    public <K, V> long sizeof(K key, Store.ValueHolder<V> holder) throws LimitExceededException {
        try {
            return this.sizeOf.deepSizeOf(new EhcacheVisitorListener(this.maxObjectGraphSize, this.maxObjectSize), key, holder) + this.chmTreeBinOffset + this.onHeapKeyOffset;
        }
        catch (VisitorListenerException e) {
            throw new LimitExceededException(e.getMessage());
        }
    }
}

