/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RouterResolveException;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreCache;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.cache.Cache;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountTableResolver
implements FileSubclusterResolver,
StateStoreCache {
    private static final Logger LOG = LoggerFactory.getLogger(MountTableResolver.class);
    private final Router router;
    private final StateStoreService stateStore;
    private MountTableStore mountTableStore;
    private boolean init = false;
    private boolean disabled = false;
    private final TreeMap<String, MountTable> tree = new TreeMap();
    private final Cache<String, PathLocation> locationCache;
    private String defaultNameService = "";
    private boolean defaultNSEnable = true;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    @VisibleForTesting
    public MountTableResolver(Configuration conf) {
        this(conf, (StateStoreService)null);
    }

    public MountTableResolver(Configuration conf, Router routerService) {
        this(conf, routerService, null);
    }

    public MountTableResolver(Configuration conf, StateStoreService store) {
        this(conf, null, store);
    }

    public MountTableResolver(Configuration conf, Router routerService, StateStoreService store) {
        this.router = routerService;
        this.stateStore = store != null ? store : (this.router != null ? this.router.getStateStore() : null);
        boolean mountTableCacheEnable = conf.getBoolean("dfs.federation.router.mount-table.cache.enable", true);
        if (mountTableCacheEnable) {
            int maxCacheSize = conf.getInt("dfs.federation.router.mount-table.max-cache-size", 10000);
            this.locationCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).build();
        } else {
            this.locationCache = null;
        }
        this.registerCacheExternal();
        this.initDefaultNameService(conf);
    }

    private void registerCacheExternal() {
        if (this.stateStore != null) {
            this.stateStore.registerCacheExternal(this);
        }
    }

    private void initDefaultNameService(Configuration conf) {
        this.defaultNSEnable = conf.getBoolean("dfs.federation.router.default.nameservice.enable", true);
        if (!this.defaultNSEnable) {
            LOG.warn("Default name service is disabled.");
            return;
        }
        this.defaultNameService = conf.get("dfs.federation.router.default.nameserviceId", "");
        if (this.defaultNameService.equals("")) {
            this.defaultNSEnable = false;
            LOG.warn("Default name service is not set.");
        } else {
            LOG.info("Default name service: {}, enabled to read or write", (Object)this.defaultNameService);
        }
    }

    protected Router getRouter() {
        return this.router;
    }

    protected MountTableStore getMountTableStore() throws IOException {
        if (this.mountTableStore == null) {
            this.mountTableStore = this.stateStore.getRegisteredRecordStore(MountTableStore.class);
            if (this.mountTableStore == null) {
                throw new IOException("State Store does not have an interface for " + MountTableStore.class);
            }
        }
        return this.mountTableStore;
    }

    public void addEntry(MountTable entry) {
        this.writeLock.lock();
        try {
            String srcPath = entry.getSourcePath();
            this.tree.put(srcPath, entry);
            this.invalidateLocationCache(srcPath);
        }
        finally {
            this.writeLock.unlock();
        }
        this.init = true;
    }

    public void removeEntry(String srcPath) {
        this.writeLock.lock();
        try {
            this.tree.remove(srcPath);
            this.invalidateLocationCache(srcPath);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void invalidateLocationCache(String path) {
        LOG.debug("Invalidating {} from {}", (Object)path, this.locationCache);
        if (this.locationCache == null || this.locationCache.size() == 0L) {
            return;
        }
        ConcurrentMap map = this.locationCache.asMap();
        Set entries = map.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            PathLocation loc = (PathLocation)entry.getValue();
            String src = loc.getSourcePath();
            if (src != null) {
                if (!DFSUtil.isParentEntry((String)key, (String)path)) continue;
                LOG.debug("Removing {}", (Object)src);
                it.remove();
                continue;
            }
            String dest = loc.getDefaultLocation().getDest();
            if (!dest.startsWith(path)) continue;
            LOG.debug("Removing default cache {}", (Object)dest);
            it.remove();
        }
        LOG.debug("Location cache after invalidation: {}", this.locationCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void refreshEntries(Collection<MountTable> entries) {
        this.writeLock.lock();
        try {
            String srcPath;
            ConcurrentHashMap<String, MountTable> newEntries = new ConcurrentHashMap<String, MountTable>();
            for (MountTable entry : entries) {
                String srcPath2 = entry.getSourcePath();
                newEntries.put(srcPath2, entry);
            }
            TreeSet oldEntries = new TreeSet(Collections.reverseOrder());
            for (MountTable entry : this.getTreeValues("/")) {
                srcPath = entry.getSourcePath();
                oldEntries.add(srcPath);
            }
            for (String srcPath2 : oldEntries) {
                if (newEntries.containsKey(srcPath2)) continue;
                this.tree.remove(srcPath2);
                this.invalidateLocationCache(srcPath2);
                LOG.info("Removed stale mount point {} from resolver", (Object)srcPath2);
            }
            for (MountTable entry : entries) {
                srcPath = entry.getSourcePath();
                if (!oldEntries.contains(srcPath)) {
                    this.tree.put(srcPath, entry);
                    this.invalidateLocationCache(srcPath);
                    LOG.info("Added new mount point {} to resolver", (Object)srcPath);
                    continue;
                }
                MountTable existingEntry = this.tree.get(srcPath);
                if (existingEntry == null || existingEntry.equals(entry)) continue;
                LOG.info("Entry has changed from \"{}\" to \"{}\"", (Object)existingEntry, (Object)entry);
                this.tree.put(srcPath, entry);
                this.invalidateLocationCache(srcPath);
                LOG.info("Updated mount point {} in resolver", (Object)srcPath);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.init = true;
    }

    @Override
    public boolean loadCache(boolean force) {
        try {
            MountTableStore mountTable = this.getMountTableStore();
            if (!mountTable.loadCache(force)) {
                return false;
            }
            GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance("/");
            GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
            List<MountTable> records = response.getEntries();
            this.refreshEntries(records);
        }
        catch (IOException e) {
            LOG.error("Cannot fetch mount table entries from State Store", (Throwable)e);
            return false;
        }
        return true;
    }

    public void clear() {
        LOG.info("Clearing all mount location caches");
        this.writeLock.lock();
        try {
            if (this.locationCache != null) {
                this.locationCache.invalidateAll();
            }
            this.tree.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public PathLocation getDestinationForPath(final String path) throws IOException {
        this.verifyMountTable();
        this.readLock.lock();
        try {
            if (this.locationCache == null) {
                PathLocation pathLocation = this.lookupLocation(path);
                return pathLocation;
            }
            Callable<PathLocation> meh = new Callable<PathLocation>(){

                @Override
                public PathLocation call() throws Exception {
                    return MountTableResolver.this.lookupLocation(path);
                }
            };
            PathLocation pathLocation = (PathLocation)this.locationCache.get((Object)path, (Callable)meh);
            return pathLocation;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            IOException ioe = cause instanceof IOException ? (IOException)cause : new IOException(cause);
            throw ioe;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public PathLocation lookupLocation(String str) throws IOException {
        PathLocation ret = null;
        String path = RouterAdmin.normalizeFileSystemPath(str);
        MountTable entry = this.findDeepest(path);
        if (entry != null) {
            ret = this.buildLocation(path, entry);
        } else {
            if (!this.defaultNSEnable) {
                throw new RouterResolveException("Cannot find locations for " + path + ", because the default nameservice is disabled to read or write");
            }
            RemoteLocation remoteLocation = new RemoteLocation(this.defaultNameService, path, path);
            List<RemoteLocation> locations = Collections.singletonList(remoteLocation);
            ret = new PathLocation(null, locations);
        }
        return ret;
    }

    public MountTable getMountPoint(String path) throws IOException {
        this.verifyMountTable();
        return this.findDeepest(RouterAdmin.normalizeFileSystemPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMountPoints(String str) throws IOException {
        this.verifyMountTable();
        String path = RouterAdmin.normalizeFileSystemPath(str);
        TreeSet<String> children = new TreeSet<String>();
        this.readLock.lock();
        try {
            String from = path;
            String to = path + '\uffff';
            SortedMap<String, MountTable> subMap = this.tree.subMap(from, to);
            boolean exists = false;
            Object object = subMap.keySet().iterator();
            while (object.hasNext()) {
                String subPath;
                String child = subPath = object.next();
                if (!path.equals("/")) {
                    int ini = path.length();
                    child = subPath.substring(ini);
                }
                if (child.isEmpty()) {
                    exists = true;
                    continue;
                }
                if (!child.startsWith("/")) continue;
                exists = true;
                int fin = (child = child.substring(1)).indexOf("/");
                if (fin > -1) {
                    child = child.substring(0, fin);
                }
                if (child.isEmpty()) continue;
                children.add(child);
            }
            if (!exists) {
                object = null;
                return object;
            }
            object = new LinkedList(children);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<MountTable> getMounts(String path) throws IOException {
        this.verifyMountTable();
        return this.getTreeValues(RouterAdmin.normalizeFileSystemPath(path), false);
    }

    private void verifyMountTable() throws StateStoreUnavailableException {
        if (!this.init || this.disabled) {
            throw new StateStoreUnavailableException("Mount Table not initialized");
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.tree.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private PathLocation buildLocation(String path, MountTable entry) throws IOException {
        String srcPath = entry.getSourcePath();
        if (!path.startsWith(srcPath)) {
            LOG.error("Cannot build location, {} not a child of {}", (Object)path, (Object)srcPath);
            return null;
        }
        List<RemoteLocation> dests = entry.getDestinations();
        if (this.getClass() == MountTableResolver.class && dests.size() > 1) {
            throw new IOException("Cannnot build location, " + this.getClass().getSimpleName() + " should not resolve multiple destinations for " + path);
        }
        String remainingPath = path.substring(srcPath.length());
        if (remainingPath.startsWith("/")) {
            remainingPath = remainingPath.substring(1);
        }
        LinkedList<RemoteLocation> locations = new LinkedList<RemoteLocation>();
        for (RemoteLocation oneDst : dests) {
            String nsId = oneDst.getNameserviceId();
            String dest = oneDst.getDest();
            String newPath = dest;
            if (!newPath.endsWith("/") && !remainingPath.isEmpty()) {
                newPath = newPath + "/";
            }
            newPath = newPath + remainingPath;
            RemoteLocation remoteLocation = new RemoteLocation(nsId, newPath, path);
            locations.add(remoteLocation);
        }
        DestinationOrder order = entry.getDestOrder();
        return new PathLocation(srcPath, locations, order);
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNameService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MountTable findDeepest(String path) {
        this.readLock.lock();
        try {
            Map.Entry<String, MountTable> entry = this.tree.floorEntry(path);
            while (entry != null && !DFSUtil.isParentEntry((String)path, (String)entry.getKey())) {
                entry = this.tree.lowerEntry(entry.getKey());
            }
            if (entry == null) {
                MountTable mountTable = null;
                return mountTable;
            }
            MountTable mountTable = entry.getValue();
            return mountTable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private List<MountTable> getTreeValues(String path) {
        return this.getTreeValues(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MountTable> getTreeValues(String path, boolean reverse) {
        LinkedList<MountTable> ret = new LinkedList<MountTable>();
        this.readLock.lock();
        try {
            String from = path;
            String to = path + '\uffff';
            SortedMap<String, MountTable> subMap = this.tree.subMap(from, to);
            for (MountTable entry : subMap.values()) {
                if (!reverse) {
                    ret.add(entry);
                    continue;
                }
                ret.addFirst(entry);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return ret;
    }

    protected long getCacheSize() throws IOException {
        if (this.locationCache != null) {
            return this.locationCache.size();
        }
        throw new IOException("localCache is null");
    }

    @VisibleForTesting
    public String getDefaultNameService() {
        return this.defaultNameService;
    }

    @VisibleForTesting
    public void setDefaultNameService(String defaultNameService) {
        this.defaultNameService = defaultNameService;
    }

    @VisibleForTesting
    public boolean isDefaultNSEnable() {
        return this.defaultNSEnable;
    }

    @VisibleForTesting
    public void setDefaultNSEnable(boolean defaultNSRWEnable) {
        this.defaultNSEnable = defaultNSRWEnable;
    }

    @VisibleForTesting
    public void setDisabled(boolean disable) {
        this.disabled = disable;
    }
}

