/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.lang.reflect.Constructor;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class RecordStore<R extends BaseRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(RecordStore.class);
    private final Class<R> recordClass;
    private final StateStoreDriver driver;

    protected RecordStore(Class<R> clazz, StateStoreDriver stateStoreDriver) {
        this.recordClass = clazz;
        this.driver = stateStoreDriver;
    }

    public Class<R> getRecordClass() {
        return this.recordClass;
    }

    protected StateStoreDriver getDriver() {
        return this.driver;
    }

    public static <T extends RecordStore<?>> T newInstance(Class<T> clazz, StateStoreDriver driver) {
        try {
            Constructor<T> constructor = clazz.getConstructor(StateStoreDriver.class);
            RecordStore recordStore = (RecordStore)constructor.newInstance(driver);
            return (T)recordStore;
        }
        catch (Exception e) {
            LOG.error("Cannot create new instance for " + clazz, (Throwable)e);
            return null;
        }
    }
}

