/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipStats;

public abstract class MembershipState
extends BaseRecord
implements FederationNamenodeContext {
    public static final String ERROR_MSG_NO_NS_SPECIFIED = "Invalid registration, no nameservice specified ";
    public static final String ERROR_MSG_NO_WEB_ADDR_SPECIFIED = "Invalid registration, no web address specified ";
    public static final String ERROR_MSG_NO_RPC_ADDR_SPECIFIED = "Invalid registration, no rpc address specified ";
    public static final String ERROR_MSG_NO_BP_SPECIFIED = "Invalid registration, no block pool specified ";
    private static long expirationMs;
    private static long deletionMs;
    public static final Comparator<MembershipState> NAME_COMPARATOR;

    public static MembershipState newInstance() {
        MembershipState record = StateStoreSerializer.newRecord(MembershipState.class);
        record.init();
        return record;
    }

    public static MembershipState newInstance(String router, String nameservice, String namenode, String clusterId, String blockPoolId, String rpcAddress, String serviceAddress, String lifelineAddress, String webScheme, String webAddress, FederationNamenodeServiceState state, boolean safemode) {
        MembershipState record = MembershipState.newInstance();
        record.setRouterId(router);
        record.setNameserviceId(nameservice);
        record.setNamenodeId(namenode);
        record.setRpcAddress(rpcAddress);
        record.setServiceAddress(serviceAddress);
        record.setLifelineAddress(lifelineAddress);
        record.setWebAddress(webAddress);
        record.setIsSafeMode(safemode);
        record.setState(state);
        record.setClusterId(clusterId);
        record.setBlockPoolId(blockPoolId);
        record.setWebScheme(webScheme);
        record.validate();
        return record;
    }

    public abstract void setRouterId(String var1);

    public abstract String getRouterId();

    public abstract void setNameserviceId(String var1);

    public abstract void setNamenodeId(String var1);

    public abstract void setWebAddress(String var1);

    public abstract void setRpcAddress(String var1);

    public abstract void setServiceAddress(String var1);

    public abstract void setLifelineAddress(String var1);

    public abstract void setIsSafeMode(boolean var1);

    public abstract void setClusterId(String var1);

    public abstract void setBlockPoolId(String var1);

    public abstract void setState(FederationNamenodeServiceState var1);

    public abstract void setWebScheme(String var1);

    @Override
    public abstract String getNameserviceId();

    @Override
    public abstract String getNamenodeId();

    public abstract String getClusterId();

    public abstract String getBlockPoolId();

    @Override
    public abstract String getRpcAddress();

    @Override
    public abstract String getServiceAddress();

    @Override
    public abstract String getLifelineAddress();

    @Override
    public abstract String getWebAddress();

    public abstract boolean getIsSafeMode();

    @Override
    public abstract String getWebScheme();

    @Override
    public abstract FederationNamenodeServiceState getState();

    public abstract void setStats(MembershipStats var1);

    public abstract MembershipStats getStats();

    public abstract void setLastContact(long var1);

    public abstract long getLastContact();

    @Override
    public boolean like(BaseRecord o) {
        if (o instanceof MembershipState) {
            MembershipState other = (MembershipState)o;
            if (this.getRouterId() != null && !this.getRouterId().equals(other.getRouterId())) {
                return false;
            }
            if (this.getNameserviceId() != null && !this.getNameserviceId().equals(other.getNameserviceId())) {
                return false;
            }
            if (this.getNamenodeId() != null && !this.getNamenodeId().equals(other.getNamenodeId())) {
                return false;
            }
            if (this.getRpcAddress() != null && !this.getRpcAddress().equals(other.getRpcAddress())) {
                return false;
            }
            if (this.getClusterId() != null && !this.getClusterId().equals(other.getClusterId())) {
                return false;
            }
            if (this.getBlockPoolId() != null && !this.getBlockPoolId().equals(other.getBlockPoolId())) {
                return false;
            }
            return this.getState() == null || this.getState().equals((Object)other.getState());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getRouterId() + "->" + this.getNameserviceId() + ":" + this.getNamenodeId() + ":" + this.getRpcAddress() + "-" + (Object)((Object)this.getState());
    }

    public SortedMap<String, String> getPrimaryKeys() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("routerId", this.getRouterId());
        map.put("nameserviceId", this.getNameserviceId());
        map.put("namenodeId", this.getNamenodeId());
        return map;
    }

    public boolean isAvailable() {
        return this.getState() == FederationNamenodeServiceState.ACTIVE;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getNameserviceId() == null || this.getNameserviceId().length() == 0) {
            throw new IllegalArgumentException(ERROR_MSG_NO_NS_SPECIFIED + this);
        }
        if (this.getWebAddress() == null || this.getWebAddress().length() == 0) {
            throw new IllegalArgumentException(ERROR_MSG_NO_WEB_ADDR_SPECIFIED + this);
        }
        if (this.getRpcAddress() == null || this.getRpcAddress().length() == 0) {
            throw new IllegalArgumentException(ERROR_MSG_NO_RPC_ADDR_SPECIFIED + this);
        }
        if (!this.isBadState() && (this.getBlockPoolId().isEmpty() || this.getBlockPoolId().length() == 0)) {
            throw new IllegalArgumentException(ERROR_MSG_NO_BP_SPECIFIED + this);
        }
    }

    public void overrideState(FederationNamenodeServiceState newState) {
        this.setState(newState);
    }

    public int compareNameTo(MembershipState other) {
        int ret = this.getNameserviceId().compareTo(other.getNameserviceId());
        if (ret == 0) {
            ret = this.getNamenodeId().compareTo(other.getNamenodeId());
        }
        if (ret == 0) {
            ret = this.getRouterId().compareTo(other.getRouterId());
        }
        return ret;
    }

    @Override
    public String getNamenodeKey() {
        return MembershipState.getNamenodeKey(this.getNameserviceId(), this.getNamenodeId());
    }

    public static String getNamenodeKey(String nsId, String nnId) {
        return nsId + "-" + nnId;
    }

    private boolean isBadState() {
        return this.getState() == FederationNamenodeServiceState.EXPIRED || this.getState() == FederationNamenodeServiceState.UNAVAILABLE;
    }

    @Override
    public boolean checkExpired(long currentTime) {
        if (super.checkExpired(currentTime)) {
            this.setState(FederationNamenodeServiceState.EXPIRED);
            return true;
        }
        return false;
    }

    @Override
    public long getExpirationMs() {
        return expirationMs;
    }

    public static void setExpirationMs(long time) {
        expirationMs = time;
    }

    @Override
    public boolean isExpired() {
        return this.getState() == FederationNamenodeServiceState.EXPIRED;
    }

    @Override
    public long getDeletionMs() {
        return deletionMs;
    }

    public static void setDeletionMs(long time) {
        deletionMs = time;
    }

    static {
        NAME_COMPARATOR = new Comparator<MembershipState>(){

            @Override
            public int compare(MembershipState m1, MembershipState m2) {
                return m1.compareNameTo(m2);
            }
        };
    }
}

