/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.tools.CopyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexCopyFilter
extends CopyFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RegexCopyFilter.class);
    private File filtersFile;
    private List<Pattern> filters;

    protected RegexCopyFilter(String filtersFilename) {
        this.filtersFile = new File(filtersFilename);
        this.filters = new ArrayList<Pattern>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void initialize() {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = Files.newInputStream(this.filtersFile.toPath(), new OpenOption[0]);
            reader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                Pattern pattern = Pattern.compile(line);
                this.filters.add(pattern);
            }
        }
        catch (FileNotFoundException notFound) {
            LOG.error("Can't find filters file " + this.filtersFile);
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{reader});
        }
        catch (IOException cantRead) {
            LOG.error("An error occurred while attempting to read from " + this.filtersFile);
            {
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{reader});
                    throw throwable;
                }
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{reader});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{reader});
    }

    @VisibleForTesting
    protected final void setFilters(List<Pattern> filtersList) {
        this.filters = filtersList;
    }

    @Override
    public boolean shouldCopy(Path path) {
        for (Pattern filter : this.filters) {
            if (!filter.matcher(path.toString()).matches()) continue;
            return false;
        }
        return true;
    }
}

