/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.type.TypeUtils;

public class ColourData {
    public static final ColourData BLACK = new ColourData(0, 0, 0);
    public static final ColourData WHITE = new ColourData(255, 255, 255);
    private static final int LIMIT = 256;
    private final int myValue;

    public static ColourData random() {
        int tmpR = (int)PrimitiveFunction.FLOOR.invoke(256.0 * Math.random());
        int tmpG = (int)PrimitiveFunction.FLOOR.invoke(256.0 * Math.random());
        int tmpB = (int)PrimitiveFunction.FLOOR.invoke(256.0 * Math.random());
        return new ColourData(tmpR, tmpG, tmpB);
    }

    public static ColourData valueOf(String colourAsHexString) {
        int i = Integer.decode(colourAsHexString);
        return new ColourData(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF);
    }

    public ColourData(float r, float g, float b) {
        this((int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f));
    }

    public ColourData(float r, float g, float b, float a) {
        this((int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f), (int)(a * 255.0f + 0.5f));
    }

    public ColourData(int rgb) {
        this.myValue = 0xFF000000 | rgb;
    }

    public ColourData(int rgba, boolean alpha) {
        this.myValue = alpha ? rgba : 0xFF000000 | rgba;
    }

    public ColourData(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public ColourData(int r, int g, int b, int a) {
        this.myValue = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public int getAlpha() {
        return this.myValue >> 24 & 0xFF;
    }

    public int getBlue() {
        return this.myValue >> 0 & 0xFF;
    }

    public int getGreen() {
        return this.myValue >> 8 & 0xFF;
    }

    public int getRed() {
        return this.myValue >> 16 & 0xFF;
    }

    public int getRGB() {
        return this.myValue;
    }

    public String toHexString() {
        return TypeUtils.toHexString(this.myValue);
    }
}

