/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.http.resource.JerseyResource;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mortbay.jetty.Connector;
import org.mortbay.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHttpServer
extends HttpServerFunctionalTest {
    static final Logger LOG = LoggerFactory.getLogger(TestHttpServer.class);
    private static HttpServer2 server;
    private static final int MAX_THREADS = 10;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void setup() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hadoop.http.max.threads", 10);
        server = TestHttpServer.createTestServer(conf);
        server.addServlet("echo", "/echo", EchoServlet.class);
        server.addServlet("echomap", "/echomap", EchoMapServlet.class);
        server.addServlet("htmlcontent", "/htmlcontent", HtmlContentServlet.class);
        server.addServlet("longheader", "/longheader", HttpServerFunctionalTest.LongHeaderServlet.class);
        server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        server.start();
        baseUrl = TestHttpServer.getServerURL(server);
        LOG.info("HTTP server started: " + baseUrl);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
    }

    @Test
    public void testMaxThreads() throws Exception {
        int clientThreads = 100;
        ExecutorService executor = Executors.newFixedThreadPool(clientThreads);
        final CountDownLatch ready = new CountDownLatch(clientThreads);
        final CountDownLatch start = new CountDownLatch(1);
        for (int i = 0; i < clientThreads; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ready.countDown();
                    try {
                        start.await();
                        Assert.assertEquals((Object)"a:b\nc:d\n", (Object)HttpServerFunctionalTest.readOutput(new URL(HttpServerFunctionalTest.baseUrl, "/echo?a=b&c=d")));
                        int serverThreads = server.webServer.getThreadPool().getThreads();
                        Assert.assertTrue((String)("More threads are started than expected, Server Threads count: " + serverThreads), (serverThreads <= 10 ? 1 : 0) != 0);
                        System.out.println("Number of threads = " + serverThreads + " which is less or equal than the max = " + 10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        ready.await();
        start.countDown();
    }

    @Test
    public void testEcho() throws Exception {
        TestHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echo?a=b&c=d")));
        TestHttpServer.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    @Test
    public void testEchoMap() throws Exception {
        TestHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echomap?a=b&c=d")));
        TestHttpServer.assertEquals((Object)"a:b,&gt;\nc&lt;:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echomap?a=b&c<=d&a=>")));
    }

    @Test
    public void testLongHeader() throws Exception {
        URL url = new URL(baseUrl, "/longheader");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        this.testLongHeader(conn);
    }

    @Test
    public void testContentTypes() throws Exception {
        URL cssUrl = new URL(baseUrl, "/static/test.css");
        HttpURLConnection conn = (HttpURLConnection)cssUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/css", (Object)conn.getContentType());
        URL servletUrl = new URL(baseUrl, "/echo?a=b");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/plain; charset=utf-8", (Object)conn.getContentType());
        servletUrl = new URL(baseUrl, "/echo?a=b.css");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/plain; charset=utf-8", (Object)conn.getContentType());
        servletUrl = new URL(baseUrl, "/htmlcontent");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/html; charset=utf-8", (Object)conn.getContentType());
    }

    @Test
    public void testHttpResonseContainsXFrameOptions() throws Exception {
        this.validateXFrameOption(HttpServer2.XFrameOption.SAMEORIGIN);
    }

    @Test
    public void testHttpResonseContainsDeny() throws Exception {
        this.validateXFrameOption(HttpServer2.XFrameOption.DENY);
    }

    @Test
    public void testHttpResonseContainsAllowFrom() throws Exception {
        this.validateXFrameOption(HttpServer2.XFrameOption.ALLOWFROM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateXFrameOption(HttpServer2.XFrameOption option) throws Exception {
        Configuration conf = new Configuration();
        boolean xFrameEnabled = true;
        HttpServer2 httpServer = TestHttpServer.createServer(xFrameEnabled, option.toString(), conf);
        try {
            HttpURLConnection conn = this.getHttpURLConnection(httpServer);
            String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
            TestHttpServer.assertTrue((String)"X-FRAME-OPTIONS is absent in the header", (xfoHeader != null ? 1 : 0) != 0);
            TestHttpServer.assertTrue((boolean)xfoHeader.endsWith(option.toString()));
        }
        finally {
            httpServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpResonseDoesNotContainXFrameOptions() throws Exception {
        Configuration conf = new Configuration();
        boolean xFrameEnabled = false;
        HttpServer2 httpServer = TestHttpServer.createServer(xFrameEnabled, HttpServer2.XFrameOption.SAMEORIGIN.toString(), conf);
        try {
            HttpURLConnection conn = this.getHttpURLConnection(httpServer);
            String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
            TestHttpServer.assertTrue((String)"Unexpected X-FRAME-OPTIONS in header", (xfoHeader == null ? 1 : 0) != 0);
        }
        finally {
            httpServer.stop();
        }
    }

    private HttpURLConnection getHttpURLConnection(HttpServer2 httpServer) throws IOException {
        httpServer.start();
        URL newURL = TestHttpServer.getServerURL(httpServer);
        URL url = new URL(newURL, "");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        return conn;
    }

    @Test
    public void testHttpResonseInvalidValueType() throws Exception {
        Configuration conf = new Configuration();
        boolean xFrameEnabled = true;
        this.exception.expect(IllegalArgumentException.class);
        TestHttpServer.createServer(xFrameEnabled, "Hadoop", conf);
    }

    static int getHttpStatusCode(String urlstring, String userName) throws IOException {
        URL url = new URL(urlstring + "?user.name=" + userName);
        System.out.println("Accessing " + url + " as user " + userName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        return connection.getResponseCode();
    }

    @Test
    public void testDisabledAuthorizationOfDefaultServlets() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.clearMapping();
        MyGroupsProvider.mapping.put("userA", Arrays.asList("groupA"));
        MyGroupsProvider.mapping.put("userB", Arrays.asList("groupB"));
        HttpServer2 myServer = new HttpServer2.Builder().setName("test").addEndpoint(new URI("http://localhost:0")).setFindPort(true).build();
        myServer.setAttribute("hadoop.conf", (Object)conf);
        myServer.start();
        String serverURL = "http://" + NetUtils.getHostPortString((InetSocketAddress)myServer.getConnectorAddress(0)) + "/";
        for (String servlet : new String[]{"conf", "logs", "stacks", "logLevel", "metrics"}) {
            for (String user : new String[]{"userA", "userB"}) {
                TestHttpServer.assertEquals((long)200L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, user));
            }
        }
        myServer.stop();
    }

    @Test
    public void testAuthorizationOfDefaultServlets() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", true);
        conf.setBoolean("hadoop.security.instrumentation.requires.admin", true);
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.clearMapping();
        MyGroupsProvider.mapping.put("userA", Arrays.asList("groupA"));
        MyGroupsProvider.mapping.put("userB", Arrays.asList("groupB"));
        MyGroupsProvider.mapping.put("userC", Arrays.asList("groupC"));
        MyGroupsProvider.mapping.put("userD", Arrays.asList("groupD"));
        MyGroupsProvider.mapping.put("userE", Arrays.asList("groupE"));
        HttpServer2 myServer = new HttpServer2.Builder().setName("test").addEndpoint(new URI("http://localhost:0")).setFindPort(true).setConf(conf).setACL(new AccessControlList("userA,userB groupC,groupD")).build();
        myServer.setAttribute("hadoop.conf", (Object)conf);
        myServer.start();
        String serverURL = "http://" + NetUtils.getHostPortString((InetSocketAddress)myServer.getConnectorAddress(0)) + "/";
        for (String servlet : new String[]{"conf", "logs", "stacks", "logLevel", "metrics"}) {
            for (String user : new String[]{"userA", "userB", "userC", "userD"}) {
                TestHttpServer.assertEquals((long)200L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, user));
            }
            TestHttpServer.assertEquals((long)403L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, "userE"));
        }
        myServer.stop();
    }

    @Test
    public void testRequestQuoterWithNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)request)).getParameterValues("dummy");
        HttpServer2.QuotingInputFilter.RequestQuoter requestQuoter = new HttpServer2.QuotingInputFilter.RequestQuoter(request);
        String[] parameterValues = requestQuoter.getParameterValues("dummy");
        Assert.assertNull((String)"It should return null when there are no values for the parameter", (Object)parameterValues);
    }

    @Test
    public void testRequestQuoterWithNotNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Object[] values = new String[]{"abc", "def"};
        ((HttpServletRequest)Mockito.doReturn((Object)values).when((Object)request)).getParameterValues("dummy");
        HttpServer2.QuotingInputFilter.RequestQuoter requestQuoter = new HttpServer2.QuotingInputFilter.RequestQuoter(request);
        Object[] parameterValues = requestQuoter.getParameterValues("dummy");
        Assert.assertTrue((String)"It should return Parameter Values", (boolean)Arrays.equals(values, parameterValues));
    }

    private static Map<String, Object> parse(String jsonString) {
        return (Map)JSON.parse((String)jsonString);
    }

    @Test
    public void testJersey() throws Exception {
        LOG.info("BEGIN testJersey()");
        String js = TestHttpServer.readOutput(new URL(baseUrl, "/jersey/foo?op=bar"));
        Map<String, Object> m = TestHttpServer.parse(js);
        LOG.info("m=" + m);
        TestHttpServer.assertEquals((Object)"foo", (Object)m.get("path"));
        TestHttpServer.assertEquals((Object)"bar", (Object)m.get("op"));
        LOG.info("END testJersey()");
    }

    @Test
    public void testHasAdministratorAccess() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", false);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("hadoop.conf")).thenReturn((Object)conf);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn(null);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn(null);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Assert.assertTrue((boolean)HttpServer2.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        conf.setBoolean("hadoop.security.authorization", true);
        Assert.assertFalse((boolean)HttpServer2.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)403), Mockito.anyString());
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)"foo");
        Assert.assertTrue((boolean)HttpServer2.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        AccessControlList acls = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        Assert.assertFalse((boolean)HttpServer2.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)403), Mockito.anyString());
        response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        Assert.assertTrue((boolean)HttpServer2.hasAdministratorAccess((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
    }

    @Test
    public void testRequiresAuthorizationAccess() throws Exception {
        Configuration conf = new Configuration();
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("hadoop.conf")).thenReturn((Object)conf);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Assert.assertTrue((boolean)HttpServer2.isInstrumentationAccessAllowed((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
        conf.setBoolean("hadoop.security.instrumentation.requires.admin", true);
        conf.setBoolean("hadoop.security.authorization", true);
        AccessControlList acls = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)false);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        Assert.assertFalse((boolean)HttpServer2.isInstrumentationAccessAllowed((ServletContext)context, (HttpServletRequest)request, (HttpServletResponse)response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindAddress() throws Exception {
        this.checkBindAddress("localhost", 0, false).stop();
        HttpServer2 myServer = this.checkBindAddress("localhost", 0, false);
        HttpServer2 myServer2 = null;
        try {
            int port = myServer.getConnectorAddress(0).getPort();
            myServer2 = this.checkBindAddress("localhost", port, true);
            port = myServer2.getConnectorAddress(0).getPort();
            myServer2.stop();
            TestHttpServer.assertNull((Object)myServer2.getConnectorAddress(0));
            myServer2.openListeners();
            TestHttpServer.assertEquals((long)port, (long)myServer2.getConnectorAddress(0).getPort());
        }
        finally {
            myServer.stop();
            if (myServer2 != null) {
                myServer2.stop();
            }
        }
    }

    private HttpServer2 checkBindAddress(String host, int port, boolean findPort) throws Exception {
        HttpServer2 server = TestHttpServer.createServer(host, port);
        try {
            List listeners = (List)Whitebox.getInternalState((Object)server, (String)"listeners");
            Connector listener = (Connector)listeners.get(0);
            TestHttpServer.assertEquals((long)port, (long)listener.getPort());
            server.openListeners();
            TestHttpServer.assertEquals((Object)host, (Object)server.getConnectorAddress(0).getHostName());
            int boundPort = server.getConnectorAddress(0).getPort();
            if (port == 0) {
                TestHttpServer.assertTrue((boundPort != 0 ? 1 : 0) != 0);
            } else if (findPort) {
                TestHttpServer.assertTrue((boundPort > port ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            server.stop();
            throw e;
        }
        return server;
    }

    @Test
    public void testNoCacheHeader() throws Exception {
        URL url = new URL(baseUrl, "/echo?a=b&c=d");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"no-cache", (Object)conn.getHeaderField("Cache-Control"));
        TestHttpServer.assertEquals((Object)"no-cache", (Object)conn.getHeaderField("Pragma"));
        TestHttpServer.assertNotNull((Object)conn.getHeaderField("Expires"));
        TestHttpServer.assertNotNull((Object)conn.getHeaderField("Date"));
        TestHttpServer.assertEquals((Object)conn.getHeaderField("Expires"), (Object)conn.getHeaderField("Date"));
    }

    private static void stopHttpServer(HttpServer2 server) throws Exception {
        if (server != null) {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPortRanges() throws Exception {
        Configuration conf = new Configuration();
        int port = ServerSocketUtil.waitForPort(49000, 60);
        int endPort = 49500;
        conf.set("abc", "49000-49500");
        HttpServer2.Builder builder = new HttpServer2.Builder().setName("test").setConf(new Configuration()).setFindPort(false);
        Configuration.IntegerRanges ranges = conf.getRange("abc", "");
        int startPort = 0;
        if (ranges != null && !ranges.isEmpty()) {
            startPort = ranges.getRangeStart();
            builder.setPortRanges(ranges);
        }
        builder.addEndpoint(URI.create("http://localhost:" + startPort));
        HttpServer2 myServer = builder.build();
        HttpServer2 myServer2 = null;
        try {
            myServer.start();
            TestHttpServer.assertEquals((long)port, (long)myServer.getConnectorAddress(0).getPort());
            myServer2 = builder.build();
            myServer2.start();
            TestHttpServer.assertTrue((myServer2.getConnectorAddress(0).getPort() > port && myServer2.getConnectorAddress(0).getPort() <= endPort ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            TestHttpServer.stopHttpServer(myServer);
            TestHttpServer.stopHttpServer(myServer2);
            throw throwable;
        }
        TestHttpServer.stopHttpServer(myServer);
        TestHttpServer.stopHttpServer(myServer2);
    }

    public static class MyGroupsProvider
    extends ShellBasedUnixGroupsMapping {
        static Map<String, List<String>> mapping = new HashMap<String, List<String>>();

        static void clearMapping() {
            mapping.clear();
        }

        public List<String> getGroups(String user) throws IOException {
            return mapping.get(user);
        }
    }

    public static class DummyFilterInitializer
    extends FilterInitializer {
        public void initFilter(FilterContainer container, Configuration conf) {
            container.addFilter("DummyFilter", DummyServletFilter.class.getName(), null);
        }
    }

    public static class DummyServletFilter
    implements Filter {
        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
            final String userName = request.getParameter("user.name");
            HttpServletRequestWrapper requestModified = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getRemoteUser() {
                    return userName;
                }
            };
            filterChain.doFilter((ServletRequest)requestModified, response);
        }

        public void init(FilterConfig arg0) throws ServletException {
        }
    }

    public static class HtmlContentServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.print("hello world");
            out.close();
        }
    }

    public static class EchoServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            TreeSet sortedKeys = new TreeSet();
            Enumeration keys = request.getParameterNames();
            while (keys.hasMoreElements()) {
                sortedKeys.add(keys.nextElement());
            }
            for (String key : sortedKeys) {
                out.print(key);
                out.print(':');
                out.print(request.getParameter(key));
                out.print('\n');
            }
            out.close();
        }
    }

    public static class EchoMapServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            Map params = request.getParameterMap();
            TreeSet keys = new TreeSet(params.keySet());
            for (String key : keys) {
                out.print(key);
                out.print(':');
                String[] values = (String[])params.get(key);
                if (values.length > 0) {
                    out.print(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        out.print(',');
                        out.print(values[i]);
                    }
                }
                out.print('\n');
            }
            out.close();
        }
    }
}

