/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.joni.Analyser;
import org.apache.hadoop.hbase.shaded.org.joni.BitStatus;
import org.apache.hadoop.hbase.shaded.org.joni.CodeRangeBuffer;
import org.apache.hadoop.hbase.shaded.org.joni.Compiler;
import org.apache.hadoop.hbase.shaded.org.joni.MatcherFactory;
import org.apache.hadoop.hbase.shaded.org.joni.Option;
import org.apache.hadoop.hbase.shaded.org.joni.ast.AnchorNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.BackRefNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CClassNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CTypeNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.CallNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.EncloseNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.ListNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.Node;
import org.apache.hadoop.hbase.shaded.org.joni.ast.QuantifierNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.StringNode;

final class ArrayCompiler
extends Compiler {
    private int[] code;
    private int codeLength;
    private byte[][] templates;
    private int templateNum;
    private static final int REPEAT_RANGE_ALLOC = 8;
    private static final int QUANTIFIER_EXPAND_LIMIT_SIZE = 50;

    ArrayCompiler(Analyser analyser) {
        super(analyser);
    }

    @Override
    protected final void prepare() {
        int codeSize = 8;
        this.code = new int[codeSize];
        this.codeLength = 0;
    }

    @Override
    protected final void finish() {
        this.addOpcode(1);
        this.addOpcode(0);
        this.regex.code = this.code;
        this.regex.codeLength = this.codeLength;
        this.regex.templates = this.templates;
        this.regex.templateNum = this.templateNum;
        this.regex.factory = MatcherFactory.DEFAULT;
        if (this.analyser.env.unsetAddrList != null) {
            this.analyser.env.unsetAddrList.fix(this.regex);
            this.analyser.env.unsetAddrList = null;
        }
    }

    @Override
    protected void compileAltNode(ListNode node) {
        ListNode aln = node;
        int len = 0;
        do {
            len += this.compileLengthTree(aln.value);
            if (aln.tail == null) continue;
            len += 4;
        } while ((aln = aln.tail) != null);
        int pos = this.codeLength + len;
        aln = node;
        do {
            len = this.compileLengthTree(aln.value);
            if (aln.tail != null) {
                this.regex.requireStack = true;
                this.addOpcodeRelAddr(62, len + 2);
            }
            this.compileTree(aln.value);
            if (aln.tail == null) continue;
            len = pos - (this.codeLength + 2);
            this.addOpcodeRelAddr(61, len);
        } while ((aln = aln.tail) != null);
    }

    private boolean isNeedStrLenOpExact(int op) {
        return op == 7 || op == 11 || op == 12 || op == 13 || op == 15 || op == 99;
    }

    private boolean opTemplated(int op) {
        return this.isNeedStrLenOpExact(op);
    }

    private int selectStrOpcode(int mbLength, int byteLength, boolean ignoreCase) {
        int op;
        int strLength = (byteLength + mbLength - 1) / mbLength;
        if (ignoreCase) {
            switch (strLength) {
                case 1: {
                    op = this.enc.toLowerCaseTable() != null ? 98 : 14;
                    break;
                }
                default: {
                    op = this.enc.toLowerCaseTable() != null ? 99 : 15;
                    break;
                }
            }
        } else {
            block3 : switch (mbLength) {
                case 1: {
                    switch (strLength) {
                        case 1: {
                            op = 2;
                            break block3;
                        }
                        case 2: {
                            op = 3;
                            break block3;
                        }
                        case 3: {
                            op = 4;
                            break block3;
                        }
                        case 4: {
                            op = 5;
                            break block3;
                        }
                        case 5: {
                            op = 6;
                            break block3;
                        }
                    }
                    op = 7;
                    break;
                }
                case 2: {
                    switch (strLength) {
                        case 1: {
                            op = 8;
                            break block3;
                        }
                        case 2: {
                            op = 9;
                            break block3;
                        }
                        case 3: {
                            op = 10;
                            break block3;
                        }
                    }
                    op = 11;
                    break;
                }
                case 3: {
                    op = 12;
                    break;
                }
                default: {
                    op = 13;
                }
            }
        }
        return op;
    }

    private void compileTreeEmptyCheck(Node node, int emptyInfo) {
        int savedNumNullCheck = this.regex.numNullCheck;
        if (emptyInfo != 0) {
            this.regex.requireStack = true;
            this.addOpcode(72);
            this.addMemNum(this.regex.numNullCheck);
            ++this.regex.numNullCheck;
        }
        this.compileTree(node);
        if (emptyInfo != 0) {
            switch (emptyInfo) {
                case 1: {
                    this.addOpcode(73);
                    break;
                }
                case 2: {
                    this.addOpcode(74);
                    break;
                }
                case 3: {
                    this.addOpcode(75);
                }
            }
            this.addMemNum(savedNumNullCheck);
        }
    }

    private int addCompileStringlength(byte[] bytes, int p, int mbLength, int byteLength, boolean ignoreCase) {
        int op = this.selectStrOpcode(mbLength, byteLength, ignoreCase);
        int len = 1;
        if (this.opTemplated(op)) {
            len += 3;
        } else {
            if (this.isNeedStrLenOpExact(op)) {
                ++len;
            }
            len += byteLength;
        }
        if (op == 13) {
            ++len;
        }
        return len;
    }

    @Override
    protected final void addCompileString(byte[] bytes, int p, int mbLength, int byteLength, boolean ignoreCase) {
        int op = this.selectStrOpcode(mbLength, byteLength, ignoreCase);
        this.addOpcode(op);
        if (op == 13) {
            this.addLength(mbLength);
        }
        if (this.isNeedStrLenOpExact(op)) {
            if (op == 15 || op == 99) {
                this.addLength(byteLength);
            } else {
                this.addLength(byteLength / mbLength);
            }
        }
        if (this.opTemplated(op)) {
            this.addInt(this.templateNum);
            this.addInt(p);
            this.addTemplate(bytes);
        } else {
            this.addBytes(bytes, p, byteLength);
        }
    }

    private int compileLengthStringNode(Node node) {
        int prev;
        StringNode sn = (StringNode)node;
        if (sn.length() <= 0) {
            return 0;
        }
        boolean ambig = sn.isAmbig();
        int p = prev = sn.p;
        int end = sn.end;
        byte[] bytes = sn.bytes;
        int prevLen = this.enc.length(bytes, p, end);
        p += prevLen;
        int blen = prevLen;
        int rlen = 0;
        while (p < end) {
            int len = this.enc.length(bytes, p, end);
            if (len == prevLen || ambig) {
                blen += len;
            } else {
                int r = this.addCompileStringlength(bytes, prev, prevLen, blen, ambig);
                rlen += r;
                prev = p;
                blen = len;
                prevLen = len;
            }
            p += len;
        }
        int r = this.addCompileStringlength(bytes, prev, prevLen, blen, ambig);
        return rlen += r;
    }

    private int compileLengthStringRawNode(StringNode sn) {
        if (sn.length() <= 0) {
            return 0;
        }
        return this.addCompileStringlength(sn.bytes, sn.p, 1, sn.length(), false);
    }

    private void addMultiByteCClass(CodeRangeBuffer mbuf) {
        this.addLength(mbuf.getUsed());
        this.addInts(mbuf.getCodeRange(), mbuf.getUsed());
    }

    private int compileLengthCClassNode(CClassNode cc) {
        int len;
        if (cc.mbuf == null) {
            len = 9;
        } else {
            len = this.enc.minLength() > 1 || cc.bs.isEmpty() ? 1 : 9;
            len += 1 + cc.mbuf.getUsed();
        }
        return len;
    }

    @Override
    protected void compileCClassNode(CClassNode cc) {
        if (cc.mbuf == null) {
            if (cc.isNot()) {
                this.addOpcode(19);
            } else {
                this.addOpcode(16);
            }
            this.addInts(cc.bs.bits, 8);
        } else if (this.enc.minLength() > 1 || cc.bs.isEmpty()) {
            if (cc.isNot()) {
                this.addOpcode(20);
            } else {
                this.addOpcode(17);
            }
            this.addMultiByteCClass(cc.mbuf);
        } else {
            if (cc.isNot()) {
                this.addOpcode(21);
            } else {
                this.addOpcode(18);
            }
            this.addInts(cc.bs.bits, 8);
            this.addMultiByteCClass(cc.mbuf);
        }
    }

    @Override
    protected void compileCTypeNode(CTypeNode node) {
        int op;
        CTypeNode cn = node;
        switch (cn.ctype) {
            case 12: {
                if (cn.not) {
                    if (cn.asciiRange) {
                        op = 35;
                        break;
                    }
                    op = 29;
                    break;
                }
                if (cn.asciiRange) {
                    op = 34;
                    break;
                }
                op = 28;
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
                return;
            }
        }
        this.addOpcode(op);
    }

    @Override
    protected void compileAnyCharNode() {
        if (Option.isMultiline(this.regex.options)) {
            this.addOpcode(23);
        } else {
            this.addOpcode(22);
        }
    }

    @Override
    protected void compileCallNode(CallNode node) {
        this.addOpcode(88);
        node.unsetAddrList.add(this.codeLength, node.target);
        this.addAbsAddr(0);
    }

    @Override
    protected void compileBackrefNode(BackRefNode node) {
        BackRefNode br = node;
        if (br.isNestLevel()) {
            this.addOpcode(52);
            this.addOption(this.regex.options & 1);
            this.addLength(br.nestLevel);
            this.addLength(br.backNum);
            for (int i = br.backNum - 1; i >= 0; --i) {
                this.addMemNum(br.back[i]);
            }
            return;
        }
        if (br.backNum == 1) {
            if (Option.isIgnoreCase(this.regex.options)) {
                this.addOpcode(49);
                this.addMemNum(br.back[0]);
            } else {
                switch (br.back[0]) {
                    case 1: {
                        this.addOpcode(46);
                        break;
                    }
                    case 2: {
                        this.addOpcode(47);
                        break;
                    }
                    default: {
                        this.addOpcode(48);
                        this.addOpcode(br.back[0]);
                        break;
                    }
                }
            }
        } else {
            if (Option.isIgnoreCase(this.regex.options)) {
                this.addOpcode(51);
            } else {
                this.addOpcode(50);
            }
            this.addLength(br.backNum);
            for (int i = br.backNum - 1; i >= 0; --i) {
                this.addMemNum(br.back[i]);
            }
        }
    }

    private void entryRepeatRange(int id, int lower, int upper) {
        if (this.regex.repeatRangeLo == null) {
            this.regex.repeatRangeLo = new int[8];
            this.regex.repeatRangeHi = new int[8];
        } else if (id >= this.regex.repeatRangeLo.length) {
            int[] tmp = new int[this.regex.repeatRangeLo.length + 8];
            System.arraycopy(this.regex.repeatRangeLo, 0, tmp, 0, this.regex.repeatRangeLo.length);
            this.regex.repeatRangeLo = tmp;
            tmp = new int[this.regex.repeatRangeHi.length + 8];
            System.arraycopy(this.regex.repeatRangeHi, 0, tmp, 0, this.regex.repeatRangeHi.length);
            this.regex.repeatRangeHi = tmp;
        }
        this.regex.repeatRangeLo[id] = lower;
        this.regex.repeatRangeHi[id] = QuantifierNode.isRepeatInfinite(upper) ? Integer.MAX_VALUE : upper;
    }

    private void compileRangeRepeatNode(QuantifierNode qn, int targetLen, int emptyInfo) {
        this.regex.requireStack = true;
        int numRepeat = this.regex.numRepeat;
        this.addOpcode(qn.greedy ? 66 : 67);
        this.addMemNum(numRepeat);
        ++this.regex.numRepeat;
        this.addRelAddr(targetLen + 2);
        this.entryRepeatRange(numRepeat, qn.lower, qn.upper);
        this.compileTreeEmptyCheck(qn.target, emptyInfo);
        if (this.regex.numCall > 0 || qn.isInRepeat()) {
            this.addOpcode(qn.greedy ? 70 : 71);
        } else {
            this.addOpcode(qn.greedy ? 68 : 69);
        }
        this.addMemNum(numRepeat);
    }

    private static boolean cknOn(int ckn) {
        return ckn > 0;
    }

    private int compileCECLengthQuantifierNode(QuantifierNode qn) {
        int len;
        int cklen;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        int ckn = this.regex.numCombExpCheck > 0 ? qn.combExpCheckNum : 0;
        int n = cklen = ArrayCompiler.cknOn(ckn) ? 1 : 0;
        if (qn.target.getType() == 3 && qn.greedy && infinite) {
            if (qn.nextHeadExact != null && !ArrayCompiler.cknOn(ckn)) {
                return 2 + tlen * qn.lower + cklen;
            }
            return 1 + tlen * qn.lower + cklen;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && qn.lower <= 1) {
            if (qn.greedy) {
                len = qn.lower == 1 ? 2 : 0;
                len += 2 + cklen + modTLen + 2;
            } else {
                len = qn.lower == 0 ? 2 : 0;
                len += modTLen + 2 + cklen;
            }
        } else if (qn.upper == 0) {
            len = qn.isRefered ? 2 + tlen : 0;
        } else if (qn.upper == 1 && qn.greedy) {
            len = qn.lower == 0 ? (ArrayCompiler.cknOn(ckn) ? 3 + tlen : 2 + tlen) : tlen;
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            len = 2 + cklen + 2 + tlen;
        } else {
            len = 2 + modTLen + 1 + 1 + 1;
            if (ArrayCompiler.cknOn(ckn)) {
                len += 2;
            }
        }
        return len;
    }

    @Override
    protected void compileCECQuantifierNode(QuantifierNode qn) {
        int ckn;
        this.regex.requireStack = true;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        int n = ckn = this.regex.numCombExpCheck > 0 ? qn.combExpCheckNum : 0;
        if (qn.isAnyCharStar()) {
            this.compileTreeNTimes(qn.target, qn.lower);
            if (qn.nextHeadExact != null && !ArrayCompiler.cknOn(ckn)) {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(27);
                } else {
                    this.addOpcode(26);
                }
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addStateCheckNum(ckn);
                }
                StringNode sn = (StringNode)qn.nextHeadExact;
                this.addBytes(sn.bytes, sn.p, 1);
                return;
            }
            if (Option.isMultiline(this.regex.options)) {
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addOpcode(95);
                } else {
                    this.addOpcode(25);
                }
            } else if (ArrayCompiler.cknOn(ckn)) {
                this.addOpcode(94);
            } else {
                this.addOpcode(24);
            }
            if (ArrayCompiler.cknOn(ckn)) {
                this.addStateCheckNum(ckn);
            }
            return;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && qn.lower <= 1) {
            if (qn.greedy) {
                if (qn.lower == 1) {
                    this.addOpcodeRelAddr(61, ArrayCompiler.cknOn(ckn) ? 3 : 2);
                }
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addOpcode(91);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(modTLen + 2);
                } else {
                    this.addOpcodeRelAddr(62, modTLen + 2);
                }
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                this.addOpcodeRelAddr(61, -(modTLen + 2 + (ArrayCompiler.cknOn(ckn) ? 3 : 2)));
            } else {
                if (qn.lower == 0) {
                    this.addOpcodeRelAddr(61, modTLen);
                }
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addOpcode(92);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(-(modTLen + 3));
                } else {
                    this.addOpcodeRelAddr(62, -(modTLen + 2));
                }
            }
        } else if (qn.upper == 0) {
            if (qn.isRefered) {
                this.addOpcodeRelAddr(61, tlen);
                this.compileTree(qn.target);
            }
        } else if (qn.upper == 1 && qn.greedy) {
            if (qn.lower == 0) {
                if (ArrayCompiler.cknOn(ckn)) {
                    this.addOpcode(91);
                    this.addStateCheckNum(ckn);
                    this.addRelAddr(tlen);
                } else {
                    this.addOpcodeRelAddr(62, tlen);
                }
            }
            this.compileTree(qn.target);
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            if (ArrayCompiler.cknOn(ckn)) {
                this.addOpcode(91);
                this.addStateCheckNum(ckn);
                this.addRelAddr(2);
            } else {
                this.addOpcodeRelAddr(62, 2);
            }
            this.addOpcodeRelAddr(61, tlen);
            this.compileTree(qn.target);
        } else {
            this.compileRangeRepeatNode(qn, modTLen, emptyInfo);
            if (ArrayCompiler.cknOn(ckn)) {
                this.addOpcode(93);
                this.addStateCheckNum(ckn);
            }
        }
    }

    private int compileNonCECLengthQuantifierNode(QuantifierNode qn) {
        int len;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        if (qn.target.getType() == 3 && qn.greedy && infinite) {
            if (qn.nextHeadExact != null) {
                return 2 + tlen * qn.lower;
            }
            return 1 + tlen * qn.lower;
        }
        int modTLen = 0;
        modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && (qn.lower <= 1 || tlen * qn.lower <= 50)) {
            len = qn.lower == 1 && tlen > 50 ? 2 : tlen * qn.lower;
            len = qn.greedy ? (qn.headExact != null ? (len += 3 + modTLen + 2) : (qn.nextHeadExact != null ? (len += 3 + modTLen + 2) : (len += 2 + modTLen + 2))) : (len += 2 + modTLen + 2);
        } else if (qn.upper == 0 && qn.isRefered) {
            len = 2 + tlen;
        } else if (!infinite && qn.greedy && (qn.upper == 1 || (tlen + 2) * qn.upper <= 50)) {
            len = tlen * qn.lower;
            len += (2 + tlen) * (qn.upper - qn.lower);
        } else {
            len = !qn.greedy && qn.upper == 1 && qn.lower == 0 ? 4 + tlen : 2 + modTLen + 1 + 1 + 1;
        }
        return len;
    }

    @Override
    protected void compileNonCECQuantifierNode(QuantifierNode qn) {
        this.regex.requireStack = true;
        boolean infinite = QuantifierNode.isRepeatInfinite(qn.upper);
        int emptyInfo = qn.targetEmptyInfo;
        int tlen = this.compileLengthTree(qn.target);
        if (qn.isAnyCharStar()) {
            this.compileTreeNTimes(qn.target, qn.lower);
            if (qn.nextHeadExact != null) {
                if (Option.isMultiline(this.regex.options)) {
                    this.addOpcode(27);
                } else {
                    this.addOpcode(26);
                }
                StringNode sn = (StringNode)qn.nextHeadExact;
                this.addBytes(sn.bytes, sn.p, 1);
                return;
            }
            if (Option.isMultiline(this.regex.options)) {
                this.addOpcode(25);
            } else {
                this.addOpcode(24);
            }
            return;
        }
        int modTLen = emptyInfo != 0 ? tlen + 4 : tlen;
        if (infinite && (qn.lower <= 1 || tlen * qn.lower <= 50)) {
            if (qn.lower == 1 && tlen > 50) {
                if (qn.greedy) {
                    if (qn.headExact != null) {
                        this.addOpcodeRelAddr(61, 3);
                    } else if (qn.nextHeadExact != null) {
                        this.addOpcodeRelAddr(61, 3);
                    } else {
                        this.addOpcodeRelAddr(61, 2);
                    }
                } else {
                    this.addOpcodeRelAddr(61, 2);
                }
            } else {
                this.compileTreeNTimes(qn.target, qn.lower);
            }
            if (qn.greedy) {
                if (qn.headExact != null) {
                    this.addOpcodeRelAddr(64, modTLen + 2);
                    StringNode sn = (StringNode)qn.headExact;
                    this.addBytes(sn.bytes, sn.p, 1);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(61, -(modTLen + 2 + 3));
                } else if (qn.nextHeadExact != null) {
                    this.addOpcodeRelAddr(65, modTLen + 2);
                    StringNode sn = (StringNode)qn.nextHeadExact;
                    this.addBytes(sn.bytes, sn.p, 1);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(61, -(modTLen + 2 + 3));
                } else {
                    this.addOpcodeRelAddr(62, modTLen + 2);
                    this.compileTreeEmptyCheck(qn.target, emptyInfo);
                    this.addOpcodeRelAddr(61, -(modTLen + 2 + 2));
                }
            } else {
                this.addOpcodeRelAddr(61, modTLen);
                this.compileTreeEmptyCheck(qn.target, emptyInfo);
                this.addOpcodeRelAddr(62, -(modTLen + 2));
            }
        } else if (qn.upper == 0 && qn.isRefered) {
            this.addOpcodeRelAddr(61, tlen);
            this.compileTree(qn.target);
        } else if (!infinite && qn.greedy && (qn.upper == 1 || (tlen + 2) * qn.upper <= 50)) {
            int n = qn.upper - qn.lower;
            this.compileTreeNTimes(qn.target, qn.lower);
            for (int i = 0; i < n; ++i) {
                this.addOpcodeRelAddr(62, (n - i) * tlen + (n - i - 1) * 2);
                this.compileTree(qn.target);
            }
        } else if (!qn.greedy && qn.upper == 1 && qn.lower == 0) {
            this.addOpcodeRelAddr(62, 2);
            this.addOpcodeRelAddr(61, tlen);
            this.compileTree(qn.target);
        } else {
            this.compileRangeRepeatNode(qn, modTLen, emptyInfo);
        }
    }

    private int compileLengthOptionNode(EncloseNode node) {
        int prev = this.regex.options;
        this.regex.options = node.option;
        int tlen = this.compileLengthTree(node.target);
        this.regex.options = prev;
        return tlen;
    }

    @Override
    protected void compileOptionNode(EncloseNode node) {
        int prev = this.regex.options;
        this.regex.options = node.option;
        this.compileTree(node.target);
        this.regex.options = prev;
    }

    private int compileLengthEncloseNode(EncloseNode node) {
        int len;
        if (node.isOption()) {
            return this.compileLengthOptionNode(node);
        }
        int tlen = node.target != null ? this.compileLengthTree(node.target) : 0;
        switch (node.type) {
            case 1: {
                if (node.isCalled()) {
                    len = 2 + tlen + 2 + 2 + 1;
                    if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                        len += node.isRecursion() ? 2 : 2;
                        break;
                    }
                    len += node.isRecursion() ? 2 : 2;
                    break;
                }
                if (node.isRecursion()) {
                    len = 2;
                    len += tlen + (BitStatus.bsAt(this.regex.btMemEnd, node.regNum) ? 2 : 2);
                    break;
                }
                len = BitStatus.bsAt(this.regex.btMemStart, node.regNum) ? 2 : 2;
                len += tlen + (BitStatus.bsAt(this.regex.btMemEnd, node.regNum) ? 2 : 2);
                break;
            }
            case 4: {
                if (node.isStopBtSimpleRepeat()) {
                    QuantifierNode qn = (QuantifierNode)node.target;
                    tlen = this.compileLengthTree(qn.target);
                    len = tlen * qn.lower + 2 + tlen + 1 + 2;
                    break;
                }
                len = 1 + tlen + 1;
                break;
            }
            case 8: {
                len = 3;
                if (node.target.getType() == 9) {
                    ListNode x = (ListNode)node.target;
                    tlen = this.compileLengthTree(x.value);
                    len += tlen + 2;
                    if (x.tail == null) {
                        this.newInternalException("internal parser error (bug)");
                    }
                    x = x.tail;
                    tlen = this.compileLengthTree(x.value);
                    len += tlen;
                    if (x.tail == null) break;
                    this.newSyntaxException("invalid conditional pattern");
                    break;
                }
                this.newInternalException("internal parser error (bug)");
                break;
            }
            case 16: {
                len = 3 + tlen + 1;
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
                return 0;
            }
        }
        return len;
    }

    @Override
    protected void compileEncloseNode(EncloseNode node) {
        switch (node.type) {
            case 1: {
                if (node.isCalled()) {
                    this.regex.requireStack = true;
                    this.addOpcode(88);
                    node.callAddr = this.codeLength + 1 + 2;
                    node.setAddrFixed();
                    this.addAbsAddr(node.callAddr);
                    int len = this.compileLengthTree(node.target);
                    len += 3;
                    len = BitStatus.bsAt(this.regex.btMemEnd, node.regNum) ? (len += node.isRecursion() ? 2 : 2) : (len += node.isRecursion() ? 2 : 2);
                    this.addOpcodeRelAddr(61, len);
                }
                if (BitStatus.bsAt(this.regex.btMemStart, node.regNum)) {
                    this.regex.requireStack = true;
                    this.addOpcode(54);
                } else {
                    this.addOpcode(53);
                }
                this.addMemNum(node.regNum);
                this.compileTree(node.target);
                if (node.isCalled()) {
                    if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                        this.addOpcode(node.isRecursion() ? 56 : 55);
                    } else {
                        this.addOpcode(node.isRecursion() ? 58 : 57);
                    }
                    this.addMemNum(node.regNum);
                    this.addOpcode(89);
                    break;
                }
                if (node.isRecursion()) {
                    if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                        this.addOpcode(56);
                    } else {
                        this.addOpcode(58);
                    }
                    this.addMemNum(node.regNum);
                    break;
                }
                if (BitStatus.bsAt(this.regex.btMemEnd, node.regNum)) {
                    this.addOpcode(55);
                } else {
                    this.addOpcode(57);
                }
                this.addMemNum(node.regNum);
                break;
            }
            case 4: {
                this.regex.requireStack = true;
                if (node.isStopBtSimpleRepeat()) {
                    QuantifierNode qn = (QuantifierNode)node.target;
                    this.compileTreeNTimes(qn.target, qn.lower);
                    int len = this.compileLengthTree(qn.target);
                    this.addOpcodeRelAddr(62, len + 1 + 2);
                    this.compileTree(qn.target);
                    this.addOpcode(63);
                    this.addOpcodeRelAddr(61, -(2 + len + 1 + 2));
                    break;
                }
                this.addOpcode(80);
                this.compileTree(node.target);
                this.addOpcode(81);
                break;
            }
            case 8: {
                this.addOpcode(90);
                this.addMemNum(node.regNum);
                if (node.target.getType() == 9) {
                    ListNode x = (ListNode)node.target;
                    int len = this.compileLengthTree(x.value);
                    if (x.tail == null) {
                        this.newInternalException("internal parser error (bug)");
                    }
                    x = x.tail;
                    int len2 = this.compileLengthTree(x.value);
                    if (x.tail != null) {
                        this.newSyntaxException("invalid conditional pattern");
                    }
                    x = (ListNode)node.target;
                    this.addRelAddr(len + 2);
                    this.compileTree(x.value);
                    this.addOpcodeRelAddr(61, len2);
                    x = x.tail;
                    this.compileTree(x.value);
                    break;
                }
                this.newInternalException("internal parser error (bug)");
                break;
            }
            case 16: {
                this.regex.requireStack = true;
                int len = this.compileLengthTree(node.target);
                this.addOpcode(85);
                this.addOpcodeRelAddr(86, len + 1);
                this.compileTree(node.target);
                this.addOpcode(87);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    private int compileLengthAnchorNode(AnchorNode node) {
        int len;
        int tlen = node.target != null ? this.compileLengthTree(node.target) : 0;
        switch (node.type) {
            case 1024: {
                len = 1 + tlen + 1;
                break;
            }
            case 2048: {
                len = 2 + tlen + 1;
                break;
            }
            case 4096: {
                len = 2 + tlen;
                break;
            }
            case 8192: {
                len = 3 + tlen + 1;
                break;
            }
            default: {
                len = 1;
            }
        }
        return len;
    }

    @Override
    protected void compileAnchorNode(AnchorNode node) {
        switch (node.type) {
            case 1: {
                this.addOpcode(40);
                break;
            }
            case 8: {
                this.addOpcode(41);
                break;
            }
            case 2: {
                this.addOpcode(42);
                break;
            }
            case 32: {
                this.addOpcode(43);
                break;
            }
            case 16: {
                this.addOpcode(44);
                break;
            }
            case 4: {
                this.addOpcode(45);
                break;
            }
            case 64: {
                if (node.asciiRange) {
                    this.addOpcode(36);
                    break;
                }
                this.addOpcode(30);
                break;
            }
            case 128: {
                if (node.asciiRange) {
                    this.addOpcode(37);
                    break;
                }
                this.addOpcode(31);
                break;
            }
            case 256: {
                if (node.asciiRange) {
                    this.addOpcode(38);
                    break;
                }
                this.addOpcode(32);
                break;
            }
            case 512: {
                if (node.asciiRange) {
                    this.addOpcode(39);
                    break;
                }
                this.addOpcode(33);
                break;
            }
            case 65536: {
                this.addOpcode(59);
                break;
            }
            case 1024: {
                this.regex.requireStack = true;
                this.addOpcode(76);
                this.compileTree(node.target);
                this.addOpcode(77);
                break;
            }
            case 2048: {
                this.regex.requireStack = true;
                int len = this.compileLengthTree(node.target);
                this.addOpcodeRelAddr(78, len + 1);
                this.compileTree(node.target);
                this.addOpcode(79);
                break;
            }
            case 4096: {
                int n;
                this.addOpcode(82);
                if (node.charLength < 0) {
                    n = this.analyser.getCharLengthTree(node.target);
                    if (this.analyser.returnCode != 0) {
                        this.newSyntaxException("invalid pattern in look-behind");
                    }
                } else {
                    n = node.charLength;
                }
                this.addLength(n);
                this.compileTree(node.target);
                break;
            }
            case 8192: {
                int n;
                this.regex.requireStack = true;
                int len = this.compileLengthTree(node.target);
                this.addOpcodeRelAddr(83, len + 1);
                if (node.charLength < 0) {
                    n = this.analyser.getCharLengthTree(node.target);
                    if (this.analyser.returnCode != 0) {
                        this.newSyntaxException("invalid pattern in look-behind");
                    }
                } else {
                    n = node.charLength;
                }
                this.addLength(n);
                this.compileTree(node.target);
                this.addOpcode(84);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    private int compileLengthTree(Node node) {
        int len = 0;
        switch (node.getType()) {
            case 8: {
                ListNode lin = (ListNode)node;
                do {
                    len += this.compileLengthTree(lin.value);
                } while ((lin = lin.tail) != null);
                break;
            }
            case 9: {
                ListNode aln = (ListNode)node;
                int n = 0;
                do {
                    len += this.compileLengthTree(aln.value);
                    ++n;
                } while ((aln = aln.tail) != null);
                len += 4 * (n - 1);
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                if (sn.isRaw()) {
                    len = this.compileLengthStringRawNode(sn);
                    break;
                }
                len = this.compileLengthStringNode(sn);
                break;
            }
            case 1: {
                len = this.compileLengthCClassNode((CClassNode)node);
                break;
            }
            case 2: 
            case 3: {
                len = 1;
                break;
            }
            case 4: {
                BackRefNode br = (BackRefNode)node;
                if (br.isNestLevel()) {
                    len = 4 + 1 * br.backNum;
                    break;
                }
                if (br.backNum == 1) {
                    len = !Option.isIgnoreCase(this.regex.options) && br.back[0] <= 2 ? 1 : 2;
                    break;
                }
                len = 2 + 1 * br.backNum;
                break;
            }
            case 10: {
                len = 2;
                break;
            }
            case 5: {
                len = this.compileNonCECLengthQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                len = this.compileLengthEncloseNode((EncloseNode)node);
                break;
            }
            case 7: {
                len = this.compileLengthAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
        return len;
    }

    private void ensure(int size) {
        if (size >= this.code.length) {
            int length;
            for (length = this.code.length << 1; length <= size; length <<= 1) {
            }
            int[] tmp = new int[length];
            System.arraycopy(this.code, 0, tmp, 0, this.code.length);
            this.code = tmp;
        }
    }

    private void addInt(int i) {
        if (this.codeLength >= this.code.length) {
            int[] tmp = new int[this.code.length << 1];
            System.arraycopy(this.code, 0, tmp, 0, this.code.length);
            this.code = tmp;
        }
        this.code[this.codeLength++] = i;
    }

    void setInt(int i, int offset) {
        this.ensure(offset);
        this.regex.code[offset] = i;
    }

    private void addBytes(byte[] bytes, int p, int length) {
        this.ensure(this.codeLength + length);
        int end = p + length;
        while (p < end) {
            this.code[this.codeLength++] = bytes[p++];
        }
    }

    private void addInts(int[] ints, int length) {
        this.ensure(this.codeLength + length);
        System.arraycopy(ints, 0, this.code, this.codeLength, length);
        this.codeLength += length;
    }

    private void addOpcode(int opcode) {
        this.addInt(opcode);
    }

    private void addStateCheckNum(int num) {
        this.addInt(num);
    }

    private void addRelAddr(int addr) {
        this.addInt(addr);
    }

    private void addAbsAddr(int addr) {
        this.addInt(addr);
    }

    private void addLength(int length) {
        this.addInt(length);
    }

    private void addMemNum(int num) {
        this.addInt(num);
    }

    private void addOption(int option) {
        this.addInt(option);
    }

    private void addOpcodeRelAddr(int opcode, int addr) {
        this.addOpcode(opcode);
        this.addRelAddr(addr);
    }

    private void addOpcodeOption(int opcode, int option) {
        this.addOpcode(opcode);
        this.addOption(option);
    }

    private void addTemplate(byte[] bytes) {
        if (this.templateNum == 0) {
            this.templates = new byte[2][];
        } else if (this.templateNum == this.templates.length) {
            byte[][] tmp = new byte[this.templateNum * 2][];
            System.arraycopy(this.templates, 0, tmp, 0, this.templateNum);
            this.templates = tmp;
        }
        this.templates[this.templateNum++] = bytes;
    }
}

