/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ReplicationTests.class, LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestVerifyReplicationSecureClusterCredentials {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyReplicationSecureClusterCredentials.class);
    private static MiniKdc KDC;
    private static final HBaseTestingUtility UTIL1;
    private static final HBaseTestingUtility UTIL2;
    private static final File KEYTAB_FILE;
    private static final String LOCALHOST = "localhost";
    private static String CLUSTER_PRINCIPAL;
    private static String FULL_USER_PRINCIPAL;
    private static String HTTP_PRINCIPAL;
    @Parameterized.Parameter
    public Supplier<String> peer;

    private static void setUpKdcServer() throws Exception {
        String userPrincipal;
        KDC = UTIL1.setupMiniKdc(KEYTAB_FILE);
        String username = UserGroupInformation.getLoginUser().getShortUserName();
        CLUSTER_PRINCIPAL = userPrincipal = username + '/' + LOCALHOST;
        FULL_USER_PRINCIPAL = userPrincipal + '@' + KDC.getRealm();
        HTTP_PRINCIPAL = "HTTP/localhost";
        KDC.createPrincipal(KEYTAB_FILE, new String[]{CLUSTER_PRINCIPAL, HTTP_PRINCIPAL});
    }

    private static void setupCluster(HBaseTestingUtility util) throws Exception {
        Configuration conf = util.getConfiguration();
        SecureTestUtil.enableSecurity((Configuration)conf);
        VisibilityTestUtil.enableVisiblityLabels((Configuration)conf);
        SecureTestUtil.verifyConfiguration((Configuration)conf);
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName() + ',' + TokenProvider.class.getName());
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf, (String)(CLUSTER_PRINCIPAL + '@' + KDC.getRealm()), (String)(HTTP_PRINCIPAL + '@' + KDC.getRealm()));
        util.startMiniCluster();
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        TestVerifyReplicationSecureClusterCredentials.setUpKdcServer();
        TestVerifyReplicationSecureClusterCredentials.setupCluster(UTIL1);
        TestVerifyReplicationSecureClusterCredentials.setupCluster(UTIL2);
        try (Admin admin = UTIL1.getAdmin();){
            admin.addReplicationPeer("1", ReplicationPeerConfig.newBuilder().setClusterKey(ZKConfig.getZooKeeperClusterKey((Configuration)UTIL2.getConfiguration())).putConfiguration("hbase.regionserver.kerberos.principal", UTIL2.getConfiguration().get("hbase.regionserver.kerberos.principal")).putConfiguration("hbase.master.kerberos.principal", UTIL2.getConfiguration().get("hbase.master.kerberos.principal")).build());
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        UTIL1.shutdownMiniCluster();
        UTIL2.shutdownMiniCluster();
    }

    @Parameterized.Parameters
    public static Collection<Supplier<String>> peer() {
        return Arrays.asList(() -> "1", () -> ZKConfig.getZooKeeperClusterKey((Configuration)UTIL2.getConfiguration()));
    }

    @Test
    public void testJobCredentials() throws Exception {
        Job job = new VerifyReplication().createSubmittableJob(new Configuration(UTIL1.getConfiguration()), new String[]{this.peer.get(), "table"});
        Credentials credentials = job.getCredentials();
        Collection tokens = credentials.getAllTokens();
        Assert.assertEquals((long)2L, (long)tokens.size());
        String clusterId1 = ZKClusterId.readClusterIdZNode((ZKWatcher)UTIL1.getZooKeeperWatcher());
        Token tokenForCluster1 = credentials.getToken(new Text(clusterId1));
        Assert.assertEquals((Object)FULL_USER_PRINCIPAL, (Object)((AuthenticationTokenIdentifier)tokenForCluster1.decodeIdentifier()).getUsername());
        String clusterId2 = ZKClusterId.readClusterIdZNode((ZKWatcher)UTIL2.getZooKeeperWatcher());
        Token tokenForCluster2 = credentials.getToken(new Text(clusterId2));
        Assert.assertEquals((Object)FULL_USER_PRINCIPAL, (Object)((AuthenticationTokenIdentifier)tokenForCluster2.decodeIdentifier()).getUsername());
    }

    static {
        UTIL1 = new HBaseTestingUtility();
        UTIL2 = new HBaseTestingUtility();
        KEYTAB_FILE = new File(UTIL1.getDataTestDir("keytab").toUri().getPath());
    }
}

