/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.jmx;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.util.JSONBean;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JMXJsonServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(JMXJsonServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String CALLBACK_PARAM = "callback";
    private static final String INCLUDE_DESCRIPTION = "description";
    protected transient MBeanServer mBeanServer;
    protected transient JSONBean jsonBeanWriter;

    public void init() throws ServletException {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.jsonBeanWriter = new JSONBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
                return;
            }
            String jsonpcb = null;
            PrintWriter writer = null;
            Closeable beanWriter = null;
            try {
                jsonpcb = this.checkCallbackName(request.getParameter(CALLBACK_PARAM));
                writer = response.getWriter();
                if (jsonpcb != null) {
                    response.setContentType("application/javascript; charset=utf8");
                    writer.write(jsonpcb + "(");
                } else {
                    response.setContentType("application/json; charset=utf8");
                }
                beanWriter = this.jsonBeanWriter.open(writer);
                boolean description = "true".equals(request.getParameter(INCLUDE_DESCRIPTION));
                String getmethod = request.getParameter("get");
                if (getmethod != null) {
                    List splitStrings = Splitter.onPattern((String)"\\:\\:").splitToList((CharSequence)getmethod);
                    if (splitStrings.size() != 2) {
                        beanWriter.write("result", "ERROR");
                        beanWriter.write("message", "query format is not as expected.");
                        beanWriter.flush();
                        response.setStatus(400);
                        return;
                    }
                    Iterator i = splitStrings.iterator();
                    if (beanWriter.write(this.mBeanServer, new ObjectName((String)i.next()), (String)i.next(), description) != 0) {
                        beanWriter.flush();
                        response.setStatus(400);
                    }
                    return;
                }
                String qry = request.getParameter("qry");
                if (qry == null) {
                    qry = "*:*";
                }
                if (beanWriter.write(this.mBeanServer, new ObjectName(qry), null, description) != 0) {
                    beanWriter.flush();
                    response.setStatus(400);
                }
            }
            finally {
                if (beanWriter != null) {
                    beanWriter.close();
                }
                if (jsonpcb != null) {
                    writer.write(");");
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error("Caught an exception while processing JMX request", (Throwable)e);
            response.sendError(500);
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Caught an exception while processing JMX request", (Throwable)e);
            response.sendError(400);
        }
    }

    private String checkCallbackName(String callbackName) throws IOException {
        if (null == callbackName) {
            return null;
        }
        if (callbackName.matches("[A-Za-z0-9_]+")) {
            return callbackName;
        }
        throw new IOException("'callback' must be alphanumeric");
    }
}

