/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableScan;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.LimitedScanResultConsumer;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.SimpleScanResultConsumerImpl;
import org.apache.hadoop.hbase.client.TracedScanResultConsumer;
import org.apache.hadoop.hbase.client.trace.StringTraceRenderer;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableScan
extends AbstractTestAsyncTableScan {
    private static final Logger logger = LoggerFactory.getLogger(TestAsyncTableScan.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScan.class);
    @Parameterized.Parameter(value=0)
    public String scanType;
    @Parameterized.Parameter(value=1)
    public Supplier<Scan> scanCreater;

    @Parameterized.Parameters(name="{index}: scan={0}")
    public static List<Object[]> params() {
        return TestAsyncTableScan.getScanCreatorParams();
    }

    @Override
    protected Scan createScan() {
        return this.scanCreater.get();
    }

    @Override
    protected List<Result> doScan(Scan scan, int closeAfter) throws Exception {
        List<Result> results;
        AsyncTable table = CONN_RULE.getAsyncConnection().getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
        if (closeAfter > 0) {
            if (scan.getBatch() > 0) {
                closeAfter *= 2;
            }
            TracedScanResultConsumer consumer = new TracedScanResultConsumer(new LimitedScanResultConsumer(closeAfter));
            table.scan(scan, (ScanResultConsumerBase)consumer);
            results = consumer.getAll();
        } else {
            TracedScanResultConsumer consumer = new TracedScanResultConsumer(new SimpleScanResultConsumerImpl());
            table.scan(scan, (ScanResultConsumerBase)consumer);
            results = consumer.getAll();
        }
        if (scan.getBatch() > 0) {
            results = this.convertFromBatchResult(results);
        }
        return results;
    }

    @Override
    protected void assertTraceContinuity() {
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        TestAsyncTableScan.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        if (logger.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer((Collection)TestAsyncTableScan.spanStream().collect(Collectors.toList()));
            stringTraceRenderer.render(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        String parentSpanId = TestAsyncTableScan.spanStream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().get();
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        TestAsyncTableScan.waitForSpan((Matcher<SpanData>)scanOperationSpanMatcher);
        String scanOperationSpanId = TestAsyncTableScan.spanStream().filter(arg_0 -> ((Matcher)scanOperationSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().get();
        Matcher onNextMatcher = SpanDataMatchers.hasName((String)"TracedScanResultConsumer#onNext");
        TestAsyncTableScan.waitForSpan((Matcher<SpanData>)onNextMatcher);
        TestAsyncTableScan.spanStream().filter(arg_0 -> ((Matcher)onNextMatcher).matches(arg_0)).forEach(span -> MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf((Matcher)onNextMatcher, (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded())));
        Matcher onCompleteMatcher = SpanDataMatchers.hasName((String)"TracedScanResultConsumer#onComplete");
        TestAsyncTableScan.waitForSpan((Matcher<SpanData>)onCompleteMatcher);
        TestAsyncTableScan.spanStream().filter(arg_0 -> ((Matcher)onCompleteMatcher).matches(arg_0)).forEach(span -> MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf((Matcher)onCompleteMatcher, (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded())));
    }

    @Override
    protected void assertTraceError(Matcher<Attributes> exceptionMatcher) {
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasEnded());
        TestAsyncTableScan.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        if (logger.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer((Collection)TestAsyncTableScan.spanStream().collect(Collectors.toList()));
            stringTraceRenderer.render(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        String parentSpanId = TestAsyncTableScan.spanStream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().get();
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.ERROR), (Matcher)SpanDataMatchers.hasException(exceptionMatcher), (Matcher)SpanDataMatchers.hasEnded());
        TestAsyncTableScan.waitForSpan((Matcher<SpanData>)scanOperationSpanMatcher);
        String scanOperationSpanId = TestAsyncTableScan.spanStream().filter(arg_0 -> ((Matcher)scanOperationSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().get();
        Matcher onErrorMatcher = SpanDataMatchers.hasName((String)"TracedScanResultConsumer#onError");
        TestAsyncTableScan.waitForSpan((Matcher<SpanData>)onErrorMatcher);
        TestAsyncTableScan.spanStream().filter(arg_0 -> ((Matcher)onErrorMatcher).matches(arg_0)).forEach(span -> MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf((Matcher)onErrorMatcher, (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded())));
    }
}

