/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.ServerTooBusyException;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestServerBusyException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerBusyException.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAM_NAM = Bytes.toBytes((String)"f");
    private static final byte[] ROW = Bytes.toBytes((String)"bbb");
    private static final int RPC_RETRY = 5;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 5);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.client.perserver.requests.threshold", 3);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testServerBusyException() throws Exception {
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        hdt.addCoprocessor(SleepCoprocessor.class.getName());
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        TEST_UTIL.createTable((TableDescriptor)hdt, (byte[][])new byte[][]{FAM_NAM}, c);
        TestGetThread tg1 = new TestGetThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        TestGetThread tg2 = new TestGetThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        TestGetThread tg3 = new TestGetThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        TestGetThread tg4 = new TestGetThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        TestGetThread tg5 = new TestGetThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        tg1.start();
        tg2.start();
        tg3.start();
        tg4.start();
        tg5.start();
        tg1.join();
        tg2.join();
        tg3.join();
        tg4.join();
        tg5.join();
        Assert.assertEquals((long)2L, (long)(tg1.getServerBusyException + tg2.getServerBusyException + tg3.getServerBusyException + tg4.getServerBusyException + tg5.getServerBusyException));
        TestPutThread tp1 = new TestPutThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        TestPutThread tp2 = new TestPutThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        TestPutThread tp3 = new TestPutThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        TestPutThread tp4 = new TestPutThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        TestPutThread tp5 = new TestPutThread(TEST_UTIL.getConnection().getTable(hdt.getTableName()));
        tp1.start();
        tp2.start();
        tp3.start();
        tp4.start();
        tp5.start();
        tp1.join();
        tp2.join();
        tp3.join();
        tp4.join();
        tp5.join();
        Assert.assertEquals((long)2L, (long)(tp1.getServerBusyException + tp2.getServerBusyException + tp3.getServerBusyException + tp4.getServerBusyException + tp5.getServerBusyException));
    }

    private static class TestGetThread
    extends Thread {
        Table table;
        int getServerBusyException = 0;

        TestGetThread(Table table) {
            this.table = table;
        }

        @Override
        public void run() {
            try {
                Get g = new Get(ROW);
                g.addColumn(FAM_NAM, new byte[]{0});
                this.table.get(g);
            }
            catch (ServerTooBusyException e) {
                this.getServerBusyException = 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class TestPutThread
    extends Thread {
        Table table;
        int getServerBusyException = 0;

        TestPutThread(Table table) {
            this.table = table;
        }

        @Override
        public void run() {
            try {
                Put p = new Put(ROW);
                p.addColumn(FAM_NAM, new byte[]{0}, new byte[]{0});
                this.table.put(p);
            }
            catch (ServerTooBusyException e) {
                this.getServerBusyException = 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class SleepLongerAtFirstCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public static final int SLEEP_TIME = 2000;
        static final AtomicLong ct = new AtomicLong(0L);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (ct.incrementAndGet() <= 1L) {
                Threads.sleep((long)20000L);
            } else {
                Threads.sleep((long)2000L);
            }
        }
    }

    public static class SleepCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public static final int SLEEP_TIME = 5000;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            Threads.sleep((long)5000L);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            Threads.sleep((long)5000L);
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            Threads.sleep((long)5000L);
            return null;
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
            Threads.sleep((long)5000L);
        }
    }
}

