/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.codahale.metrics.MetricRegistry;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFilePrettyPrinter;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFilePrettyPrinter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFilePrettyPrinter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHFilePrettyPrinter.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static FileSystem fs;
    private static Configuration conf;
    private static byte[] cf;
    private static byte[] fam;
    private static byte[] value;
    private static PrintStream original;
    private static PrintStream ps;
    private static ByteArrayOutputStream stream;

    @Before
    public void setup() throws Exception {
        conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.unsafe.stream.capability.enforce", false);
        fs = UTIL.getTestFileSystem();
        stream = new ByteArrayOutputStream();
        ps = new PrintStream(stream);
    }

    @After
    public void teardown() {
        original = System.out;
        System.setOut(original);
    }

    @Test
    public void testHFilePrettyPrinterNonRootDir() throws Exception {
        Path fileNotInRootDir = UTIL.getDataTestDir("hfile");
        TestHRegionServerBulkLoad.createHFile(fs, fileNotInRootDir, cf, fam, value, 1000);
        Assert.assertNotEquals((String)"directory used is not an HBase root dir", (Object)UTIL.getDefaultRootDirPath(), (Object)fileNotInRootDir);
        System.setOut(ps);
        new HFilePrettyPrinter(conf).run(new String[]{"-v", String.valueOf(fileNotInRootDir)});
        String result = new String(stream.toByteArray());
        String expectedResult = "Scanning -> " + fileNotInRootDir + "\nScanned kv count -> 1000\n";
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testHFilePrettyPrinterRootDir() throws Exception {
        Path rootPath = CommonFSUtils.getRootDir((Configuration)conf);
        String rootString = rootPath + "/";
        Path fileInRootDir = new Path(rootString + "hfile");
        TestHRegionServerBulkLoad.createHFile(fs, fileInRootDir, cf, fam, value, 1000);
        Assert.assertTrue((String)"directory used is a root dir", (boolean)fileInRootDir.toString().startsWith(rootString));
        System.setOut(ps);
        HFilePrettyPrinter printer = new HFilePrettyPrinter();
        printer.setConf(conf);
        printer.processFile(fileInRootDir, true);
        printer.run(new String[]{"-v", String.valueOf(fileInRootDir)});
        String result = new String(stream.toByteArray());
        String expectedResult = "Scanning -> " + fileInRootDir + "\nScanned kv count -> 1000\n";
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testHFilePrettyPrinterSeekFirstRow() throws Exception {
        Path fileNotInRootDir = UTIL.getDataTestDir("hfile");
        TestHRegionServerBulkLoad.createHFile(fs, fileNotInRootDir, cf, fam, value, 1000);
        Assert.assertNotEquals((String)"directory used is not an HBase root dir", (Object)UTIL.getDefaultRootDirPath(), (Object)fileNotInRootDir);
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)fileNotInRootDir, (CacheConfig)CacheConfig.DISABLED, (boolean)true, (Configuration)conf);
        String firstRowKey = new String((byte[])reader.getFirstRowKey().get());
        System.setOut(ps);
        new HFilePrettyPrinter(conf).run(new String[]{"-v", "-w" + firstRowKey, String.valueOf(fileNotInRootDir)});
        String result = new String(stream.toByteArray());
        String expectedResult = "Scanning -> " + fileNotInRootDir + "\nScanned kv count -> 1\n";
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testHistograms() throws Exception {
        Path fileNotInRootDir = UTIL.getDataTestDir("hfile");
        TestHRegionServerBulkLoad.createHFile(fs, fileNotInRootDir, cf, fam, value, 1000);
        Assert.assertNotEquals((String)"directory used is not an HBase root dir", (Object)UTIL.getDefaultRootDirPath(), (Object)fileNotInRootDir);
        System.setOut(ps);
        new HFilePrettyPrinter(conf).run(new String[]{"-s", "-d", String.valueOf(fileNotInRootDir)});
        String result = stream.toString();
        LOG.info(result);
        String[] headers = new String[]{"Key length", "Val length", "Row size (bytes)", "Row size (columns)"};
        int[][] expectations = new int[][]{{0, 10, 1000, 50}, {0, 1, 1000, 3}, {0, 10, 1000, 50}, {1000, 1}};
        for (int i = 0; i < headers.length - 1; ++i) {
            int idx = result.indexOf(headers[i]);
            int nextIdx = result.indexOf(headers[i + 1]);
            this.assertContainsRanges(result.substring(idx, nextIdx), expectations[i]);
        }
    }

    private void assertContainsRanges(String result, int ... rangeCountPairs) {
        for (int i = 0; i < rangeCountPairs.length - 1; i += 2) {
            String expected = rangeCountPairs[i + 1] + " <= " + rangeCountPairs[i];
            Assert.assertTrue((String)("expected:\n" + result + "\nto contain: '" + expected + "'"), (boolean)result.contains(expected));
        }
    }

    @Test
    public void testKeyValueStats() {
        long[] ranges;
        HFilePrettyPrinter.KeyValueStats stats = new HFilePrettyPrinter.KeyValueStats(new MetricRegistry(), "test");
        for (long range : ranges = stats.getRanges()) {
            stats.update(range - 1L, true);
        }
        Assert.assertEquals((long)(ranges[ranges.length - 1] - 1L), (long)stats.getMax());
        Assert.assertEquals((long)(ranges[0] - 1L), (long)stats.getMin());
        int total = 1;
        for (long range : ranges) {
            long val = stats.getCountAtOrBelow(range);
            Assert.assertEquals((long)total++, (long)val);
        }
    }

    static {
        cf = Bytes.toBytes((String)"cf");
        fam = Bytes.toBytes((String)"fam");
        value = Bytes.toBytes((String)"val");
    }
}

