/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterHandlerFullWhenTransitRegion {
    private static Logger LOG = LoggerFactory.getLogger((String)TestMasterHandlerFullWhenTransitRegion.class.getName());
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterHandlerFullWhenTransitRegion.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final String TABLENAME = "table";

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setStrings("hbase.coprocessor.region.classes", new String[]{DelayOpenCP.class.getName()});
        UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 1);
        UTIL.startMiniCluster(2);
        UTIL.createTable(TableName.valueOf((String)TABLENAME), "fa");
    }

    @Test
    public void test() throws Exception {
        RegionInfo regionInfo = (RegionInfo)UTIL.getAdmin().getRegions(TableName.valueOf((String)TABLENAME)).get(0);
        UTIL.getAdmin().move(regionInfo.getEncodedNameAsBytes());
        LOG.info("Region move complete");
    }

    public static class DelayOpenCP
    implements RegionCoprocessor,
    RegionObserver {
        public void preOpen(ObserverContext<RegionCoprocessorEnvironment> c) throws IOException {
            try {
                if (!((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().isSystemTable()) {
                    LOG.info("begin to sleep");
                    Thread.sleep(10000L);
                    LOG.info("finish sleep");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }
    }
}

