/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterFailoverWithProceduresTestBase;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDeleteTableWithMasterFailover
extends MasterFailoverWithProceduresTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDeleteTableWithMasterFailover.class);

    @Test
    public void testDeleteWithFailover() throws Exception {
        this.testDeleteWithFailoverAtStep(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_UNASSIGN_REGIONS.ordinal());
    }

    private void testDeleteWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testDeleteWithFailoverAtStep" + step));
        byte[][] splitKeys = null;
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(TestDeleteTableWithMasterFailover.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = TestDeleteTableWithMasterFailover.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)true);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        TestDeleteTableWithMasterFailover.testRecoveryAndDoubleExecution(UTIL, procId, step);
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName);
    }
}

