/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestProcedureAdmin {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureAdmin.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureAdmin.class);
    @Rule
    public TestName name = new TestName();
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestProcedureAdmin.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertTrue((String)"expected executor to be running", (boolean)this.getMasterProcedureExecutor().isRunning());
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getAdmin().listTables()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testAbortProcedureSuccess() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        boolean abortResult = procExec.abort(procId, true);
        Assert.assertTrue((boolean)abortResult);
        MasterProcedureTestingUtility.testRestartWithAbort(procExec, procId);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        MasterProcedureTestingUtility.validateTableIsEnabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    @Test
    public void testAbortProcedureFailure() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        for (int i = 0; i < 2; ++i) {
            ProcedureTestingUtility.assertProcNotYetCompleted(procExec, (long)procId);
            ProcedureTestingUtility.restart(procExec);
            ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        }
        boolean abortResult = procExec.abort(procId, true);
        Assert.assertFalse((boolean)abortResult);
        MasterProcedureTestingUtility.testRestartWithAbort(procExec, procId);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    @Test
    public void testAbortProcedureInterruptedNotAllowed() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, true));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        MasterProcedureTestingUtility.restartMasterProcedureExecutor(procExec);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        boolean abortResult = procExec.abort(procId, false);
        Assert.assertFalse((boolean)abortResult);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.restart(procExec);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableIsDisabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    @Test
    public void testAbortNonExistProcedure() throws Exception {
        long procId;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        while (procExec.getResult(procId = ThreadLocalRandom.current().nextLong()) != null) {
        }
        boolean abortResult = procExec.abort(procId, true);
        Assert.assertFalse((boolean)abortResult);
    }

    @Test
    public void testGetProcedure() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        List procedures = procExec.getProcedures();
        Assert.assertTrue((procedures.size() >= 1 ? 1 : 0) != 0);
        boolean found = false;
        for (Procedure proc : procedures) {
            if (proc.getProcId() == procId) {
                Assert.assertTrue((boolean)proc.isRunnable());
                found = true;
                continue;
            }
            Assert.assertTrue((boolean)proc.isSuccess());
        }
        Assert.assertTrue((boolean)found);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.restart(procExec);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        procedures = procExec.getProcedures();
        for (Procedure proc : procedures) {
            Assert.assertTrue((boolean)proc.isSuccess());
        }
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

