/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestDirectStoreSplitsMerges {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDirectStoreSplitsMerges.class);
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    public static final byte[] FAMILY_NAME = Bytes.toBytes((String)"info");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void after() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSplitStoreDir() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(table, FAMILY_NAME);
        this.putThreeRowsAndFlush(table);
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(table).get(0);
        HRegionFileSystem regionFS = ((HStore)region.getStores().get(0)).getRegionFileSystem();
        RegionInfo daughterA = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(region.getRegionInfo().getStartKey()).setEndKey(Bytes.toBytes((String)"002")).setSplit(false).setRegionId(region.getRegionInfo().getRegionId() + EnvironmentEdgeManager.currentTime()).build();
        HStoreFile file = (HStoreFile)region.getStore(FAMILY_NAME).getStorefiles().toArray()[0];
        Path result = regionFS.splitStoreFile(daughterA, Bytes.toString((byte[])FAMILY_NAME), file, Bytes.toBytes((String)"002"), false, region.getSplitPolicy());
        this.validateResultingFile(region.getRegionInfo().getEncodedName(), result);
        Path resultGreatGrandParent = result.getParent().getParent().getParent();
        Assert.assertEquals((Object)regionFS.getTableDir().getName(), (Object)resultGreatGrandParent.getName());
    }

    @Test
    public void testMergeStoreFile() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(table, FAMILY_NAME);
        TEST_UTIL.getAdmin().split(table, Bytes.toBytes((String)"002"));
        this.waitForSplitProcComplete(1000, 10);
        this.putThreeRowsAndFlush(table);
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(table);
        HRegion first = regions.get(0);
        HRegion second = regions.get(1);
        HRegionFileSystem regionFS = first.getRegionFileSystem();
        RegionInfo mergeResult = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(first.getRegionInfo().getStartKey()).setEndKey(second.getRegionInfo().getEndKey()).setSplit(false).setRegionId(first.getRegionInfo().getRegionId() + EnvironmentEdgeManager.currentTime()).build();
        HRegionFileSystem mergeRegionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)TEST_UTIL.getHBaseCluster().getMaster().getConfiguration(), (FileSystem)regionFS.getFileSystem(), (Path)regionFS.getTableDir(), (RegionInfo)mergeResult);
        HStoreFile file = (HStoreFile)first.getStore(FAMILY_NAME).getStorefiles().toArray()[0];
        this.mergeFileFromRegion(mergeRegionFs, first, file);
        file = (HStoreFile)second.getStore(FAMILY_NAME).getStorefiles().toArray()[0];
        this.mergeFileFromRegion(mergeRegionFs, second, file);
    }

    @Test
    public void testCommitDaughterRegionNoFiles() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(table, FAMILY_NAME);
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(table).get(0);
        HRegionFileSystem regionFS = ((HStore)region.getStores().get(0)).getRegionFileSystem();
        RegionInfo daughterA = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(region.getRegionInfo().getStartKey()).setEndKey(Bytes.toBytes((String)"002")).setSplit(false).setRegionId(region.getRegionInfo().getRegionId() + EnvironmentEdgeManager.currentTime()).build();
        Path splitDir = regionFS.getSplitsDir(daughterA);
        MasterProcedureEnv env = (MasterProcedureEnv)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        Path result = regionFS.commitDaughterRegion(daughterA, new ArrayList(), env);
        Assert.assertEquals((Object)splitDir, (Object)result);
    }

    @Test
    public void testCommitDaughterRegionWithFiles() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(table, FAMILY_NAME);
        this.putThreeRowsAndFlush(table);
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(table).get(0);
        HRegionFileSystem regionFS = ((HStore)region.getStores().get(0)).getRegionFileSystem();
        RegionInfo daughterA = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(region.getRegionInfo().getStartKey()).setEndKey(Bytes.toBytes((String)"002")).setSplit(false).setRegionId(region.getRegionInfo().getRegionId() + EnvironmentEdgeManager.currentTime()).build();
        RegionInfo daughterB = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(Bytes.toBytes((String)"002")).setEndKey(region.getRegionInfo().getEndKey()).setSplit(false).setRegionId(region.getRegionInfo().getRegionId()).build();
        Path splitDirA = regionFS.getSplitsDir(daughterA);
        Path splitDirB = regionFS.getSplitsDir(daughterB);
        HStoreFile file = (HStoreFile)region.getStore(FAMILY_NAME).getStorefiles().toArray()[0];
        ArrayList<Path> filesA = new ArrayList<Path>();
        filesA.add(regionFS.splitStoreFile(daughterA, Bytes.toString((byte[])FAMILY_NAME), file, Bytes.toBytes((String)"002"), false, region.getSplitPolicy()));
        ArrayList<Path> filesB = new ArrayList<Path>();
        filesB.add(regionFS.splitStoreFile(daughterB, Bytes.toString((byte[])FAMILY_NAME), file, Bytes.toBytes((String)"002"), true, region.getSplitPolicy()));
        MasterProcedureEnv env = (MasterProcedureEnv)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        Path resultA = regionFS.commitDaughterRegion(daughterA, filesA, env);
        Path resultB = regionFS.commitDaughterRegion(daughterB, filesB, env);
        Assert.assertEquals((Object)splitDirA, (Object)resultA);
        Assert.assertEquals((Object)splitDirB, (Object)resultB);
    }

    @Test
    public void testCommitMergedRegion() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(table, FAMILY_NAME);
        TEST_UTIL.getAdmin().split(table, Bytes.toBytes((String)"002"));
        this.waitForSplitProcComplete(1000, 10);
        this.putThreeRowsAndFlush(table);
        List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(table);
        HRegion first = regions.get(0);
        HRegion second = regions.get(1);
        HRegionFileSystem regionFS = first.getRegionFileSystem();
        RegionInfo mergeResult = RegionInfoBuilder.newBuilder((TableName)table).setStartKey(first.getRegionInfo().getStartKey()).setEndKey(second.getRegionInfo().getEndKey()).setSplit(false).setRegionId(first.getRegionInfo().getRegionId() + EnvironmentEdgeManager.currentTime()).build();
        HRegionFileSystem mergeRegionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)TEST_UTIL.getHBaseCluster().getMaster().getConfiguration(), (FileSystem)regionFS.getFileSystem(), (Path)regionFS.getTableDir(), (RegionInfo)mergeResult);
        HStoreFile file = (HStoreFile)first.getStore(FAMILY_NAME).getStorefiles().toArray()[0];
        this.mergeFileFromRegion(mergeRegionFs, first, file);
        file = (HStoreFile)second.getStore(FAMILY_NAME).getStorefiles().toArray()[0];
        ArrayList<Path> mergedFiles = new ArrayList<Path>();
        mergedFiles.add(this.mergeFileFromRegion(mergeRegionFs, second, file));
        MasterProcedureEnv env = (MasterProcedureEnv)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment();
        mergeRegionFs.commitMergedRegion(mergedFiles, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSplitProcComplete(int attempts, int waitTime) throws Exception {
        List procedures = TEST_UTIL.getHBaseCluster().getMaster().getProcedures();
        if (procedures.size() > 0) {
            Procedure splitProc = procedures.stream().filter(p -> p instanceof SplitTableRegionProcedure).findFirst().get();
            for (int count = 0; (splitProc.isWaiting() || splitProc.isRunnable()) && count < attempts; ++count) {
                Procedure procedure = splitProc;
                synchronized (procedure) {
                    splitProc.wait(waitTime);
                    continue;
                }
            }
            Assert.assertTrue((boolean)splitProc.isSuccess());
        }
    }

    private Path mergeFileFromRegion(HRegionFileSystem regionFS, HRegion regionToMerge, HStoreFile file) throws IOException {
        Path mergedFile = regionFS.mergeStoreFile(regionToMerge.getRegionInfo(), Bytes.toString((byte[])FAMILY_NAME), file);
        this.validateResultingFile(regionToMerge.getRegionInfo().getEncodedName(), mergedFile);
        return mergedFile;
    }

    private void validateResultingFile(String originalRegion, Path result) {
        Assert.assertEquals((Object)originalRegion, (Object)result.getName().split("\\.")[1]);
        Path resultParent = result.getParent();
        Assert.assertEquals((Object)Bytes.toString((byte[])FAMILY_NAME), (Object)resultParent.getName());
    }

    private void putThreeRowsAndFlush(TableName table) throws IOException {
        Table tbl = TEST_UTIL.getConnection().getTable(table);
        Put put = new Put(Bytes.toBytes((String)"001"));
        byte[] qualifier = Bytes.toBytes((String)"1");
        put.addColumn(FAMILY_NAME, qualifier, Bytes.toBytes((int)1));
        tbl.put(put);
        put = new Put(Bytes.toBytes((String)"002"));
        put.addColumn(FAMILY_NAME, qualifier, Bytes.toBytes((int)2));
        tbl.put(put);
        put = new Put(Bytes.toBytes((String)"003"));
        put.addColumn(FAMILY_NAME, qualifier, Bytes.toBytes((int)2));
        tbl.put(put);
        TEST_UTIL.flush(table);
    }
}

