/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperImpl;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class, RegionServerTests.class})
public class TestMetricsRegionServerAggregate {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsRegionServerAggregate.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        AtomicInteger retVal = new AtomicInteger(0);
        Answer defaultAnswer = invocation -> {
            Class<?> returnType = invocation.getMethod().getReturnType();
            if (returnType.equals(Integer.TYPE) || returnType.equals(Integer.class)) {
                return retVal.get();
            }
            if (returnType.equals(Long.TYPE) || returnType.equals(Long.class)) {
                return (long)retVal.get();
            }
            return Mockito.RETURNS_DEFAULTS.answer(invocation);
        };
        ServerName serverName = (ServerName)Mockito.mock(ServerName.class);
        Mockito.when((Object)serverName.getHostname()).thenReturn((Object)"foo");
        WALFactory walFactory = (WALFactory)Mockito.mock(WALFactory.class);
        RpcServerInterface rpcServer = (RpcServerInterface)Mockito.mock(RpcServerInterface.class);
        AtomicInteger storeFileCount = new AtomicInteger(1);
        HRegion regionOne = this.getMockedRegion(defaultAnswer, "a", "foo", true, storeFileCount);
        HRegion regionTwo = this.getMockedRegion(defaultAnswer, "b", "bar", true, storeFileCount);
        HRegion regionThree = this.getMockedRegion(defaultAnswer, "c", "foo", false, storeFileCount);
        HRegion regionFour = this.getMockedRegion(defaultAnswer, "d", "bar", false, storeFileCount);
        ArrayList regions = Lists.newArrayList((Object[])new HRegion[]{regionOne, regionTwo, regionThree, regionFour});
        int numStoresPerRegion = 2;
        for (HRegion region : regions) {
            Assert.assertEquals((long)numStoresPerRegion, (long)region.getStores().size());
        }
        HRegionServer regionServer = (HRegionServer)Mockito.mock(HRegionServer.class, (Answer)defaultAnswer);
        Mockito.when((Object)regionServer.getWalFactory()).thenReturn((Object)walFactory);
        Mockito.when((Object)regionServer.getOnlineRegionsLocalContext()).thenReturn((Object)regions);
        Mockito.when((Object)regionServer.getServerName()).thenReturn((Object)serverName);
        Configuration conf = HBaseConfiguration.create();
        int metricsPeriodSec = 600;
        conf.setLong("hbase.regionserver.metrics.period", (long)(metricsPeriodSec * 1000));
        Mockito.when((Object)regionServer.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)regionServer.getRpcServer()).thenReturn((Object)rpcServer);
        MetricsRegionServerWrapperImpl wrapper = new MetricsRegionServerWrapperImpl(regionServer);
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        try {
            for (int i = 1; i <= 10; ++i) {
                edge.incValue(wrapper.getPeriod());
                retVal.incrementAndGet();
                wrapper.forceRecompute();
                int numRegions = regions.size();
                int totalStores = numRegions * numStoresPerRegion;
                int expectedForRegions = retVal.get() * numRegions;
                int expectedForStores = retVal.get() * totalStores;
                Assert.assertEquals((long)totalStores, (long)wrapper.getNumStores());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getFlushedCellsCount());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getCompactedCellsCount());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getMajorCompactedCellsCount());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getFlushedCellsSize());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getCompactedCellsSize());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getMajorCompactedCellsSize());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getCellsCountCompactedFromMob());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getCellsCountCompactedToMob());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getCellsSizeCompactedFromMob());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getCellsSizeCompactedToMob());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getMobFlushCount());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getMobFlushedCellsCount());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getMobFlushedCellsSize());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getMobScanCellsCount());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getMobScanCellsSize());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getCheckAndMutateChecksFailed());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getCheckAndMutateChecksPassed());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getStoreFileIndexSize());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getTotalStaticIndexSize());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getTotalStaticBloomSize());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getBloomFilterRequestsCount());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getBloomFilterNegativeResultsCount());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getBloomFilterEligibleRequestsCount());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getNumMutationsWithoutWAL());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getDataInMemoryWithoutWAL());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getAverageRegionSize());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getBlockedRequestsCount());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getNumReferenceFiles());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getMemStoreSize());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getOnHeapMemStoreSize());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getOffHeapMemStoreSize());
                Assert.assertEquals((long)expectedForStores, (long)wrapper.getStoreFileSize());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getReadRequestsCount());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getFilteredReadRequestsCount());
                Assert.assertEquals((long)expectedForRegions, (long)wrapper.getWriteRequestsCount());
                Assert.assertEquals((long)(expectedForRegions * 2), (long)wrapper.getTotalRowActionRequestCount());
                Assert.assertEquals((long)(totalStores * (totalStores + 1) / 2), (long)wrapper.getNumStoreFiles());
                Assert.assertEquals((long)totalStores, (long)wrapper.getMaxStoreFiles());
                Assert.assertEquals((long)totalStores, (long)wrapper.getMaxStoreFileAge());
                Assert.assertEquals((long)1L, (long)wrapper.getMinStoreFileAge());
                Assert.assertEquals((long)(totalStores / 2), (long)wrapper.getAvgStoreFileAge());
                Assert.assertEquals((double)50.0, (double)wrapper.getPercentFileLocal(), (double)1.0E-4);
                Assert.assertEquals((double)50.0, (double)wrapper.getPercentFileLocalSecondaryRegions(), (double)1.0E-4);
                Assert.assertEquals((double)((double)numRegions / (double)metricsPeriodSec), (double)wrapper.getReadRequestsRatePerSecond(), (double)1.0E-4);
                Assert.assertEquals((double)((double)numRegions / (double)metricsPeriodSec), (double)wrapper.getWriteRequestsRatePerSecond(), (double)1.0E-4);
                Assert.assertEquals((double)((double)numRegions / (double)metricsPeriodSec * 2.0), (double)wrapper.getRequestsPerSecond(), (double)1.0E-4);
            }
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private HRegion getMockedRegion(Answer defaultAnswer, String name, String localOnHost, boolean isPrimary, AtomicInteger storeFileCount) {
        RegionInfo regionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)regionInfo.getEncodedName()).thenReturn((Object)name);
        if (!isPrimary) {
            Mockito.when((Object)regionInfo.getReplicaId()).thenReturn((Object)1);
        }
        HDFSBlocksDistribution distribution = new HDFSBlocksDistribution();
        distribution.addHostsAndBlockWeight(new String[]{localOnHost}, 100L);
        HStore store = this.getMockedStore(HStore.class, defaultAnswer, storeFileCount);
        HMobStore mobStore = this.getMockedStore(HMobStore.class, defaultAnswer, storeFileCount);
        HRegion region = (HRegion)Mockito.mock(HRegion.class, (Answer)defaultAnswer);
        Mockito.when((Object)region.getRegionInfo()).thenReturn((Object)regionInfo);
        Mockito.when((Object)region.getHDFSBlocksDistribution()).thenReturn((Object)distribution);
        Mockito.when((Object)region.getStores()).thenReturn((Object)Lists.newArrayList((Object[])new HStore[]{store, mobStore}));
        return region;
    }

    private <T extends HStore> T getMockedStore(Class<T> clazz, Answer defaultAnswer, AtomicInteger storeFileCount) {
        HStore store = (HStore)Mockito.mock(clazz, (Answer)defaultAnswer);
        int storeFileCountVal = storeFileCount.getAndIncrement();
        Mockito.when((Object)store.getStorefilesCount()).thenReturn((Object)storeFileCountVal);
        Mockito.when((Object)store.getAvgStoreFileAge()).thenReturn((Object)OptionalDouble.of(storeFileCountVal));
        Mockito.when((Object)store.getMaxStoreFileAge()).thenReturn((Object)OptionalLong.of(storeFileCountVal));
        Mockito.when((Object)store.getMinStoreFileAge()).thenReturn((Object)OptionalLong.of(storeFileCountVal));
        MemStoreSize memStore = (MemStoreSize)Mockito.mock(MemStoreSize.class, (Answer)defaultAnswer);
        Mockito.when((Object)store.getMemStoreSize()).thenReturn((Object)memStore);
        return (T)store;
    }
}

