/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.asyncfs.monitor.ExcludeDatanodeManager;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestExcludeDatanodeManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExcludeDatanodeManager.class);

    @Test
    public void testExcludeSlowDNBySpeed() {
        Configuration conf = HBaseConfiguration.create();
        ExcludeDatanodeManager excludeDatanodeManager = new ExcludeDatanodeManager(conf);
        StreamSlowMonitor streamSlowDNsMonitor = excludeDatanodeManager.getStreamSlowMonitor("testMonitor");
        Assert.assertEquals((long)0L, (long)excludeDatanodeManager.getExcludeDNs().size());
        DatanodeInfo datanodeInfo = new DatanodeInfo.DatanodeInfoBuilder().setIpAddr("0.0.0.0").setHostName("hostname1").setDatanodeUuid("uuid1").setXferPort(111).setInfoPort(222).setInfoSecurePort(333).setIpcPort(444).setNetworkLocation("location1").build();
        streamSlowDNsMonitor.checkProcessTimeAndSpeed(datanodeInfo, 100000L, 5100L, System.currentTimeMillis() - 5100L, 0);
        streamSlowDNsMonitor.checkProcessTimeAndSpeed(datanodeInfo, 100000L, 5100L, System.currentTimeMillis() - 5100L, 0);
        streamSlowDNsMonitor.checkProcessTimeAndSpeed(datanodeInfo, 100000L, 5100L, System.currentTimeMillis() - 5100L, 0);
        Assert.assertEquals((long)1L, (long)excludeDatanodeManager.getExcludeDNs().size());
        Assert.assertTrue((boolean)excludeDatanodeManager.getExcludeDNs().containsKey(datanodeInfo));
    }

    @Test
    public void testExcludeSlowDNByProcessTime() {
        Configuration conf = HBaseConfiguration.create();
        ExcludeDatanodeManager excludeDatanodeManager = new ExcludeDatanodeManager(conf);
        StreamSlowMonitor streamSlowDNsMonitor = excludeDatanodeManager.getStreamSlowMonitor("testMonitor");
        Assert.assertEquals((long)0L, (long)excludeDatanodeManager.getExcludeDNs().size());
        DatanodeInfo datanodeInfo = new DatanodeInfo.DatanodeInfoBuilder().setIpAddr("0.0.0.0").setHostName("hostname1").setDatanodeUuid("uuid1").setXferPort(111).setInfoPort(222).setInfoSecurePort(333).setIpcPort(444).setNetworkLocation("location1").build();
        streamSlowDNsMonitor.checkProcessTimeAndSpeed(datanodeInfo, 5000L, 7000L, System.currentTimeMillis() - 7000L, 0);
        streamSlowDNsMonitor.checkProcessTimeAndSpeed(datanodeInfo, 5000L, 7000L, System.currentTimeMillis() - 7000L, 0);
        streamSlowDNsMonitor.checkProcessTimeAndSpeed(datanodeInfo, 5000L, 7000L, System.currentTimeMillis() - 7000L, 0);
        Assert.assertEquals((long)1L, (long)excludeDatanodeManager.getExcludeDNs().size());
        Assert.assertTrue((boolean)excludeDatanodeManager.getExcludeDNs().containsKey(datanodeInfo));
    }
}

