/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.util.ByteList;

public abstract class IOChannel
implements Channel {
    protected final IRubyObject io;
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");
    private final RespondToCallSite respondToClosed = new RespondToCallSite("closed?");
    private final CallSite isClosedAdapter = MethodIndex.getFunctionalCallSite("closed?");
    protected final Ruby runtime;

    protected IOChannel(IRubyObject io2) {
        this.io = io2;
        this.runtime = io2.getRuntime();
    }

    @Override
    public void close() throws IOException {
        ThreadContext context = this.runtime.getCurrentContext();
        if (this.io.respondsTo("close")) {
            this.closeAdapter.call(context, this.io, this.io);
        }
    }

    @Override
    public boolean isOpen() {
        ThreadContext context = this.runtime.getCurrentContext();
        if (this.respondToClosed.respondsTo(context, this.io, this.io)) {
            return !this.isClosedAdapter.call(context, this.io, this.io).isTrue();
        }
        return true;
    }

    protected static int read(Ruby runtime2, IRubyObject io2, CallSite read2, ByteBuffer dst) {
        IRubyObject readValue = read2.call(runtime2.getCurrentContext(), io2, io2, (IRubyObject)runtime2.newFixnum(dst.remaining()));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = ((RubyString)readValue).getByteList();
            dst.put(str.getUnsafeBytes(), str.getBegin(), str.getRealSize());
            returnValue = str.getRealSize();
        }
        return returnValue;
    }

    protected static int write(Ruby runtime2, IRubyObject io2, CallSite write2, ByteBuffer src) {
        ByteList buffer;
        int position = src.position();
        int remaining = src.remaining();
        if (src.hasArray()) {
            buffer = new ByteList(src.array(), src.position(), remaining, true);
        } else {
            buffer = new ByteList(remaining);
            buffer.append(src, remaining);
        }
        IRubyObject written = write2.call(runtime2.getCurrentContext(), io2, io2, (IRubyObject)RubyString.newStringLight(runtime2, buffer));
        int wrote = written.convertToInteger().getIntValue();
        if (wrote > 0) {
            src.position(position + wrote);
        }
        return wrote;
    }

    protected CallSite initReadSite(String readMethod) {
        if (this.io.respondsTo(readMethod)) {
            return MethodIndex.getFunctionalCallSite(readMethod);
        }
        throw new IllegalArgumentException(this.io.getMetaClass() + "not coercible to " + this.getClass().getSimpleName() + ": no `" + readMethod + "' method");
    }

    protected CallSite initWriteSite() {
        if (this.io.respondsTo("write")) {
            return MethodIndex.getFunctionalCallSite("write");
        }
        if (this.io.respondsTo("<<")) {
            return MethodIndex.getFunctionalCallSite("<<");
        }
        throw new IllegalArgumentException(this.io.getMetaClass() + "not coercible to " + this.getClass().getSimpleName() + ": no `write' method");
    }

    public static class IOReadableWritableByteChannel
    extends IOChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        private final CallSite write;
        private final CallSite read = this.initReadSite("read");

        public IOReadableWritableByteChannel(IRubyObject io2) {
            super(io2);
            this.write = this.initWriteSite();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return IOReadableWritableByteChannel.read(this.runtime, this.io, this.read, dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return IOReadableWritableByteChannel.write(this.runtime, this.io, this.write, src);
        }
    }

    public static class IOWritableByteChannel
    extends IOChannel
    implements WritableByteChannel {
        private final CallSite write = this.initWriteSite();

        public IOWritableByteChannel(IRubyObject io2) {
            super(io2);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return IOWritableByteChannel.write(this.runtime, this.io, this.write, src);
        }
    }

    public static class IOReadableByteChannel
    extends IOChannel
    implements ReadableByteChannel {
        private final CallSite read;

        public IOReadableByteChannel(IRubyObject io2) {
            this(io2, "read");
        }

        public IOReadableByteChannel(IRubyObject io2, String readMethod) {
            super(io2);
            this.read = this.initReadSite(readMethod);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return IOReadableByteChannel.read(this.runtime, this.io, this.read, dst);
        }
    }
}

