/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReopenTableRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.ReopenTableRegionsState> {
    private static final Logger LOG = LoggerFactory.getLogger(ReopenTableRegionsProcedure.class);
    private TableName tableName;
    private List<byte[]> regionNames;
    private List<HRegionLocation> regions = Collections.emptyList();
    private RetryCounter retryCounter;

    public ReopenTableRegionsProcedure() {
        this.regionNames = Collections.emptyList();
    }

    public ReopenTableRegionsProcedure(TableName tableName) {
        this.tableName = tableName;
        this.regionNames = Collections.emptyList();
    }

    public ReopenTableRegionsProcedure(TableName tableName, List<byte[]> regionNames) {
        this.tableName = tableName;
        this.regionNames = regionNames;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    private boolean canSchedule(MasterProcedureEnv env, HRegionLocation loc) {
        if (loc.getSeqNum() < 0L) {
            return false;
        }
        RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(loc.getRegion());
        return regionNode == null || !regionNode.isInTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ReopenTableRegionsState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        switch (state) {
            case REOPEN_TABLE_REGIONS_GET_REGIONS: {
                if (!this.isTableEnabled(env)) {
                    LOG.info("Table {} is disabled, give up reopening its regions", (Object)this.tableName);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                List<HRegionLocation> tableRegions = env.getAssignmentManager().getRegionStates().getRegionsOfTableForReopen(this.tableName);
                this.regions = this.getRegionLocationsForReopen(tableRegions);
                this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_REOPEN_REGIONS);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REOPEN_TABLE_REGIONS_REOPEN_REGIONS: {
                for (HRegionLocation loc2 : this.regions) {
                    TransitRegionStateProcedure proc;
                    RegionStateNode regionNode = env.getAssignmentManager().getRegionStates().getRegionStateNode(loc2.getRegion());
                    if (regionNode == null) continue;
                    regionNode.lock();
                    try {
                        if (regionNode.getProcedure() != null) continue;
                        proc = TransitRegionStateProcedure.reopen(env, regionNode.getRegionInfo());
                        regionNode.setProcedure(proc);
                    }
                    finally {
                        regionNode.unlock();
                        continue;
                    }
                    this.addChildProcedure(new TransitRegionStateProcedure[]{proc});
                }
                this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_CONFIRM_REOPENED);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REOPEN_TABLE_REGIONS_CONFIRM_REOPENED: {
                this.regions = this.regions.stream().map(env.getAssignmentManager().getRegionStates()::checkReopened).filter(l -> l != null).collect(Collectors.toList());
                if (this.regions.isEmpty()) {
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                if (this.regions.stream().anyMatch(loc -> this.canSchedule(env, (HRegionLocation)loc))) {
                    this.retryCounter = null;
                    this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_REOPEN_REGIONS);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                if (this.retryCounter == null) {
                    this.retryCounter = ProcedureUtil.createRetryCounter(env.getMasterConfiguration());
                }
                long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
                LOG.info("There are still {} region(s) which need to be reopened for table {} are in OPENING state, suspend {}secs and try again later", new Object[]{this.regions.size(), this.tableName, backoff / 1000L});
                this.setTimeout(Math.toIntExact(backoff));
                this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                this.skipPersistence();
                throw new ProcedureSuspendedException();
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    private List<HRegionLocation> getRegionLocationsForReopen(List<HRegionLocation> tableRegionsForReopen) {
        ArrayList<HRegionLocation> regionsToReopen = new ArrayList();
        if (CollectionUtils.isNotEmpty(this.regionNames) && CollectionUtils.isNotEmpty(tableRegionsForReopen)) {
            block0: for (byte[] regionName : this.regionNames) {
                for (HRegionLocation hRegionLocation : tableRegionsForReopen) {
                    if (!Bytes.equals(regionName, hRegionLocation.getRegion().getRegionName())) continue;
                    regionsToReopen.add(hRegionLocation);
                    continue block0;
                }
            }
        } else {
            regionsToReopen = tableRegionsForReopen;
        }
        return regionsToReopen;
    }

    @Override
    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront(this);
        return false;
    }

    @Override
    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ReopenTableRegionsState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    @Override
    protected MasterProcedureProtos.ReopenTableRegionsState getState(int stateId) {
        return MasterProcedureProtos.ReopenTableRegionsState.forNumber(stateId);
    }

    @Override
    protected int getStateId(MasterProcedureProtos.ReopenTableRegionsState state) {
        return state.getNumber();
    }

    @Override
    protected MasterProcedureProtos.ReopenTableRegionsState getInitialState() {
        return MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_GET_REGIONS;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ReopenTableRegionsStateData.Builder builder = MasterProcedureProtos.ReopenTableRegionsStateData.newBuilder().setTableName(ProtobufUtil.toProtoTableName(this.tableName));
        this.regions.stream().map(ProtobufUtil::toRegionLocation).forEachOrdered(builder::addRegion);
        if (CollectionUtils.isNotEmpty(this.regionNames)) {
            this.regionNames.stream().map(ByteString::copyFrom).forEachOrdered(builder::addRegionNames);
        }
        serializer.serialize(builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ReopenTableRegionsStateData data = serializer.deserialize(MasterProcedureProtos.ReopenTableRegionsStateData.class);
        this.tableName = ProtobufUtil.toTableName(data.getTableName());
        this.regions = data.getRegionList().stream().map(ProtobufUtil::toRegionLocation).collect(Collectors.toList());
        this.regionNames = CollectionUtils.isNotEmpty(data.getRegionNamesList()) ? data.getRegionNamesList().stream().map(ByteString::toByteArray).collect(Collectors.toList()) : Collections.emptyList();
    }
}

