/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotCleanupProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SnapshotCleanupTracker
extends ZKNodeTracker {
    public SnapshotCleanupTracker(ZKWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getZNodePaths().snapshotCleanupZNode, abortable);
    }

    public boolean isSnapshotCleanupEnabled() {
        byte[] snapshotCleanupZNodeData = super.getData(false);
        try {
            return snapshotCleanupZNodeData == null || this.parseFrom(snapshotCleanupZNodeData).getSnapshotCleanupEnabled();
        }
        catch (DeserializationException dex) {
            LOG.error("ZK state for Snapshot Cleanup could not be parsed " + Bytes.toStringBinary(snapshotCleanupZNodeData), (Throwable)dex);
            return false;
        }
    }

    public void setSnapshotCleanupEnabled(boolean snapshotCleanupEnabled) throws KeeperException {
        byte[] snapshotCleanupZNodeData = this.toByteArray(snapshotCleanupEnabled);
        try {
            ZKUtil.setData(this.watcher, this.watcher.getZNodePaths().snapshotCleanupZNode, snapshotCleanupZNodeData);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createAndWatch(this.watcher, this.watcher.getZNodePaths().snapshotCleanupZNode, snapshotCleanupZNodeData);
        }
        super.nodeDataChanged(this.watcher.getZNodePaths().snapshotCleanupZNode);
    }

    private byte[] toByteArray(boolean isSnapshotCleanupEnabled) {
        SnapshotCleanupProtos.SnapshotCleanupState.Builder builder = SnapshotCleanupProtos.SnapshotCleanupState.newBuilder();
        builder.setSnapshotCleanupEnabled(isSnapshotCleanupEnabled);
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    private SnapshotCleanupProtos.SnapshotCleanupState parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(pbBytes);
        SnapshotCleanupProtos.SnapshotCleanupState.Builder builder = SnapshotCleanupProtos.SnapshotCleanupState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom(builder, pbBytes, magicLen, pbBytes.length - magicLen);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return builder.build();
    }
}

