/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mapreduce.JobUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class CompactionTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionTool.class);
    private static final String CONF_COMPACT_ONCE = "hbase.compactiontool.compact.once";
    private static final String CONF_COMPACT_MAJOR = "hbase.compactiontool.compact.major";
    private static final String CONF_DELETE_COMPACTED = "hbase.compactiontool.delete";

    private static boolean isRegionDir(FileSystem fs, Path path) throws IOException {
        Path regionInfo = new Path(path, ".regioninfo");
        return fs.exists(regionInfo);
    }

    private static boolean isTableDir(FileSystem fs, Path path) throws IOException {
        return FSTableDescriptors.isTableDir((FileSystem)fs, (Path)path);
    }

    private static boolean isFamilyDir(FileSystem fs, Path path) throws IOException {
        return CompactionTool.isRegionDir(fs, path.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doMapReduce(FileSystem fs, Set<Path> toCompactDirs, boolean compactOnce, boolean major) throws Exception {
        Configuration conf = this.getConf();
        conf.setBoolean(CONF_COMPACT_ONCE, compactOnce);
        conf.setBoolean(CONF_COMPACT_MAJOR, major);
        Job job = new Job(conf);
        job.setJobName("CompactionTool");
        job.setJarByClass(CompactionTool.class);
        job.setMapperClass(CompactionMapper.class);
        job.setInputFormatClass(CompactionInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setMapSpeculativeExecution(false);
        job.setNumReduceTasks(0);
        TableMapReduceUtil.addDependencyJars(job);
        Path stagingDir = JobUtil.getQualifiedStagingDir((Configuration)conf);
        FileSystem stagingFs = stagingDir.getFileSystem(conf);
        try {
            Path inputPath = new Path(stagingDir, "compact-" + EnvironmentEdgeManager.currentTime());
            List<Path> storeDirs = CompactionInputFormat.createInputFile(fs, stagingFs, inputPath, toCompactDirs);
            CompactionInputFormat.addInputPath((Job)job, (Path)inputPath);
            TableMapReduceUtil.initCredentials(job);
            TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])storeDirs.toArray(new Path[0]), (Configuration)conf);
            int n = job.waitForCompletion(true) ? 0 : 1;
            return n;
        }
        finally {
            fs.delete(stagingDir, true);
        }
    }

    private int doClient(FileSystem fs, Set<Path> toCompactDirs, boolean compactOnce, boolean major) throws IOException {
        this.getConf().setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        CompactionWorker worker = new CompactionWorker(fs, this.getConf());
        for (Path path : toCompactDirs) {
            worker.compact(path, compactOnce, major);
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        HashSet<Path> toCompactDirs = new HashSet<Path>();
        boolean compactOnce = false;
        boolean major = false;
        boolean mapred = false;
        Configuration conf = this.getConf();
        FileSystem fs = CommonFSUtils.getRootDirFileSystem((Configuration)conf);
        try {
            for (int i = 0; i < args.length; ++i) {
                String opt = args[i];
                if (opt.equals("-compactOnce")) {
                    compactOnce = true;
                    continue;
                }
                if (opt.equals("-major")) {
                    major = true;
                    continue;
                }
                if (opt.equals("-mapred")) {
                    mapred = true;
                    continue;
                }
                if (!opt.startsWith("-")) {
                    Path path = new Path(opt);
                    FileStatus status = fs.getFileStatus(path);
                    if (!status.isDirectory()) {
                        this.printUsage("Specified path is not a directory. path=" + path);
                        return 1;
                    }
                    toCompactDirs.add(path);
                    continue;
                }
                this.printUsage();
            }
        }
        catch (Exception e) {
            this.printUsage(e.getMessage());
            return 1;
        }
        if (toCompactDirs.isEmpty()) {
            this.printUsage("No directories to compact specified.");
            return 1;
        }
        if (mapred) {
            return this.doMapReduce(fs, toCompactDirs, compactOnce, major);
        }
        return this.doClient(fs, toCompactDirs, compactOnce, major);
    }

    private void printUsage() {
        this.printUsage(null);
    }

    private void printUsage(String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: java " + ((Object)((Object)this)).getClass().getName() + " \\");
        System.err.println("  [-compactOnce] [-major] [-mapred] [-D<property=value>]* files...");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" mapred         Use MapReduce to run compaction.");
        System.err.println(" compactOnce    Execute just one compaction step. (default: while needed)");
        System.err.println(" major          Trigger major compaction.");
        System.err.println();
        System.err.println("Note: -D properties will be applied to the conf used. ");
        System.err.println("For example: ");
        System.err.println(" To stop delete of compacted file, pass -Dhbase.compactiontool.delete=false");
        System.err.println();
        System.err.println("Examples:");
        System.err.println(" To compact the full 'TestTable' using MapReduce:");
        System.err.println(" $ hbase " + ((Object)((Object)this)).getClass().getName() + " -mapred hdfs://hbase/data/default/TestTable");
        System.err.println();
        System.err.println(" To compact column family 'x' of the table 'TestTable' region 'abc':");
        System.err.println(" $ hbase " + ((Object)((Object)this)).getClass().getName() + " hdfs://hbase/data/default/TestTable/abc/x");
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new CompactionTool(), (String[])args));
    }

    private static class CompactionInputFormat
    extends TextInputFormat {
        private CompactionInputFormat() {
        }

        protected boolean isSplitable(JobContext context, Path file) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<InputSplit> getSplits(JobContext job) throws IOException {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            List files = this.listStatus(job);
            Text key = new Text();
            for (FileStatus file : files) {
                Path path = file.getPath();
                FileSystem fs = path.getFileSystem(job.getConfiguration());
                long pos = 0L;
                try (LineReader reader = new LineReader((InputStream)fs.open(path));){
                    int n;
                    while ((n = reader.readLine(key)) > 0) {
                        String[] hosts = CompactionInputFormat.getStoreDirHosts(fs, path);
                        splits.add((InputSplit)new FileSplit(path, pos, (long)n, hosts));
                        pos += (long)n;
                    }
                }
            }
            return splits;
        }

        private static String[] getStoreDirHosts(FileSystem fs, Path path) throws IOException {
            FileStatus[] files = CommonFSUtils.listStatus((FileSystem)fs, (Path)path);
            if (files == null) {
                return new String[0];
            }
            HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
            for (FileStatus hfileStatus : files) {
                HDFSBlocksDistribution storeFileBlocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, (FileStatus)hfileStatus, (long)0L, (long)hfileStatus.getLen());
                hdfsBlocksDistribution.add(storeFileBlocksDistribution);
            }
            List hosts = hdfsBlocksDistribution.getTopHosts();
            return hosts.toArray(new String[hosts.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static List<Path> createInputFile(FileSystem fs, FileSystem stagingFs, Path path, Set<Path> toCompactDirs) throws IOException {
            LinkedList<Path> storeDirs = new LinkedList<Path>();
            for (Path compactDir : toCompactDirs) {
                if (CompactionTool.isFamilyDir(fs, compactDir)) {
                    storeDirs.add(compactDir);
                    continue;
                }
                if (CompactionTool.isRegionDir(fs, compactDir)) {
                    storeDirs.addAll(FSUtils.getFamilyDirs((FileSystem)fs, (Path)compactDir));
                    continue;
                }
                if (CompactionTool.isTableDir(fs, compactDir)) {
                    for (Path regionDir : FSUtils.getRegionDirs((FileSystem)fs, (Path)compactDir)) {
                        storeDirs.addAll(FSUtils.getFamilyDirs((FileSystem)fs, (Path)regionDir));
                    }
                    continue;
                }
                throw new IOException("Specified path is not a table, region or family directory. path=" + compactDir);
            }
            LOG.info("Create input file=" + path + " with " + storeDirs.size() + " dirs to compact.");
            try (FSDataOutputStream stream = stagingFs.create(path);){
                byte[] newLine = Bytes.toBytes((String)"\n");
                for (Path storeDir : storeDirs) {
                    stream.write(Bytes.toBytes((String)storeDir.toString()));
                    stream.write(newLine);
                }
            }
            return storeDirs;
        }
    }

    private static class CompactionMapper
    extends Mapper<LongWritable, Text, NullWritable, NullWritable> {
        private CompactionWorker compactor = null;
        private boolean compactOnce = false;
        private boolean major = false;

        private CompactionMapper() {
        }

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.compactOnce = conf.getBoolean(CompactionTool.CONF_COMPACT_ONCE, false);
            this.major = conf.getBoolean(CompactionTool.CONF_COMPACT_MAJOR, false);
            try {
                FileSystem fs = CommonFSUtils.getRootDirFileSystem((Configuration)conf);
                this.compactor = new CompactionWorker(fs, conf);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not get the input FileSystem", e);
            }
            conf.setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws InterruptedException, IOException {
            Path path = new Path(value.toString());
            this.compactor.compact(path, this.compactOnce, this.major);
        }
    }

    private static class CompactionWorker {
        private final boolean deleteCompacted;
        private final Configuration conf;
        private final FileSystem fs;

        public CompactionWorker(FileSystem fs, Configuration conf) {
            this.conf = conf;
            this.deleteCompacted = conf.getBoolean(CompactionTool.CONF_DELETE_COMPACTED, false);
            this.fs = fs;
        }

        public void compact(Path path, boolean compactOnce, boolean major) throws IOException {
            if (CompactionTool.isFamilyDir(this.fs, path)) {
                Path regionDir = path.getParent();
                Path tableDir = regionDir.getParent();
                TableDescriptor htd = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)this.fs, (Path)tableDir);
                RegionInfo hri = HRegionFileSystem.loadRegionInfoFileContent((FileSystem)this.fs, (Path)regionDir);
                this.compactStoreFiles(tableDir, htd, hri, path.getName(), compactOnce, major);
            } else if (CompactionTool.isRegionDir(this.fs, path)) {
                Path tableDir = path.getParent();
                TableDescriptor htd = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)this.fs, (Path)tableDir);
                this.compactRegion(tableDir, htd, path, compactOnce, major);
            } else if (CompactionTool.isTableDir(this.fs, path)) {
                this.compactTable(path, compactOnce, major);
            } else {
                throw new IOException("Specified path is not a table, region or family directory. path=" + path);
            }
        }

        private void compactTable(Path tableDir, boolean compactOnce, boolean major) throws IOException {
            TableDescriptor htd = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)this.fs, (Path)tableDir);
            for (Path regionDir : FSUtils.getRegionDirs((FileSystem)this.fs, (Path)tableDir)) {
                this.compactRegion(tableDir, htd, regionDir, compactOnce, major);
            }
        }

        private void compactRegion(Path tableDir, TableDescriptor htd, Path regionDir, boolean compactOnce, boolean major) throws IOException {
            RegionInfo hri = HRegionFileSystem.loadRegionInfoFileContent((FileSystem)this.fs, (Path)regionDir);
            for (Path familyDir : FSUtils.getFamilyDirs((FileSystem)this.fs, (Path)regionDir)) {
                this.compactStoreFiles(tableDir, htd, hri, familyDir.getName(), compactOnce, major);
            }
        }

        private void compactStoreFiles(Path tableDir, TableDescriptor htd, RegionInfo hri, String familyName, boolean compactOnce, boolean major) throws IOException {
            Optional compaction;
            HStore store = CompactionWorker.getStore(this.conf, this.fs, tableDir, htd, hri, familyName);
            LOG.info("Compact table=" + htd.getTableName() + " region=" + hri.getRegionNameAsString() + " family=" + familyName);
            if (major) {
                store.triggerMajorCompaction();
            }
            while ((compaction = store.requestCompaction(1, CompactionLifeCycleTracker.DUMMY, null)).isPresent()) {
                List storeFiles = store.compact((CompactionContext)compaction.get(), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
                if (storeFiles != null && !storeFiles.isEmpty() && this.deleteCompacted) {
                    for (HStoreFile storeFile : storeFiles) {
                        this.fs.delete(storeFile.getPath(), false);
                    }
                }
                if (store.needsCompaction() && !compactOnce) continue;
            }
            store.close();
        }

        private static HStore getStore(Configuration conf, FileSystem fs, Path tableDir, TableDescriptor htd, RegionInfo hri, String familyName) throws IOException {
            HRegionFileSystem regionFs = new HRegionFileSystem(conf, fs, tableDir, hri);
            HRegion region = new HRegion(regionFs, null, conf, htd, null);
            return new HStore(region, htd.getColumnFamily(Bytes.toBytes((String)familyName)), conf, false);
        }
    }
}

